/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.AliasList;
import org.musicbrainz.mmd2.AreaList;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.Iso31661CodeList;
import org.musicbrainz.mmd2.Iso31662CodeList;
import org.musicbrainz.mmd2.Iso31663CodeList;
import org.musicbrainz.mmd2.LifeSpan;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.AreaIndexField;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.Utils;

public class AreaIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "area";

    public AreaIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public AreaIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public IndexField getIdentifierField() {
        return AreaIndexField.ID;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(AreaIndexField.class);
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM area");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM area WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("AREA", "SELECT a.id, a.gid, a.name, a.sort_name, a.comment as comment, at.name as type,    begin_date_year, begin_date_month, begin_date_day,   end_date_year, end_date_month, end_date_day, ended FROM area a  LEFT JOIN area_type at ON a.type = at.id  WHERE a.id BETWEEN ? AND ?  ORDER BY a.id");
        this.addPreparedStatement("ALIASES", "SELECT a.area as area, a.name as alias, a.sort_name as alias_sortname, a.primary_for_locale, a.locale, att.name as type,a.begin_date_year, a.begin_date_month, a.begin_date_day, a.end_date_year, a.end_date_month, a.end_date_day FROM area_alias a  LEFT JOIN area_alias_type att on (a.type=att.id) WHERE area BETWEEN ? AND ? ORDER BY area, alias, alias_sortname");
        this.addPreparedStatement("ISO1", "SELECT area, code from iso_3166_1 WHERE area BETWEEN ? AND ? ORDER BY area, code");
        this.addPreparedStatement("ISO2", "SELECT area, code from iso_3166_2 WHERE area BETWEEN ? AND ? ORDER BY area, code");
        this.addPreparedStatement("ISO3", "SELECT area, code from iso_3166_3 WHERE area BETWEEN ? AND ? ORDER BY area, code");
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        ObjectFactory of = new ObjectFactory();
        HashMap<Integer, Set<Alias>> aliases = new HashMap<Integer, Set<Alias>>();
        PreparedStatement st = this.getPreparedStatement("ALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            String end;
            String begin;
            String type;
            String locale;
            Set<Alias> list;
            int areaId = rs.getInt(INDEX_NAME);
            if (!aliases.containsKey(areaId)) {
                list = new LinkedHashSet();
                aliases.put(areaId, list);
            } else {
                list = (Set)aliases.get(areaId);
            }
            Alias alias = of.createAlias();
            alias.setContent(rs.getString("alias"));
            alias.setSortName(rs.getString("alias_sortname"));
            boolean isPrimary = rs.getBoolean("primary_for_locale");
            if (isPrimary) {
                alias.setPrimary("primary");
            }
            if ((locale = rs.getString("locale")) != null) {
                alias.setLocale(locale);
            }
            if ((type = rs.getString("type")) != null) {
                alias.setType(type);
            }
            if (!Strings.isNullOrEmpty(begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day")))) {
                alias.setBeginDate(begin);
            }
            if (!Strings.isNullOrEmpty(end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day")))) {
                alias.setEndDate(end);
            }
            list.add(alias);
        }
        rs.close();
        HashMap<Integer, Iso31661CodeList> iso1 = new HashMap<Integer, Iso31661CodeList>();
        st = this.getPreparedStatement("ISO1");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            Iso31661CodeList iso1List;
            int areaId = rs.getInt(INDEX_NAME);
            if (!iso1.containsKey(areaId)) {
                iso1List = of.createIso31661CodeList();
                iso1.put(areaId, iso1List);
            } else {
                iso1List = (Iso31661CodeList)iso1.get(areaId);
            }
            iso1List.getIso31661Code().add(rs.getString("code"));
        }
        HashMap<Integer, Iso31662CodeList> iso2 = new HashMap<Integer, Iso31662CodeList>();
        st = this.getPreparedStatement("ISO2");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            Iso31662CodeList iso2List;
            int areaId = rs.getInt(INDEX_NAME);
            if (!iso2.containsKey(areaId)) {
                iso2List = of.createIso31662CodeList();
                iso2.put(areaId, iso2List);
            } else {
                iso2List = (Iso31662CodeList)iso2.get(areaId);
            }
            iso2List.getIso31662Code().add(rs.getString("code"));
        }
        HashMap<Integer, Iso31663CodeList> iso3 = new HashMap<Integer, Iso31663CodeList>();
        st = this.getPreparedStatement("ISO3");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            Iso31663CodeList iso3List;
            int areaId = rs.getInt(INDEX_NAME);
            if (!iso3.containsKey(areaId)) {
                iso3List = of.createIso31663CodeList();
                iso3.put(areaId, iso3List);
            } else {
                iso3List = (Iso31663CodeList)iso3.get(areaId);
            }
            iso3List.getIso31663Code().add(rs.getString("code"));
        }
        st = this.getPreparedStatement("AREA");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, aliases, iso1, iso2, iso3));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, Set<Alias>> aliases, Map<Integer, Iso31661CodeList> iso1, Map<Integer, Iso31662CodeList> iso2, Map<Integer, Iso31663CodeList> iso3) throws SQLException {
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        AreaList areaList = of.createAreaList();
        DefAreaElementInner area = of.createDefAreaElementInner();
        areaList.getArea().add(area);
        int areaId = rs.getInt("id");
        doc.addField((IndexField)AreaIndexField.ID, areaId);
        String guid = rs.getString("gid");
        doc.addField((IndexField)AreaIndexField.AREA_ID, guid);
        area.setId(guid);
        String name = rs.getString("name");
        doc.addField((IndexField)AreaIndexField.AREA, name);
        area.setName(name);
        String sortName = rs.getString("sort_name");
        doc.addField((IndexField)AreaIndexField.SORTNAME, sortName);
        area.setSortName(sortName);
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(AreaIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            area.setDisambiguation(comment);
        }
        String type = rs.getString("type");
        doc.addFieldOrUnknown(AreaIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            area.setType(type);
        }
        boolean ended = rs.getBoolean("ended");
        doc.addFieldOrUnknown(ArtistIndexField.ENDED, Boolean.toString(ended));
        String begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day"));
        doc.addNonEmptyField(ArtistIndexField.BEGIN, begin);
        String end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day"));
        doc.addNonEmptyField(ArtistIndexField.END, end);
        LifeSpan lifespan = of.createLifeSpan();
        area.setLifeSpan(lifespan);
        if (!Strings.isNullOrEmpty(begin)) {
            lifespan.setBegin(begin);
        }
        if (!Strings.isNullOrEmpty(end)) {
            lifespan.setEnd(end);
        }
        lifespan.setEnded(Boolean.toString(ended));
        if (aliases.containsKey(areaId)) {
            AliasList aliasList = of.createAliasList();
            for (Alias nextAlias : aliases.get(areaId)) {
                doc.addField((IndexField)AreaIndexField.ALIAS, nextAlias.getContent());
                if (!nextAlias.getSortName().equals(nextAlias.getContent())) {
                    doc.addField((IndexField)AreaIndexField.ALIAS, nextAlias.getSortName());
                }
                aliasList.getAlias().add(nextAlias);
            }
            area.setAliasList(aliasList);
        }
        if (iso1.containsKey(areaId)) {
            area.setIso31661CodeList(iso1.get(areaId));
            for (String iso : iso1.get(areaId).getIso31661Code()) {
                doc.addField((IndexField)AreaIndexField.ISO, iso);
                doc.addField((IndexField)AreaIndexField.ISO1, iso);
            }
        }
        if (iso2.containsKey(areaId)) {
            area.setIso31662CodeList(iso2.get(areaId));
            for (String iso : iso2.get(areaId).getIso31662Code()) {
                doc.addField((IndexField)AreaIndexField.ISO, iso);
                doc.addField((IndexField)AreaIndexField.ISO2, iso);
            }
        }
        if (iso3.containsKey(areaId)) {
            area.setIso31663CodeList(iso3.get(areaId));
            for (String iso : iso3.get(areaId).getIso31663Code()) {
                doc.addField((IndexField)AreaIndexField.ISO, iso);
                doc.addField((IndexField)AreaIndexField.ISO3, iso);
            }
        }
        String store = MMDSerializer.serialize(areaList);
        doc.addField((IndexField)AreaIndexField.AREA_STORE, store);
        return doc.getLuceneDocument();
    }
}

