/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.RuleBasedTransliterator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class ICUTransformFilter
extends TokenFilter {
    private final Transliterator transform;
    private final Transliterator.Position position = new Transliterator.Position();
    private final ReplaceableTermAttribute replaceableAttribute = new ReplaceableTermAttribute();
    private CharTermAttribute termAtt;

    public ICUTransformFilter(TokenStream input, Transliterator transform) {
        super(input);
        UnicodeSet sourceSet;
        this.transform = transform;
        this.termAtt = this.addAttribute(CharTermAttribute.class);
        if (transform.getFilter() == null && transform instanceof RuleBasedTransliterator && (sourceSet = transform.getSourceSet()) != null && !sourceSet.isEmpty()) {
            transform.setFilter(sourceSet);
        }
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            int length = this.termAtt.length();
            this.replaceableAttribute.setText(this.termAtt);
            this.position.start = 0;
            this.position.limit = length;
            this.position.contextStart = 0;
            this.position.contextLimit = length;
            this.transform.filteredTransliterate(this.replaceableAttribute, this.position, false);
            this.termAtt.setLength(this.replaceableAttribute.length());
            return true;
        }
        return false;
    }

    public static int getNextSize(int targetSize) {
        return (targetSize >> 3) + (targetSize < 9 ? 3 : 6) + targetSize;
    }

    final class ReplaceableTermAttribute
    implements Replaceable {
        private char[] buffer;
        private int length;
        private CharTermAttribute token;

        ReplaceableTermAttribute() {
        }

        void setText(CharTermAttribute reusableToken) {
            this.token = reusableToken;
            this.buffer = reusableToken.buffer();
            this.length = reusableToken.length();
        }

        @Override
        public int char32At(int pos) {
            return UTF16.charAt(this.buffer, 0, this.length, pos);
        }

        @Override
        public char charAt(int pos) {
            return this.buffer[pos];
        }

        @Override
        public void copy(int start, int limit, int dest) {
            char[] text = new char[limit - start];
            this.getChars(start, limit, text, 0);
            this.replace(dest, dest, text, 0, limit - start);
        }

        @Override
        public void getChars(int srcStart, int srcLimit, char[] dst, int dstStart) {
            System.arraycopy(this.buffer, srcStart, dst, dstStart, srcLimit - srcStart);
        }

        @Override
        public boolean hasMetaData() {
            return false;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public void replace(int start, int limit, String text) {
            this.replace(start, limit, text.toCharArray(), 0, text.length());
        }

        @Override
        public void replace(int start, int limit, char[] text, int charsStart, int charsLen) {
            int replacementLength = limit - start;
            int newLength = this.length - replacementLength + charsLen;
            if (newLength > this.length) {
                this.buffer = this.token.resizeBuffer(ICUTransformFilter.getNextSize(newLength));
            }
            if (replacementLength != charsLen && limit < this.length) {
                System.arraycopy(this.buffer, limit, this.buffer, start + charsLen, this.length - limit);
            }
            System.arraycopy(text, charsStart, this.buffer, start, charsLen);
            this.length = newLength;
        }
    }
}

