/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.mmd2.Artist;
import org.musicbrainz.mmd2.AttributeList;
import org.musicbrainz.mmd2.DefDirection;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Relation;
import org.musicbrainz.mmd2.RelationList;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.TagHelper;
import org.musicbrainz.search.index.WorkIndexField;

public class WorkIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "work";
    private static final String ARTIST_RELATION_TYPE = "artist";

    public WorkIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public WorkIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(WorkIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return WorkIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM work");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM work WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("TAGS", "SELECT work_tag.work, tag.name as tag, work_tag.count as count  FROM work_tag   INNER JOIN tag ON tag=id  WHERE work between ? AND ?");
        this.addPreparedStatement("ARTISTS", " SELECT aw.id as awid, l.id as lid, w.id as wid, w.gid, a.gid as aid, an.name as artist_name, sn.name as artist_sortname, lt.name as link, lat.name as attribute FROM l_artist_work aw INNER JOIN artist a ON a.id    = aw.entity0 INNER JOIN work   w ON w.id     = aw.entity1 INNER JOIN artist_name an ON an.id = a.name INNER JOIN artist_name sn ON sn.id = a.sort_name INNER JOIN link l ON aw.link = l.id  INNER JOIN link_type lt on l.link_type=lt.id LEFT JOIN  link_attribute la on la.link=l.id LEFT JOIN  link_attribute_type lat on la.attribute_type=lat.id WHERE w.id BETWEEN ? AND ?   ORDER BY aw.id");
        this.addPreparedStatement("ALIASES", "SELECT work_alias.work as work, n.name as alias  FROM work_alias   JOIN work_name n ON (work_alias.name = n.id)  WHERE work BETWEEN ? AND ?");
        this.addPreparedStatement("ISWCS", "SELECT work, iswc FROM iswc  WHERE work BETWEEN ? AND ?");
        this.addPreparedStatement("WORKS", "SELECT w.id as wid, w.gid, wn.name as name, wt.name as type, l.iso_code_3 as language, comment  FROM work AS w   LEFT JOIN work_name wn ON w.name = wn.id   LEFT JOIN work_type wt ON w.type = wt.id   LEFT JOIN language l on w.language = l.id  WHERE w.id BETWEEN ? AND ?  ORDER BY w.id");
    }

    private Map<Integer, List<Tag>> loadTags(int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement("TAGS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        Map<Integer, List<Tag>> tags = TagHelper.completeTagsFromDbResults(rs, INDEX_NAME);
        rs.close();
        return tags;
    }

    private Map<Integer, RelationList> loadArtistRelations(int min, int max) throws SQLException, IOException {
        HashMap<Integer, RelationList> artists = new HashMap<Integer, RelationList>();
        PreparedStatement st = this.getPreparedStatement("ARTISTS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        int lastLinkId = -1;
        Relation lastRelation = null;
        while (rs.next()) {
            RelationList list;
            int linkId = rs.getInt("awid");
            if (linkId == lastLinkId) {
                String attribute = rs.getString("attribute");
                AttributeList attributeList = lastRelation.getAttributeList();
                if (attributeList == null) {
                    attributeList = new ObjectFactory().createAttributeList();
                    lastRelation.setAttributeList(attributeList);
                }
                attributeList.getAttribute().add(attribute);
                continue;
            }
            int workId = rs.getInt("wid");
            if (!artists.containsKey(workId)) {
                list = new ObjectFactory().createRelationList();
                list.setTargetType(ARTIST_RELATION_TYPE);
                artists.put(workId, list);
            } else {
                list = (RelationList)artists.get(workId);
            }
            Relation relation = new ObjectFactory().createRelation();
            Artist artist = new ObjectFactory().createArtist();
            artist.setId(rs.getString("aid"));
            artist.setName(rs.getString("artist_name"));
            artist.setSortName(rs.getString("artist_sortname"));
            relation.setArtist(artist);
            relation.setType(rs.getString("link"));
            relation.setDirection(DefDirection.BACKWARD);
            list.getRelation().add(relation);
            String attribute = rs.getString("attribute");
            if (attribute != null) {
                AttributeList attributeList = relation.getAttributeList();
                if (attributeList == null) {
                    attributeList = new ObjectFactory().createAttributeList();
                    relation.setAttributeList(attributeList);
                }
                attributeList.getAttribute().add(attribute);
            }
            lastRelation = relation;
            lastLinkId = linkId;
        }
        rs.close();
        return artists;
    }

    private Map<Integer, List<String>> loadAliases(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<String>> aliases = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("ALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int workId = rs.getInt(INDEX_NAME);
            if (!aliases.containsKey(workId)) {
                list = new LinkedList();
                aliases.put(workId, list);
            } else {
                list = (List)aliases.get(workId);
            }
            list.add(rs.getString("alias"));
        }
        rs.close();
        return aliases;
    }

    private Map<Integer, List<String>> loadISWCs(int min, int max) throws SQLException, IOException {
        HashMap<Integer, List<String>> iswcs = new HashMap<Integer, List<String>>();
        PreparedStatement st = this.getPreparedStatement("ISWCS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            List<String> list;
            int workId = rs.getInt(INDEX_NAME);
            if (!iswcs.containsKey(workId)) {
                list = new LinkedList();
                iswcs.put(workId, list);
            } else {
                list = (List)iswcs.get(workId);
            }
            list.add(rs.getString("iswc"));
        }
        rs.close();
        return iswcs;
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, List<Tag>> tags = this.loadTags(min, max);
        Map<Integer, RelationList> artistRelations = this.loadArtistRelations(min, max);
        Map<Integer, List<String>> aliases = this.loadAliases(min, max);
        Map<Integer, List<String>> iswcs = this.loadISWCs(min, max);
        PreparedStatement st = this.getPreparedStatement("WORKS");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, artistRelations, aliases, iswcs));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, Map<Integer, RelationList> artists, Map<Integer, List<String>> aliases, Map<Integer, List<String>> iswcs) throws SQLException {
        RelationList rl;
        MbDocument doc = new MbDocument();
        int id = rs.getInt("wid");
        doc.addField((IndexField)WorkIndexField.ID, id);
        doc.addField((IndexField)WorkIndexField.WORK_ID, rs.getString("gid"));
        String name = rs.getString("name");
        doc.addField((IndexField)WorkIndexField.WORK, name);
        doc.addField((IndexField)WorkIndexField.WORK_ACCENT, name);
        doc.addFieldOrNoValue(WorkIndexField.LYRICS_LANG, rs.getString("language"));
        doc.addFieldOrNoValue(WorkIndexField.TYPE, rs.getString("type"));
        doc.addFieldOrNoValue(WorkIndexField.COMMENT, rs.getString("comment"));
        if (artists.containsKey(id) && (rl = artists.get(id)).getRelation().size() > 0) {
            doc.addField((IndexField)WorkIndexField.ARTIST_RELATION, MMDSerializer.serialize(rl));
            for (Relation r : artists.get(id).getRelation()) {
                doc.addField((IndexField)WorkIndexField.ARTIST_ID, r.getArtist().getId());
                doc.addField((IndexField)WorkIndexField.ARTIST, r.getArtist().getName());
            }
        }
        if (aliases.containsKey(id)) {
            for (String alias : aliases.get(id)) {
                doc.addField((IndexField)WorkIndexField.ALIAS, alias);
            }
        }
        if (iswcs.containsKey(id)) {
            for (String iswc : iswcs.get(id)) {
                doc.addField((IndexField)WorkIndexField.ISWC, iswc);
            }
        } else {
            doc.addFieldOrNoValue(WorkIndexField.ISWC, null);
        }
        if (tags.containsKey(id)) {
            for (Tag tag : tags.get(id)) {
                doc.addField((IndexField)WorkIndexField.TAG, tag.getName());
                doc.addField((IndexField)WorkIndexField.TAGCOUNT, tag.getCount().toString());
            }
        }
        return doc.getLuceneDocument();
    }
}

