/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.FieldType;
import org.musicbrainz.search.analysis.StripLeadingZeroesAnalyzer;
import org.musicbrainz.search.analysis.TitleAnalyzer;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MusicBrainzFieldTypes;

public enum CDStubIndexField implements IndexField
{
    ID("_id", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    ARTIST("artist", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED),
    TITLE("title", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED, new TitleAnalyzer()),
    BARCODE("barcode", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED_NO_NORMS, new StripLeadingZeroesAnalyzer()),
    COMMENT("comment", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED),
    NUM_TRACKS("tracks", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    DISCID("discid", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    ADDED("added", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS);

    private String name;
    private Analyzer analyzer;
    private FieldType fieldType;

    private CDStubIndexField(String name, FieldType fieldType) {
        this.name = name;
        this.fieldType = fieldType;
    }

    private CDStubIndexField(String name, FieldType fieldType, Analyzer analyzer) {
        this(name, fieldType);
        this.analyzer = analyzer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }
}

