/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: IXDA.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xda;

/**
 * Xpath Document API
 * @author  pjr
 */
public interface IXDA extends IXDAReadOnly
{
	/** Append fragment of source to this at a specified location or locations
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void append(IXDAReadOnly aSource, String aSourceXPath, String aTargetXPath) throws XPathLocationException, XDOIncompatibilityException;
	/** Insert fragment of source to this before specified location or locations
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void insertBefore(IXDAReadOnly aSource, String aSourceXPath,  String aTargetXPath) throws XPathLocationException, XDOIncompatibilityException;
	/** Insert fragment of source to this after specified location or locations
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void insertAfter(IXDAReadOnly aSource, String aSourceXPath,  String aTargetXPath) throws XPathLocationException, XDOIncompatibilityException;
	/** Apply namespace to target location or locations
	 * @param prefix prefix for the namespace
	 * @param uri uri for the namespace
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void applyNS(String aTargetXPath, String prefix, String uri) throws XPathLocationException, XDOIncompatibilityException;
	/** Remove namespace from target location or locations
	 * @param prefix prefix for the namespace
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void removeNS(String aTargetXPath, String prefix) throws XPathLocationException, XDOIncompatibilityException;
	/** Rename elements at target location or locations
	 * @param name the new element name
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void rename(String aTargetXPath, String name) throws XPathLocationException, XDOIncompatibilityException;
	/** Delete elements at target location or locations
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void delete(String aTargetXPath) throws XPathLocationException, XDOIncompatibilityException;
	/** Replace fragments of this with fragments from source at specified location or locations
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void replace(IXDAReadOnly aSource, String aSourceXPath, String aTargetXPath) throws XPathLocationException, XDOIncompatibilityException;
	/** Replace fragments of this with given text at specified location or locations
	 * @param aText the text to place at locations
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void replaceByText(String aTargetXPath, String aText)  throws XPathLocationException, XDOIncompatibilityException;
	/** Moves a fragment from one location in this to another
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void move(String aSourceXPath, String aTargetXPath) throws XPathLocationException, XDOIncompatibilityException;
	/** Sets the text of the element or elements at the target location of this
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void setText(String aTargetXPath, String aText) throws XPathLocationException, XDOIncompatibilityException;
	/** Builds and appends a chain of elements to a location or locations within this
	 * @param aNewRelativeXPath a simple xpath of form <code>a/b/c</code> to name a chain of elements
	 * to append.
	 * @param aOptionalValue a text value to assign to the leaf node, may be null
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 * @exception XDOIncompatibilityException throw if the implementation doesn't support this operation
	 */
	void appendPath(String aTargetXPath, String aNewRelativeXPath, String aOptionalValue) throws XPathLocationException, XDOIncompatibilityException;
	/** Return an iterator over all elements match the xpath in this
	 * @exception XPathLocationException throw if the xpath is malformed, xpaths don't result in well defined element
	 */
	IXDAIterator iterator(String aTargetXPath) throws XPathLocationException;
}
