/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XAHelper.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xahelper;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.meta.DependencyMeta;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;

import org.xml.sax.*;
import javax.xml.transform.*;
import java.io.*;
import java.util.*;
import java.net.*;

/**
 * An interface containing all the methods needed for implementing a subclass of
 * XAccessor. It is passed to the <code>XAccessor.source</code> method.
 * @author  tab
 */
public interface XAHelper extends URIResolver, EntityResolver
{
	/** argument constant for operand */
	static final String OPERAND=CompoundURIdentifier.OPERAND;
	/** argument constant for operator */
	static final String OPERATOR=CompoundURIdentifier.OPT;
	/** argument constant for parameter */
	static final String PARAMETER=CompoundURIdentifier.PARAM;
	
	/** return an IXAspect of the operand
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	IXAspect getOperand() throws NetKernelException;
	/** return an IURRepresentation of the operand that has a particular aspect
	 * @param aClass the class of the aspect that must be available
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	IURRepresentation getOperand(Class aClass) throws NetKernelException;
	/** return an IXAspect of the operator
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	IXAspect getOperator() throws NetKernelException;
	/** return an IURRepresentation of the operator that has a particular aspect
	 * @param aClass the class of the aspect that must be available
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	IURRepresentation getOperator(Class aClass) throws NetKernelException;
	/** return an IXAspect of the parameter
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	IXAspect getParameter()  throws NetKernelException;
	/** return an IURRepresentation of the parameter that has a particular aspect
	 * @param aClass the class of the aspect that must be available
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	IURRepresentation getParameter(Class aClass) throws NetKernelException;
	/** Return an IXAspect of an abitrary URI
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	IXAspect getXResource(URI aURI) throws NetKernelException;
	/** return an IURRepresentation of an abitrary URI
	 * @param aClass the class of the aspect that must be available
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	IURRepresentation getResource(URI aURI, Class aClass) throws NetKernelException;
	/** Return true if the operand available
	 */
	boolean hasOperand();
	/** Return true if the operator available
	 */
	boolean hasOperator();
	/** Return true if the parameter available
	 */
	boolean hasParameter();
	/** Return the URI of a particular argument- null if it doesn't exist
	 */
	URI getURI(String aArgument) throws java.net.URISyntaxException;
	/** Return the type value of the compound URI that initiated this accessor request
	 */
	String getType();
	/** Return the current working URI of this request- may be null if none defined
	 */
	URI getCurrentWorkingURI();
	/** Return a dependency meta that has as dependents all requested arguments plus the accessor itself
	 * @param aMimeType the mimetype of the meta
	 * @param aCost the creation cost for the meta
	 */
	IURMeta getDependencyMeta(String aMimeType, int aCost);
	/** Sink an abitrary resource
	 * @param aURI the URI of the resource to sink to
	 * @param aRepresentation the IURRepresentation containing the state to sink
	 * @exception NetKernelException thrown if we fail to obtain aspect for any reason
	 */
	void setResource(URI aURI, IURRepresentation aRepresentation) throws NetKernelException;
	/** the EntityResolver interface for SAX */
	InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException;
	/** the URIResolver interface for JAXP */
	Source resolve(String href, String base) throws TransformerException;
}