/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: NKFURIResolver.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/10/29 14:43:02 $
 *****************************************************************************/
package org.ten60.netkernel.xml.util;

import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.xml.representation.IAspectDOM;
import com.ten60.netkernel.urii.aspect.*;

import javax.xml.transform.stream.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.*;

import java.io.*;
/**
 * Implementation of a javax.xml.transform.URIResolver using NKF context
 * @author  tab
 */
public class NKFURIResolver implements javax.xml.transform.URIResolver
{
	private INKFConvenienceHelper mContext;
	
	/** Creates a new instance of NKFURIResolver */
	public NKFURIResolver(INKFConvenienceHelper aContext)
	{	mContext=aContext;
	}
	
	/** ensure link to context is removed as some XML technologies
	 don't like to let go
	 */
	public void cleanup()
	{	mContext=null;
	}
	
	public Source resolve(String aHref, String aBase) throws TransformerException
	{	try
		{	Source result;
			IURRepresentation resourceRep = mContext.source(aHref);
			if(resourceRep.hasAspect(IAspectDOM.class))
			{	IAspectDOM doma = (IAspectDOM)resourceRep.getAspect(IAspectDOM.class);
				result=new DOMSource(doma.getReadOnlyDocument());
			}
			else if(resourceRep.hasAspect(IAspectReadableBinaryStream.class))
			{	IAspectReadableBinaryStream rbs = (IAspectReadableBinaryStream)resourceRep.getAspect(IAspectReadableBinaryStream.class);
				result= new StreamSource(rbs.getInputStream());
			}
			else if(resourceRep.hasAspect(IAspectBinaryStream.class))
			{	ByteArrayOutputStream baos=new ByteArrayOutputStream(2048);
				IAspectBinaryStream bs=(IAspectBinaryStream)resourceRep.getAspect(IAspectBinaryStream.class);
				bs.write(baos);
				result=new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
			}
			else 
			{	//Worst case, try to tranrept the resource to a readable binary stream
				IAspectReadableBinaryStream rbs = (IAspectReadableBinaryStream)mContext.sourceAspect(aHref, IAspectReadableBinaryStream.class);
				result=new StreamSource(rbs.getInputStream());
			}
			return result;
		} catch (NKFException e)
		{	TransformerException e2 = new TransformerException("Resource "+aHref+" could not be resolved");
			e2.initCause(e);
			throw e2;
		}
		catch (IOException e)
		{	TransformerException e2 = new TransformerException("Resource "+aHref+" could not be resolved");
			e2.initCause(e);
			throw e2;
		}
	}	
}