/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: NVPToXML.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;


import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;

import java.util.*;

/**
 *	Transrepresent Name Value Pair Proxy to XML
 * @author  pjr
 */
public class NVPToXML extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectNVP.class) && ( aTo.isAssignableFrom(IXAspect.class)) );
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	IAspectNVP nvp=(IAspectNVP)aFrom.getAspect(IAspectNVP.class);
		Set names=nvp.getNames();
		DOMXDA dx=new DOMXDA(org.ten60.netkernel.xml.util.XMLUtils.newDocument(),false);
		try
		{	dx.appendPath("/", "nvp", null);
			Iterator i=names.iterator();
			while(i.hasNext())
			{	String key=(String)i.next();
				List l=nvp.getValues(key);
				Iterator j=l.iterator();
				while(j.hasNext())
				{	String value=(String)j.next();
					dx.appendPath("/nvp", key, value);
				}
			}
			
			DependencyMeta dm=new DependencyMeta(aFrom, 4);
			dm.setMimeType("text/xml");
		
			return DOMXDAAspect.create(dm,dx);
		}
		catch (Exception e)
		{	NetKernelException nke=new NetKernelException("Error in NVPToXMLTransmutor");
			nke.addCause(e);
			throw nke;
		}
	}	
}