/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SAXFilterAspect.java,v $
  Version:       $Name:  $ $Revision: 1.11 $
  Last Modified: $Date: 2004/10/12 14:28:11 $
 *****************************************************************************/
package org.ten60.netkernel.xml.representation;

import org.ten60.netkernel.layer1.representation.MonoRepresentationImpl;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urii.*;

import org.xml.sax.*;
import org.xml.sax.ext.*;
import java.io.*;
import java.util.List;
/**
 *	A SAX Filter Aspect - dynamically connects parents as the SAX chain is evaluated
 * @author  pjr
 */
public class SAXFilterAspect implements IAspectSAX
{
	IAspectSAX mInput;
	XMLFilter mFilter;
	
	/** Creates a new instance of SAXFilterAspect */
	public SAXFilterAspect(IAspectSAX aInput, XMLFilter aFilter)
	{	mInput = aInput;
		mFilter = aFilter;
	}
	
	public void handleContent(XMLReader aReader, List aUsageDependencies) throws IOException, SAXException
	{	synchronized(mFilter)
		{	mFilter.setContentHandler(aReader.getContentHandler());
			if(aReader instanceof org.xml.sax.XMLFilter)
			{	XMLFilter f=(XMLFilter)aReader;
				f.setParent(mFilter);	
			}			
			if (mFilter instanceof org.xml.sax.helpers.XMLFilterImpl)
			{	LexicalHandler lh=null;
				try
				{	lh=(LexicalHandler)aReader.getProperty("http://xml.org/sax/properties/lexical-handler");
				}
				catch(org.xml.sax.SAXNotRecognizedException e)
				{	//Not implemented					
				}
				if(lh!=null && lh instanceof org.xml.sax.ext.LexicalHandler)
				{	mFilter.setProperty("http://xml.org/sax/properties/lexical-handler", lh);
				}
			}
			mInput.handleContent(mFilter,aUsageDependencies);
		}
	}
	
	/** @deprecated
	 */
	public static IURRepresentation create(IURMeta aMeta, IAspectSAX aInput, XMLFilter aFilter)
	{	return new MonoRepresentationImpl(aMeta, new SAXFilterAspect(aInput,aFilter));
	}
	
}