/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: HTTPBridgeConfig.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2008/03/23 13:28:29 $
 *****************************************************************************/

package org.ten60.transport.http.bridge;

import java.util.*;

/**
 * Holds an HTTP Bridge Configuration
 * @author  pjr
 */
public class HTTPBridgeConfig
{
	private ArrayList mZones;
	
	/** Creates a new instance of GateKeeperPolicy */
	public HTTPBridgeConfig()
	{	mZones=new ArrayList(10);
	}
	
	public void addZone(HTTPBridgeZone aZone)
	{	mZones.add(aZone);
	}
	
	/** Find the first matching zone for the given URI
	 **/
	public HTTPBridgeZone getZone(String aURI)
	{	HTTPBridgeZone zone=null;
		Iterator zi=mZones.iterator();
		while(zi.hasNext())
		{	HTTPBridgeZone z=(HTTPBridgeZone)zi.next();
			if(z.matches(aURI))
			{	zone=z;
				break;
			}
		}
		return zone;
	}

/**
 * Return a List of configured zones
 */
  public List getZones()
  {
  return mZones;
  }


/**
 * Returns the configuration information as an XML document
 *
 * @return
 */
  public String toStringXML()
  { StringBuffer sb = new StringBuffer(2048);
    sb.append("<zones>\n\r");
    Iterator iter = mZones.iterator();
    while(iter.hasNext())
    { HTTPBridgeZone zone = (HTTPBridgeZone)iter.next();
      sb.append(zone.toStringXML());
    }
    sb.append("</zones>");
    return sb.toString();
    }

}