/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: SerializerAdapter.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/06/07 15:17:35 $
 *****************************************************************************/
package org.ten60.netkernel.cocoon;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.DependencyMeta;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.*;

import org.apache.cocoon.*;
import org.apache.cocoon.serialization.*;
import org.apache.cocoon.environment.*;
import org.apache.cocoon.components.*;
import org.apache.avalon.framework.parameters.*;
import org.apache.avalon.framework.configuration.*;
import org.apache.avalon.framework.service.*;
import org.apache.avalon.framework.logger.*;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.excalibur.component.*;

import java.util.*;
import java.io.*;
import java.util.logging.*;

import java.net.*;
/**
 *
 * @author  tab
 */
public class SerializerAdapter extends XAccessor
{
	private static Map sTypeToClassMap = new HashMap();
	static
	{	sTypeToClassMap.put("LinkSerializer","org.apache.cocoon.serialization.LinkSerializer");
		sTypeToClassMap.put("XMLSerializer","org.apache.cocoon.serialization.XMLSerializer");
		sTypeToClassMap.put("HTMLSerializer","org.apache.cocoon.serialization.HTMLSerializer");
		sTypeToClassMap.put("ZipArchiveSerializer","org.apache.cocoon.serialization.ZipArchiveSerializer");
		sTypeToClassMap.put("SVGSerializer","org.apache.cocoon.serialization.SVGSerializer");
		sTypeToClassMap.put("FOPSerializer","org.apache.cocoon.serialization.FOPSerializer");
		sTypeToClassMap.put("iTextSerializer","org.apache.cocoon.serialization.iTextSerializer");
		sTypeToClassMap.put("RTFSerializer","org.apache.cocoon.serialization.RTFSerializer");
		sTypeToClassMap.put("XMidiSerializer","org.apache.cocoon.serialization.XMidiSerializer");
		sTypeToClassMap.put("HSSFSerializer","org.apache.cocoon.serialization.HSSFSerializer");
		sTypeToClassMap.put("SWFSerializer","org.apache.cocoon.serialization.SWFSerializer");
		
	}
	
	/** Creates a new instance of TransformerAdapter */
	public SerializerAdapter() throws Exception
	{	//declareArgument("src", true, false);
		declareArgument(XAccessor.OPERAND,true,false);
		declareArgument(XAccessor.PARAMETER, false, false);
		declareArgument("configuration", false, false);
	}
	
	protected IURRepresentation source(XAHelper aHelper) throws Throwable
	{	String type=aHelper.getType();
		String className=null;
		if (!type.startsWith("cocoon.serializer.") || (className=(String)sTypeToClassMap.get(type.substring(18)))==null)
		{	throw new NetKernelException("Unsupported Serializer","The serializer ["+type+"] is unsupported",type);
		}
		Class serializerClass = Class.forName(className);
		AbstractSerializer serializer = (AbstractSerializer)serializerClass.newInstance();
		// initialise
		org.apache.avalon.framework.logger.Logger logger = InitialisationAccessor.getLogger();
		serializer.enableLogging(logger);
		if (serializer instanceof Serviceable)
		{	Serviceable serviceable= (Serviceable)serializer;
			ServiceManager manager = InitialisationAccessor.getServiceManager();
			serviceable.service(manager);
		}
		if (serializer instanceof Configurable)
		{	Configurable configurable= (Configurable)serializer;
			Configuration configuration;
			URI configurationURI = aHelper.getURI("configuration");
			if (configurationURI!=null)
			{	IAspectSAX saxConfig = (IAspectSAX)aHelper.getResource(configurationURI,IAspectSAX.class).getAspect(IAspectSAX.class);
				SAXConfigurationHandler sch = new SAXConfigurationHandler();
				saxConfig.handleContent(sch,null,null);
				configuration = sch.getConfiguration();
			}
			else
			{	configuration = InitialisationAccessor.getConfiguration();
			}
			configurable.configure(configuration);
		}		
		SourceResolver resolver = new XASourceResolver(aHelper,null);
		ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
		serializer.setOutputStream(baos);
		IAspectSAX input = (IAspectSAX)aHelper.getOperand(IAspectSAX.class).getAspect(IAspectSAX.class);
		List usageDependencies = new ArrayList(8);
		input.handleContent(serializer,serializer,usageDependencies);
		IURAspect resultAspect = new ByteArrayAspect(baos);
		DependencyMeta meta = (DependencyMeta)aHelper.getDependencyMeta(serializer.getMimeType(), 4);
		for (Iterator i = usageDependencies.iterator(); i.hasNext(); )
		{	IURRepresentation dependency = (IURRepresentation)i.next();
			meta.addDependency(dependency);
		}
		IURRepresentation result = new MonoRepresentationImpl(meta,resultAspect);
		return result;
	}
}