/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SuperStackClassLoader.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2004/12/07 13:48:38 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.util;

import com.ten60.netkernel.module.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.module.ModuleClassLoader;
import java.util.*;
/**
 * A Classloader that will load classes from a module but then accend the
 * superstack of a request to find classes in calling contexts. It also
 * contains a cache which improves performance with some of the liberal
 * ways that classloaders are used in scripting engines. This includes caching
 * of not found exceptions. This classloader adds an overhead as compared to the
 * regular module classloader however it gives classloading which is strictly according
 * to the same model as used in resource resolution- this however is rarely needed.
 * @author  tab
 */
public class SuperStackClassLoader extends ClassLoader
{
	private List mSuperStack;
	private ModuleDefinition mContext;
	private Map mClassCache = Collections.synchronizedMap(new HashMap());
	private static final Object CLASSNOTFOUND = new Integer(0);
	
	/** Creates a new instance of ScriptClassLoader */
	public SuperStackClassLoader(URRequest aRequest)
	{	
		mSuperStack=aRequest.getSuperStack();
		mContext=(ModuleDefinition)aRequest.getContext();
	}
	
	public void cleanup()
	{	mSuperStack=null;
		mContext=null;
		mClassCache=null;
	}
	
	public Class findClass(String aName) throws ClassNotFoundException
	{	return loadClass(aName);
	}
	
	public Class loadClass(String aName, boolean aResolve) throws ClassNotFoundException
	{	Class c= loadClass(aName);
		if (aResolve)
		{	resolveClass(c);
		}
		return c;
	}
	
	public Class loadClass(String aName) throws ClassNotFoundException
	{	//System.out.println("Loading "+aName);
		Object cached = mClassCache.get(aName);
		if (cached!=null)
		{	//System.out.println("found in cache ");
			if (cached==CLASSNOTFOUND)
			{	throw new ClassNotFoundException(aName);
			}
			else
			{	return (Class)cached;
			}
		}
		
		List superStack = mSuperStack;
		int p=superStack.size()-1;
		ModuleDefinition module = mContext;
		while (true)
		{	//System.out.println("  searching "+module.getURI().toString());
			try
			{	ModuleClassLoader mcl = (ModuleClassLoader)module.getClassLoader();
				Class result = mcl.loadClassAvoidingParent(aName);
				mClassCache.put(aName,result);
				//System.out.println("found "+aName);
				return result;
			}
			catch (ClassNotFoundException e)
			{	if (p>=0)
				{	module=(ModuleDefinition)superStack.get(p);
					p=p-1;
				}
				else
				{	module = mContext;
					try
					{	ClassLoader parent = ((ModuleClassLoader)module.getClassLoader()).getKernelClassLoader();
						return parent.loadClass(aName);
					}
					catch (ClassNotFoundException e2)
					{	mClassCache.put(aName,CLASSNOTFOUND);
						throw e;
					}
				}
			}
		}
	}
	
	/** classloaders are equal if they operate on equal superstacks */
	public boolean equals(Object aOther)
	{	SuperStackClassLoader other = (SuperStackClassLoader)aOther;
		return mSuperStack.equals(other.mSuperStack);
	}
	
}