/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: INKFKernelHelper.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2004/08/19 12:56:35 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf;

import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.util.NetKernelException;
/**
 * <b>Advanced</b> Methods which provide Low-level access to the NetKernel kernel APIs. Generally not necessary when implementing an accessor
 * but can be valuable for advanced development.
 * @author  tab
 */
public interface INKFKernelHelper
{   
	/** <b>Advanced</b> Return the request which initiated this invocation of the accessor
	 * @exception NKFException thrown if no parent request initiated this invocation
	 */
	URRequest getThisKernelRequest()  throws NKFException;
	
	/** <b>Advanced</b> Issue a resource request to the kernel using a URRequest.  All higher-level
	 *  NKF methods will use this to issue kernel requests.  Requests are Sychnoronous.
	 * @param aRequest
	 * @exception NetKernelException
	 * @return a representation which is the response from the request
	 */
	IURRepresentation issueRequest(URRequest aRequest) throws NetKernelException;
	
	/** <b>Advanced</b> Sets the response that will be issued as the result of this invocation of
	 * the accessor. <b>All accessors should use this method to set a response before completion.</b>
	 * @param aResponse an IURRepresentation
	 */
	void setResponse(IURRepresentation aResponse);
	
	/** <b>Advanced</b> Return a reference to the Kernel Container. From this the Scheduler and other
	 * kernel components may be accessed.
	 */
	Container getKernel();
	
	/** <b>Advanced</b> Return the owning module of this accessor
	 */
	ModuleDefinition getOwningModule();
}