/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: INKFConvenienceHelper.java,v $
 * Version:       $Name:  $ $Revision: 1.13 $
 * Last Modified: $Date: 2004/10/04 15:05:21 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urii.IURMeta;
import java.net.URI;
/**
 * Convenience helper methods for sourcing and sinking resources. Implemented over INKFBasicHelper
 * @author  tab
 */
public interface INKFConvenienceHelper extends INKFBasicHelper
{
	/** Source a resource from its URI
	 * @param aURI
	 * @exception NKFException
	 */
	IURRepresentation source(String aURI) throws NKFException;
	
	/** Source a resource from its URI
	 * @param aURI
	 * @param aAspectClass
	 * @exception NKFException
	 */
	IURRepresentation source(String aURI, Class aAspectClass) throws NKFException;

	/** Source a specific aspect of a resource from its URI
	 * @param aURI
	 * @param aAspectClass
	 * @exception NKFException
	 */
	IURAspect sourceAspect(String aURI, Class aAspectClass) throws NKFException;
	
	/** Sink an aspect to the resource at a URI
	 * @param aURI
	 * @param aAspect
	 * @exception NKFException
	 */
	void sinkAspect(String aURI, IURAspect aAspect) throws NKFException;
	
	/** Check for the existence of a resource for the given URI
	 */
	boolean exists(String aURI) throws NKFException;
	
	/** Delete a resource for the given URI
	 * @return true if it was deleted
	 */
	boolean delete(String aURI) throws NKFException;

	/** Transrept a internally created resource into alternative aspect.
	 * There must be a registered Transreptor capable of performing the
	 * transrepresentation. - Do not use to transrept external resources
	 * source these using one of the methods which take an aspect class
	 * parameter.
	 * @param aSource An internally generated resource
	 * @param aAspectClass The class of the desired aspect for the resource
	 * @return An aspect of class aAspectClass for resource aSource
	 * @exception NKFException thrown if no transreptor available or transreptor fails
	 */
	IURAspect transrept(IURAspect aSource, Class aAspectClass) throws NKFException;

	/** Request the creation of a new resource
	 * @param aURIBase A base URI that can identify which accessor to target
	 * the request at
	 * @param aOptionalSource Optional resource aspect that the accessor can
	 * use to seed the state of the new resource.
	 * @return The URI of the created resource
	 * @exception NKFException Thrown if no accessor could be located or it
	 * didn't support the NEW operation or the failed for some other accessor
	 * specific reason.
	 */
	String requestNew(String aURIBase, IURAspect aOptionalSource) throws NKFException;	
	
	/** Apply a fragment identifier to an internally created resource.
	 * There must be a registered Fragmentor capable of performing the
	 * fragmentation. - Do not use to transrept external resources 
	 * source these with a fragment identifier on the URI
	 * @param aSource An internally generated resource
	 * @param aFragment A valid fragment identifier string
	 * @param aMimeType The mimetype of the resource
	 * @param aAspectClass The class of the desired aspect for the resource
	 * @return An aspect of class aAspectClass for resource aSource
	 * @exception NKFException thrown if no transreptor available or transreptor fails
	 */
	IURAspect fragment(IURAspect aSource, String aFragment, String aMimeType, Class aAspectClass) throws NKFException;
	
	/** Create a representation around one aspect that has been internally created and
	 * give it the specified mimetype. The created representation is not expired
	 * but has no dependencies.
	 * @param aAspect the single aspect it should contain
	 * @param aMimeType the mimetype of the representation
	 */
	IURRepresentation createIntermediateRepresentationForAspect(IURAspect aAspect, String aMimeType);
}