/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: AccessorImpl.java,v $
  Version:       $Name:  $ $Revision: 1.5 $
  Last Modified: $Date: 2004/08/24 11:10:06 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.accessor;

import org.ten60.netkernel.layer1.representation.SimpleRepresentationImpl;
import org.ten60.netkernel.layer1.meta.ActiveAccessorMeta;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.scheduler.*;
import com.ten60.netkernel.util.*;

/**
 * Base class for implementing simple accessors. Contains default error handling for child requests to
 * case parent requests to fail. It contains helper methods for requesting and transrepresenting resources
 * @author  tab
 */
public abstract class AccessorImpl extends SimpleRepresentationImpl implements IURAccessor
{
	private URIdentifier mURI;
	private ModuleDefinition mModule;
	private Container mContainer;
	private Scheduler mScheduler;
	
	/** construct a new AccessorImpl
	 * @param aCost the cost of creation of this accessor
	 * @param aIsThreadSafe true if the accessor is to be considered threadsafe
	 */
	public AccessorImpl(IURMeta aMeta)
	{	super(aMeta);
	}
	
	/** @return the accessor meta
	 */
	public IURAccessorMeta getAccessorMeta()
	{	return (IURAccessorMeta)getMeta();
	}
	
	/** initialise the accessor */
	public void init(URIdentifier aURI, ModuleDefinition aModule, Container aContainer) throws com.ten60.netkernel.util.NetKernelException
	{	mURI = aURI;
		mModule=aModule;
		mContainer=aContainer;
		mScheduler = (Scheduler)mContainer.getComponent(Scheduler.URI);
	}
	
	/** @return our URI
	 */
	public final URIdentifier getURI()
	{	return mURI;
	}
	

	/** default exception handling is to add exception frame and re-throw */
	public void receiveAsyncException(URResult aResult)
	{	URRequest originalRequest = aResult.getRequest().getParent();
		//NetKernelExceptionAspect aspect = ((NetKernelExceptionAspect)aResult.getResource().getAspect(IAspectNetKernelException.class));
		
		//NetKernelException e = new NetKernelException("Received exception","in accessor ["+getClass().getName()+"]", originalRequest.getURI().toString());
		//e.addCause(originalException);
		URResult result = new URResult(originalRequest,  aResult.getResource());
		mScheduler.receiveAsyncException(result);
	}
	
	/** By default we ignore any results we receive- override this if you are making asychronous requests
	 */
	public void receiveAsyncResult(URResult aResult)
	{	
	}
	
	/** return the module we reside in
	 */
	protected ModuleDefinition getModule()
	{	return mModule;
	}
	
	/** return the container we operating within
	 */
	protected Container getContainer()
	{	return mContainer;
	}
	
	/** return the scheduler we can send requests too
	 */
	protected Scheduler getScheduler()
	{	return mScheduler;
	}
	
	/** Gets a IURRepresentation for a given URI. First the parent request is interogated to see if it has been
	 * passed by value. If not we go to the scheduler to request it.
	 * @param aURI the URI of the resource we want
	 * @param aAspectClass the class of an aspect that the representation must exhibit
	 * @param aOriginalRequest the original parent request
	 * @return an IURRepresentation containing the requested aspect
	 * @exception NetKernelException thrown the request fails for any reason
	 */
	protected IURRepresentation getResource(URIdentifier aURI, Class aAspectClass, URRequest aOriginalRequest) throws NetKernelException
	{	IURRepresentation representation = aOriginalRequest.getArg(aURI);
		if (representation==null)
		{	// request the representation
			URRequest request = new URRequest(aURI, null, aOriginalRequest.getSession(), getModule(), URRequest.RQT_SOURCE, aOriginalRequest.getCWU(), aOriginalRequest, aAspectClass);
			URResult result = getScheduler().requestSynch(request);
			representation = result.getResource();
		}
		else
		{	 if (!representation.hasAspect(aAspectClass))
			 {	representation = transrepresent(aURI, representation, aAspectClass, aOriginalRequest);
			 }
		}
		return representation;
	}
	
	/** Transrepresent an IURRepresentation to another aspect
	 * @param aSourceURI the URI of aSourceRepresentation
	 * @param aSourceRepresentation the representation we want to change aspects on
	 * @param aTargetClass the class of aspect we desire
	 * @param aOriginalRequest the parent request that invoked this accessor
	 * @return an IURRepresentation with the desired aspect
	 * @exception NetKernelException thrown if the IURRepresentation cannot be transrepresent for any reason
	 */
	protected IURRepresentation transrepresent(URIdentifier aSourceURI, IURRepresentation aSourceRepresentation, Class aTargetClass, URRequest aOriginalRequest) throws NetKernelException
	{	URRequest request = new URRequest(aSourceURI, null, aOriginalRequest.getSession(), getModule(), URRequest.RQT_TRANSREPRESENT, aOriginalRequest.getCWU(), aOriginalRequest, aTargetClass);
		request.addArg(URRequest.URI_SYSTEM, aSourceRepresentation);
		URResult result = getScheduler().requestSynch(request);
		return result.getResource();
	}
	
	/** Sink a resource to a URI
	 * @param aURI the URI to sink to
	 * @param aRepresentation the representation of the data we want to sink
	 * @param aOriginalRequest the parent request that invoked this accessor
	 * @exception NetKernelException thrown if request fails for any reason
	 */
	protected void sinkResource(URIdentifier aURI, IURRepresentation aRepresentation, URRequest aOriginalRequest) throws NetKernelException
	{	URRequest request = new URRequest(aURI, null, aOriginalRequest.getSession(), getModule(), URRequest.RQT_SINK, aOriginalRequest.getCWU(), aOriginalRequest, IURAspect.class);
		request.addArg(URRequest.URI_SYSTEM, aRepresentation);
		URResult result = getScheduler().requestSynch(request);
	}
	
	public void finalize()
	{	mContainer=null;
		mModule=null;
		mScheduler=null;	
	}
}