/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: LockAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2004/08/12 11:40:30 $
 *****************************************************************************/
package org.ten60.ura.util;

import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.representation.VoidAspect;
import org.ten60.netkernel.layer1.accessor.*;

import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
/**
 * Implements lock and unlock functionality asychronously. It allows
 * only one requestor to hold the lock for any given operand URI at a time
 * a continue result is only issued when it is safe to proceed.
 * @author  tab
 */
public class LockAccessor extends ActiveAccessorImpl
{
	private static AsynchLock sLocks = new AsynchLock(128, 4);
	
	/** Creates a new instance of LockAccessor */
	public LockAccessor()
	{	super(4,true);
	}
	
	public void requestAsync(URRequest aRequest)
	{	try
		{	CompoundURIdentifier uri = new CompoundURIdentifier(aRequest.getURI());
			String type = uri.getType();
			String operandString = uri.get(CompoundURIdentifier.OPERAND);
			if (operandString==null) throw new IllegalArgumentException("operand required");
			if (type.equals("lock"))
			{	boolean lockGained;
				synchronized(sLocks)
				{	lockGained = sLocks.lock(operandString, aRequest);
				}
				if (lockGained)
				{ issueResult(aRequest);
				}
			}
			else if (type.equals("unlock"))
			{	URRequest other;
				synchronized(sLocks)
				{	other = (URRequest)sLocks.unlock(operandString);
				}
				if (other!=null)
				{	issueResult(other);
				}
				issueResult(aRequest);
			}
			else
			{	throw new IllegalArgumentException("unknown instruction "+type);
			}
		}
		catch (Exception e)
		{	NetKernelException nke = new NetKernelException("Unhandled Exception in LockAccessor");
			nke.addCause(e);
			URResult result = new URResult(aRequest,NetKernelExceptionAspect.create(nke));
			getScheduler().receiveAsyncException(result);
		}
	}
	
	private void issueResult(URRequest aRequest)
	{	URResult result = new URResult(aRequest,VoidAspect.create());
		getScheduler().receiveAsyncResult(result);
	}	
}