########################
#Set up AddressBook Database
#Run as user root in mysql database
########################
CREATE DATABASE IF NOT EXISTS addressbook;

########################
#Grant access to user addressbook with password changeme
#Change password to something more secure!
########################
GRANT SELECT,INSERT,UPDATE,DELETE,INDEX, ALTER,CREATE,DROP,REFERENCES ON addressbook.* TO addressbook@localhost IDENTIFIED BY 'changeme'; 
GRANT SELECT,INSERT,UPDATE,DELETE,INDEX, ALTER,CREATE,DROP,REFERENCES ON addressbook.* TO addressbook@localhost.localdomain IDENTIFIED BY 'changeme'; 
FLUSH PRIVILEGES;

#######################
#Set up Tables
#######################
CREATE TABLE IF NOT EXISTS addressbook.entries (
    id		    MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	firstname	VARCHAR(100),
	lastname	VARCHAR(100),
	add1		VARCHAR(200),
	add2		VARCHAR(200),
	add3		VARCHAR(200),
	add4		VARCHAR(200),
	region		VARCHAR(100),
	country		VARCHAR(100),
	zip			VARCHAR(100),
	phone1		VARCHAR(100),
	phone2		VARCHAR(100),
	phone3		VARCHAR(100),
	fax			VARCHAR(100),
	email1		VARCHAR(200),
	email2		VARCHAR(200),
	email3		VARCHAR(200),
	web1		VARCHAR(200),
	web2		VARCHAR(200),
	notes		TEXT
);

