<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	
	<xsl:template match="/">
		<div class="forum-user">
			<xsl:apply-templates/>
		</div>
	</xsl:template>
	
	<xsl:template match="null">
		<div class="forum-user-name">Unknown user</div>		
	</xsl:template>
	
	<xsl:template match="results">
		<div class="forum-user-name"><a href="[[xrl:membership-profile-public]]?id={row/id}" xrl:resolve="href"><xsl:value-of select="row/userid"/></a></div>
		<xsl:if test="string-length(row/imageurl)">
			<img src="{row/imageurl}"/>
		</xsl:if>
		<div class="forum-user-join">
			Joined: <xsl:value-of select="row/dateDayOfMonth"/>-<xsl:value-of select="row/dateMonthName"/>-<xsl:value-of select="row/dateYear"/>
		</div>
		<div class="forum-user-join">Posts: <xsl:value-of select="row/posts"/></div>
		<xsl:if test="string-length(row/location)">
			<div class="forum-user-join">Location: <xsl:value-of select="row/location"/></div>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet> 