<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
	<xsl:param name="to"/>
	<xsl:param name="from"/>
	<xsl:param name="props"/>
    <xsl:template match="/nvp">
        <html>
            <head>
                <title><xsl:value-of select="title"/></title>
            </head>
            <body>
				<div>
					<b>From: </b><xsl:value-of select="$from/results/row/userid"/><br/>
					<b>Subject: </b><xsl:value-of select="title"/><br/>
					<b>Message: </b><br/><br/>
				</div>
				<xsl:copy-of select="entry/*"/>
				<xsl:variable name="base1" select="concat( $props/results/row[setting='WWWHOSTNAME']/value, 'forum/post/new-message?id=')"/>
				<xsl:variable name="base2" select="concat( $props/results/row[setting='WWWHOSTNAME']/value, 'forum/member-profile?id=')"/>
				<xsl:variable name="reply" select="concat( $base1, $from/results/row/id)"/>
				<xsl:variable name="user" select="concat( $base2, $from/results/row/id)"/>
				<xsl:variable name="root" select="concat( $base1, 1)"/>
				<div>
				<p>
				<i>To send a reply to <a href="{$user}"><xsl:value-of select="$from/results/row/userid"/></a>
				without revealing your email use <a href="{$reply}"><xsl:value-of select="$reply"/></a></i>
				</p>
				</div>
				<p>
				<i>
				Privacy and Abuse: The email message you have received is from a 1060 forum member. All messages sent through this service are strictly private and confidential.
				Please report unsolicited spam or offensive messages by sending a message to the administrator...
				<a href="{$root}"><xsl:value-of select="$root"/></a>
				</i>
				</p>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
