--
-- PostgreSQL database dump
--
\connect tracker
SET client_encoding = 'UNICODE';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

--COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: customers; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE customers (
    customer_id serial NOT NULL,
    first_name character varying NOT NULL,
    last_name character varying NOT NULL,
    email character varying,
    status integer,
    added timestamp(0) without time zone DEFAULT now() NOT NULL,
    state character varying NOT NULL,
    city character varying NOT NULL,
    zip character varying NOT NULL,
    street1 character varying NOT NULL,
    phone1 character varying NOT NULL,
    street2 character varying,
    phone2 character varying,
    notes text,
    country character varying NOT NULL
);


ALTER TABLE public.customers OWNER TO dbowner;

--
-- Name: customers_customer_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('customers', 'customer_id'), 1, false);


--
-- Name: customers_id_seq; Type: SEQUENCE; Schema: public; Owner: dbowner
--

CREATE SEQUENCE customers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.customers_id_seq OWNER TO dbowner;

--
-- Name: customers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval('customers_id_seq', 1, false);


SET default_with_oids = true;

--
-- Name: note; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE note (
    note_id serial NOT NULL,
    work_order_id integer NOT NULL,
    author character varying,
    date timestamp(0) without time zone DEFAULT now(),
    text text
);


ALTER TABLE public.note OWNER TO dbowner;

--
-- Name: note_note_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('note', 'note_id'), 1, false);


--
-- Name: problem; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE problem (
    problem_id serial NOT NULL,
    work_order_id integer NOT NULL,
    cost double precision,
    description text NOT NULL,
    notes text,
    estimated_time double precision,
    actual_time double precision
);


ALTER TABLE public.problem OWNER TO dbowner;

--
-- Name: problem_problem_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('problem', 'problem_id'), 1, false);


SET default_with_oids = false;

--
-- Name: users; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE users (
    username character varying NOT NULL,
    status smallint DEFAULT 0 NOT NULL,
    acct_type bigint DEFAULT 1 NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL,
    pass character varying
);


ALTER TABLE public.users OWNER TO dbowner;

SET default_with_oids = true;

--
-- Name: workorder; Type: TABLE; Schema: public; Owner: dbowner; Tablespace: 
--

CREATE TABLE workorder (
    workorder_id serial NOT NULL,
    customer_id integer NOT NULL,
    start_date timestamp(0) without time zone NOT NULL,
    promised_date timestamp(0) without time zone NOT NULL,
    status integer NOT NULL,
    total_cost double precision,
    description text,
    staff character varying
);


ALTER TABLE public.workorder OWNER TO dbowner;

--
-- Name: workorder_cust; Type: VIEW; Schema: public; Owner: dbowner
--

CREATE VIEW workorder_cust AS
    SELECT workorder.start_date, workorder.promised_date, customers.first_name, customers.last_name, customers.phone1, 
customers.phone2, workorder.workorder_id, workorder.staff, workorder.status FROM workorder, customers WHERE 
(customers.customer_id = workorder.customer_id) ORDER BY workorder.status, workorder.promised_date;


ALTER TABLE public.workorder_cust OWNER TO dbowner;

--
-- Name: workorder_workorder_id_seq; Type: SEQUENCE SET; Schema: public; Owner: dbowner
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('workorder', 'workorder_id'), 1, false);


--
-- Data for Name: customers; Type: TABLE DATA; Schema: public; Owner: dbowner
--



--
-- Data for Name: note; Type: TABLE DATA; Schema: public; Owner: dbowner
--



--
-- Data for Name: problem; Type: TABLE DATA; Schema: public; Owner: dbowner
--



--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: dbowner
--

INSERT INTO users VALUES ('admin', 1, 2, '2005-05-23 06:36:02.812', '098f6bcd4621d373cade4e832627b4f6');


--
-- Data for Name: workorder; Type: TABLE DATA; Schema: public; Owner: dbowner
--



--
-- Name: customers_pkey; Type: CONSTRAINT; Schema: public; Owner: dbowner; Tablespace: 
--

ALTER TABLE ONLY customers
    ADD CONSTRAINT customers_pkey PRIMARY KEY (customer_id);


ALTER INDEX public.customers_pkey OWNER TO dbowner;

--
-- Name: problem_pkey; Type: CONSTRAINT; Schema: public; Owner: dbowner; Tablespace: 
--

ALTER TABLE ONLY problem
    ADD CONSTRAINT problem_pkey PRIMARY KEY (problem_id);


ALTER INDEX public.problem_pkey OWNER TO dbowner;

--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: dbowner; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (username);


ALTER INDEX public.users_pkey OWNER TO dbowner;

--
-- Name: workorder_pkey; Type: CONSTRAINT; Schema: public; Owner: dbowner; Tablespace: 
--

ALTER TABLE ONLY workorder
    ADD CONSTRAINT workorder_pkey PRIMARY KEY (workorder_id);


ALTER INDEX public.workorder_pkey OWNER TO dbowner;

--
-- Name: problem_added; Type: RULE; Schema: public; Owner: dbowner
--

CREATE RULE problem_added AS ON INSERT TO problem DO UPDATE workorder SET total_cost = (workorder.total_cost + 
new.cost) WHERE (workorder.workorder_id = new.work_order_id);


--
-- Name: RULE problem_added ON problem; Type: COMMENT; Schema: public; Owner: dbowner
--

COMMENT ON RULE problem_added ON problem IS 'add problem''s cost to workorder total cost';


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: dbowner
--

ALTER TABLE ONLY problem
    ADD CONSTRAINT "$1" FOREIGN KEY (work_order_id) REFERENCES workorder(workorder_id) ON UPDATE CASCADE ON DELETE 
CASCADE;


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: customers; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE customers FROM PUBLIC;
REVOKE ALL ON TABLE customers FROM dbowner;
GRANT ALL ON TABLE customers TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE customers TO PUBLIC;


--
-- Name: note; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE note FROM PUBLIC;
REVOKE ALL ON TABLE note FROM dbowner;
GRANT ALL ON TABLE note TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE note TO PUBLIC;


--
-- Name: note_note_id_seq; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE note_note_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE note_note_id_seq FROM dbowner;
GRANT ALL ON TABLE note_note_id_seq TO dbowner;
GRANT ALL ON TABLE note_note_id_seq TO PUBLIC;


--
-- Name: problem; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE problem FROM PUBLIC;
REVOKE ALL ON TABLE problem FROM dbowner;
GRANT ALL ON TABLE problem TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE problem TO PUBLIC;


--
-- Name: problem_problem_id_seq; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE problem_problem_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE problem_problem_id_seq FROM dbowner;
GRANT ALL ON TABLE problem_problem_id_seq TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE problem_problem_id_seq TO PUBLIC;


--
-- Name: workorder; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE workorder FROM PUBLIC;
REVOKE ALL ON TABLE workorder FROM dbowner;
GRANT ALL ON TABLE workorder TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE workorder TO PUBLIC;


--
-- Name: workorder_workorder_id_seq; Type: ACL; Schema: public; Owner: dbowner
--

REVOKE ALL ON TABLE workorder_workorder_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE workorder_workorder_id_seq FROM dbowner;
GRANT ALL ON TABLE workorder_workorder_id_seq TO dbowner;
GRANT INSERT,SELECT,UPDATE,DELETE ON TABLE workorder_workorder_id_seq TO PUBLIC;


--
-- PostgreSQL database dump complete
--


