// Code generated by smithy-go-codegen DO NOT EDIT.

package route53recoveryreadiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a resource set. A resource set is a set of resources of one type that
// span multiple cells. You can associate a resource set with a readiness check to
// monitor the resources for failover readiness.
func (c *Client) CreateResourceSet(ctx context.Context, params *CreateResourceSetInput, optFns ...func(*Options)) (*CreateResourceSetOutput, error) {
	if params == nil {
		params = &CreateResourceSetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateResourceSet", params, optFns, c.addOperationCreateResourceSetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateResourceSetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateResourceSetInput struct {

	// The name of the resource set to create.
	//
	// This member is required.
	ResourceSetName *string

	// The resource type of the resources in the resource set. Enter one of the
	// following values for resource type:
	//
	// AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage,
	// AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm,
	// AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume,
	// AWS::ElasticLoadBalancing::LoadBalancer,
	// AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function,
	// AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck,
	// AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC,
	// AWS::EC2::VPNConnection, AWS::EC2::VPNGateway,
	// AWS::Route53RecoveryReadiness::DNSTargetResource
	//
	// This member is required.
	ResourceSetType *string

	// A list of resource objects in the resource set.
	//
	// This member is required.
	Resources []types.Resource

	// A tag to associate with the parameters for a resource set.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateResourceSetOutput struct {

	// The Amazon Resource Name (ARN) for the resource set.
	ResourceSetArn *string

	// The name of the resource set.
	ResourceSetName *string

	// The resource type of the resources in the resource set. Enter one of the
	// following values for resource type:
	//
	// AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage,
	// AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm,
	// AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume,
	// AWS::ElasticLoadBalancing::LoadBalancer,
	// AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function,
	// AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck,
	// AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC,
	// AWS::EC2::VPNConnection, AWS::EC2::VPNGateway,
	// AWS::Route53RecoveryReadiness::DNSTargetResource
	ResourceSetType *string

	// A list of resource objects.
	Resources []types.Resource

	// A collection of tags associated with a resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateResourceSetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateResourceSet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateResourceSet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateResourceSet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateResourceSetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateResourceSet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateResourceSet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateResourceSet",
	}
}
