// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the data objects for the specified firewall policy.
func (c *Client) DescribeFirewallPolicy(ctx context.Context, params *DescribeFirewallPolicyInput, optFns ...func(*Options)) (*DescribeFirewallPolicyOutput, error) {
	if params == nil {
		params = &DescribeFirewallPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFirewallPolicy", params, optFns, c.addOperationDescribeFirewallPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFirewallPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFirewallPolicyInput struct {

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallPolicyArn *string

	// The descriptive name of the firewall policy. You can't change the name of a
	// firewall policy after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallPolicyName *string

	noSmithyDocumentSerde
}

type DescribeFirewallPolicyOutput struct {

	// The high-level properties of a firewall policy. This, along with the FirewallPolicy, define
	// the policy. You can retrieve all objects for a firewall policy by calling DescribeFirewallPolicy.
	//
	// This member is required.
	FirewallPolicyResponse *types.FirewallPolicyResponse

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the firewall policy. The token marks the state of the
	// policy resource at the time of the request.
	//
	// To make changes to the policy, you provide the token in your request. Network
	// Firewall uses the token to ensure that the policy hasn't changed since you last
	// retrieved it. If it has changed, the operation fails with an
	// InvalidTokenException . If this happens, retrieve the firewall policy again to
	// get a current copy of it with current token. Reapply your changes as needed,
	// then try the operation again using the new token.
	//
	// This member is required.
	UpdateToken *string

	// The policy for the specified firewall policy.
	FirewallPolicy *types.FirewallPolicy

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFirewallPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeFirewallPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeFirewallPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFirewallPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFirewallPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeFirewallPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFirewallPolicy",
	}
}
