// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a data provider using the provided settings. A data provider stores a
// data store type and location information about your database.
func (c *Client) CreateDataProvider(ctx context.Context, params *CreateDataProviderInput, optFns ...func(*Options)) (*CreateDataProviderOutput, error) {
	if params == nil {
		params = &CreateDataProviderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataProvider", params, optFns, c.addOperationCreateDataProviderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataProviderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataProviderInput struct {

	// The type of database engine for the data provider. Valid values include "aurora"
	// , "aurora-postgresql" , "mysql" , "oracle" , "postgres" , "sqlserver" , redshift
	// , mariadb , mongodb , and docdb . A value of "aurora" represents Amazon Aurora
	// MySQL-Compatible Edition.
	//
	// This member is required.
	Engine *string

	// The settings in JSON format for a data provider.
	//
	// This member is required.
	Settings types.DataProviderSettings

	// A user-friendly name for the data provider.
	DataProviderName *string

	// A user-friendly description of the data provider.
	Description *string

	// One or more tags to be assigned to the data provider.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateDataProviderOutput struct {

	// The data provider that was created.
	DataProvider *types.DataProvider

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataProviderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateDataProvider{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateDataProvider{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataProvider"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateDataProviderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataProvider(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataProvider(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataProvider",
	}
}
