//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armresourceconnector

import "time"

// Appliances definition.
type Appliance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Identity for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The set of properties specific to an Appliance
	Properties *ApplianceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplianceCredentialKubeconfig - Cluster User Credential appliance.
type ApplianceCredentialKubeconfig struct {
	// READ-ONLY; Name which contains the role of the kubeconfig.
	Name *AccessProfileType `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Contains the kubeconfig value.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// ApplianceListClusterCustomerUserCredentialResults - The List Cluster Customer User Credential Results appliance.
type ApplianceListClusterCustomerUserCredentialResults struct {
	// READ-ONLY; The list of appliance kubeconfigs.
	Kubeconfigs []*ApplianceCredentialKubeconfig `json:"kubeconfigs,omitempty" azure:"ro"`

	// READ-ONLY; Map of Customer User Public and Private SSH Keys
	SSHKeys map[string]*SSHKey `json:"sshKeys,omitempty" azure:"ro"`
}

// ApplianceListCredentialResults - The List Cluster User Credential appliance.
type ApplianceListCredentialResults struct {
	// READ-ONLY; Contains the REP (rendezvous endpoint) and “Listener” access token from notification service (NS).
	HybridConnectionConfig *HybridConnectionConfig `json:"hybridConnectionConfig,omitempty" azure:"ro"`

	// READ-ONLY; The list of appliance kubeconfigs.
	Kubeconfigs []*ApplianceCredentialKubeconfig `json:"kubeconfigs,omitempty" azure:"ro"`
}

// ApplianceListResult - The List Appliances operation response.
type ApplianceListResult struct {
	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of Appliances.
	Value []*Appliance `json:"value,omitempty" azure:"ro"`
}

// ApplianceOperation - Appliances operation.
type ApplianceOperation struct {
	// Describes the properties of an Appliances Operation Value Display.
	Display *ApplianceOperationValueDisplay `json:"display,omitempty"`

	// READ-ONLY; Is this Operation a data plane operation
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the compute operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the compute operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// ApplianceOperationValueDisplay - Describes the properties of an Appliances Operation Value Display.
type ApplianceOperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// ApplianceOperationsList - Lists of Appliances operations.
type ApplianceOperationsList struct {
	// REQUIRED; Array of applianceOperation
	Value []*ApplianceOperation `json:"value,omitempty"`

	// Next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplianceProperties - Properties for an appliance.
type ApplianceProperties struct {
	// Represents a supported Fabric/Infra. (AKSEdge etc…).
	Distro *Distro `json:"distro,omitempty"`

	// Contains infrastructure information about the Appliance
	InfrastructureConfig *AppliancePropertiesInfrastructureConfig `json:"infrastructureConfig,omitempty"`

	// Certificates pair used to download MSI certificate from HIS
	PublicKey *string `json:"publicKey,omitempty"`

	// Version of the Appliance
	Version *string `json:"version,omitempty"`

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Appliance’s health and state of connection to on-prem
	Status *Status `json:"status,omitempty" azure:"ro"`
}

// AppliancePropertiesInfrastructureConfig - Contains infrastructure information about the Appliance
type AppliancePropertiesInfrastructureConfig struct {
	// Information about the connected appliance.
	Provider *Provider `json:"provider,omitempty"`
}

// AppliancesClientBeginCreateOrUpdateOptions contains the optional parameters for the AppliancesClient.BeginCreateOrUpdate
// method.
type AppliancesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AppliancesClientBeginDeleteOptions contains the optional parameters for the AppliancesClient.BeginDelete method.
type AppliancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AppliancesClientGetOptions contains the optional parameters for the AppliancesClient.Get method.
type AppliancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AppliancesClientGetUpgradeGraphOptions contains the optional parameters for the AppliancesClient.GetUpgradeGraph method.
type AppliancesClientGetUpgradeGraphOptions struct {
	// placeholder for future optional parameters
}

// AppliancesClientListByResourceGroupOptions contains the optional parameters for the AppliancesClient.ListByResourceGroup
// method.
type AppliancesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AppliancesClientListBySubscriptionOptions contains the optional parameters for the AppliancesClient.ListBySubscription
// method.
type AppliancesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AppliancesClientListClusterCustomerUserCredentialOptions contains the optional parameters for the AppliancesClient.ListClusterCustomerUserCredential
// method.
type AppliancesClientListClusterCustomerUserCredentialOptions struct {
	// placeholder for future optional parameters
}

// AppliancesClientListClusterUserCredentialOptions contains the optional parameters for the AppliancesClient.ListClusterUserCredential
// method.
type AppliancesClientListClusterUserCredentialOptions struct {
	// placeholder for future optional parameters
}

// AppliancesClientListOperationsOptions contains the optional parameters for the AppliancesClient.ListOperations method.
type AppliancesClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// AppliancesClientUpdateOptions contains the optional parameters for the AppliancesClient.Update method.
type AppliancesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// HybridConnectionConfig - Contains the REP (rendezvous endpoint) and “Listener” access token from notification service (NS).
type HybridConnectionConfig struct {
	// READ-ONLY; Timestamp when this token will be expired.
	ExpirationTime *int64 `json:"expirationTime,omitempty" azure:"ro"`

	// READ-ONLY; Name of the connection
	HybridConnectionName *string `json:"hybridConnectionName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the notification service.
	Relay *string `json:"relay,omitempty" azure:"ro"`

	// READ-ONLY; Listener access token
	Token *string `json:"token,omitempty" azure:"ro"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// PatchableAppliance - The Appliances patchable resource definition.
type PatchableAppliance struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SSHKey - Appliance SSHKey definition.
type SSHKey struct {
	// User Private Key.
	PrivateKey *string `json:"privateKey,omitempty"`

	// User Public Key.
	PublicKey *string `json:"publicKey,omitempty"`
}

// SupportedVersion - The SupportedVersion object for appliance.
type SupportedVersion struct {
	// READ-ONLY; This is the metadata of the supported newer version.
	Metadata *SupportedVersionMetadata `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The newer version available for upgrade.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// SupportedVersionCatalogVersion - The SupportedVersionCatalogVersion object for appliance.
type SupportedVersionCatalogVersion struct {
	// READ-ONLY; The newer supported version catalog version data.
	Data *SupportedVersionCatalogVersionData `json:"data,omitempty" azure:"ro"`

	// READ-ONLY; The catalog version name for the version available for upgrade.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The catalog version namespace for the version available for upgrade.
	Namespace *string `json:"namespace,omitempty" azure:"ro"`
}

// SupportedVersionCatalogVersionData - The SupportedVersionCatalogVersionData object for appliance.
type SupportedVersionCatalogVersionData struct {
	// READ-ONLY; The image audience name for the version available for upgrade.
	Audience *string `json:"audience,omitempty" azure:"ro"`

	// READ-ONLY; The image catalog name for the version available for upgrade.
	Catalog *string `json:"catalog,omitempty" azure:"ro"`

	// READ-ONLY; The image offer name for the version available for upgrade.
	Offer *string `json:"offer,omitempty" azure:"ro"`

	// READ-ONLY; The image version for the version available for upgrade.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// SupportedVersionMetadata - The SupportedVersionMetadata object for appliance.
type SupportedVersionMetadata struct {
	// READ-ONLY; The newer supported version catalog version.
	CatalogVersion *SupportedVersionCatalogVersion `json:"catalogVersion,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpgradeGraph - The Upgrade Graph for appliance.
type UpgradeGraph struct {
	// The properties of supported version
	Properties *UpgradeGraphProperties `json:"properties,omitempty"`

	// READ-ONLY; The appliance resource path
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The release train name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// UpgradeGraphProperties - The Upgrade Graph Properties for appliance.
type UpgradeGraphProperties struct {
	// READ-ONLY; The current appliance version
	ApplianceVersion *string `json:"applianceVersion,omitempty" azure:"ro"`

	// READ-ONLY; This contains the current version and supported upgrade versions.
	SupportedVersions []*SupportedVersion `json:"supportedVersions,omitempty" azure:"ro"`
}
