//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpostgresql

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ConfigurationListResult.
func (c ConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LogFileProperties.
func (l LogFileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdTime", l.CreatedTime)
	populateTimeRFC3339(objectMap, "lastModifiedTime", l.LastModifiedTime)
	populate(objectMap, "sizeInKB", l.SizeInKB)
	populate(objectMap, "type", l.Type)
	populate(objectMap, "url", l.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogFileProperties.
func (l *LogFileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &l.CreatedTime)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &l.LastModifiedTime)
			delete(rawMsg, key)
		case "sizeInKB":
			err = unpopulate(val, "SizeInKB", &l.SizeInKB)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &l.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAlertPolicyProperties.
func (s SecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disabledAlerts", s.DisabledAlerts)
	populate(objectMap, "emailAccountAdmins", s.EmailAccountAdmins)
	populate(objectMap, "emailAddresses", s.EmailAddresses)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerForCreate.
func (s ServerForCreate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerForCreate.
func (s *ServerForCreate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalServerPropertiesForCreateClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerKeyProperties.
func (s ServerKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationDate", s.CreationDate)
	populate(objectMap, "serverKeyType", s.ServerKeyType)
	populate(objectMap, "uri", s.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerKeyProperties.
func (s *ServerKeyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &s.CreationDate)
			delete(rawMsg, key)
		case "serverKeyType":
			err = unpopulate(val, "ServerKeyType", &s.ServerKeyType)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &s.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerProperties.
func (s ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "administratorLogin", s.AdministratorLogin)
	populate(objectMap, "byokEnforcement", s.ByokEnforcement)
	populateTimeRFC3339(objectMap, "earliestRestoreDate", s.EarliestRestoreDate)
	populate(objectMap, "fullyQualifiedDomainName", s.FullyQualifiedDomainName)
	populate(objectMap, "infrastructureEncryption", s.InfrastructureEncryption)
	populate(objectMap, "masterServerId", s.MasterServerID)
	populate(objectMap, "minimalTlsVersion", s.MinimalTLSVersion)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "replicaCapacity", s.ReplicaCapacity)
	populate(objectMap, "replicationRole", s.ReplicationRole)
	populate(objectMap, "sslEnforcement", s.SSLEnforcement)
	populate(objectMap, "storageProfile", s.StorageProfile)
	populate(objectMap, "userVisibleState", s.UserVisibleState)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerProperties.
func (s *ServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorLogin":
			err = unpopulate(val, "AdministratorLogin", &s.AdministratorLogin)
			delete(rawMsg, key)
		case "byokEnforcement":
			err = unpopulate(val, "ByokEnforcement", &s.ByokEnforcement)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &s.EarliestRestoreDate)
			delete(rawMsg, key)
		case "fullyQualifiedDomainName":
			err = unpopulate(val, "FullyQualifiedDomainName", &s.FullyQualifiedDomainName)
			delete(rawMsg, key)
		case "infrastructureEncryption":
			err = unpopulate(val, "InfrastructureEncryption", &s.InfrastructureEncryption)
			delete(rawMsg, key)
		case "masterServerId":
			err = unpopulate(val, "MasterServerID", &s.MasterServerID)
			delete(rawMsg, key)
		case "minimalTlsVersion":
			err = unpopulate(val, "MinimalTLSVersion", &s.MinimalTLSVersion)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "replicaCapacity":
			err = unpopulate(val, "ReplicaCapacity", &s.ReplicaCapacity)
			delete(rawMsg, key)
		case "replicationRole":
			err = unpopulate(val, "ReplicationRole", &s.ReplicationRole)
			delete(rawMsg, key)
		case "sslEnforcement":
			err = unpopulate(val, "SSLEnforcement", &s.SSLEnforcement)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &s.StorageProfile)
			delete(rawMsg, key)
		case "userVisibleState":
			err = unpopulate(val, "UserVisibleState", &s.UserVisibleState)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerPropertiesForDefaultCreate.
func (s ServerPropertiesForDefaultCreate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "administratorLogin", s.AdministratorLogin)
	populate(objectMap, "administratorLoginPassword", s.AdministratorLoginPassword)
	objectMap["createMode"] = CreateModeDefault
	populate(objectMap, "infrastructureEncryption", s.InfrastructureEncryption)
	populate(objectMap, "minimalTlsVersion", s.MinimalTLSVersion)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "sslEnforcement", s.SSLEnforcement)
	populate(objectMap, "storageProfile", s.StorageProfile)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerPropertiesForDefaultCreate.
func (s *ServerPropertiesForDefaultCreate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorLogin":
			err = unpopulate(val, "AdministratorLogin", &s.AdministratorLogin)
			delete(rawMsg, key)
		case "administratorLoginPassword":
			err = unpopulate(val, "AdministratorLoginPassword", &s.AdministratorLoginPassword)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "infrastructureEncryption":
			err = unpopulate(val, "InfrastructureEncryption", &s.InfrastructureEncryption)
			delete(rawMsg, key)
		case "minimalTlsVersion":
			err = unpopulate(val, "MinimalTLSVersion", &s.MinimalTLSVersion)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "sslEnforcement":
			err = unpopulate(val, "SSLEnforcement", &s.SSLEnforcement)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &s.StorageProfile)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerPropertiesForGeoRestore.
func (s ServerPropertiesForGeoRestore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["createMode"] = CreateModeGeoRestore
	populate(objectMap, "infrastructureEncryption", s.InfrastructureEncryption)
	populate(objectMap, "minimalTlsVersion", s.MinimalTLSVersion)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "sslEnforcement", s.SSLEnforcement)
	populate(objectMap, "sourceServerId", s.SourceServerID)
	populate(objectMap, "storageProfile", s.StorageProfile)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerPropertiesForGeoRestore.
func (s *ServerPropertiesForGeoRestore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "infrastructureEncryption":
			err = unpopulate(val, "InfrastructureEncryption", &s.InfrastructureEncryption)
			delete(rawMsg, key)
		case "minimalTlsVersion":
			err = unpopulate(val, "MinimalTLSVersion", &s.MinimalTLSVersion)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "sslEnforcement":
			err = unpopulate(val, "SSLEnforcement", &s.SSLEnforcement)
			delete(rawMsg, key)
		case "sourceServerId":
			err = unpopulate(val, "SourceServerID", &s.SourceServerID)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &s.StorageProfile)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerPropertiesForReplica.
func (s ServerPropertiesForReplica) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["createMode"] = CreateModeReplica
	populate(objectMap, "infrastructureEncryption", s.InfrastructureEncryption)
	populate(objectMap, "minimalTlsVersion", s.MinimalTLSVersion)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "sslEnforcement", s.SSLEnforcement)
	populate(objectMap, "sourceServerId", s.SourceServerID)
	populate(objectMap, "storageProfile", s.StorageProfile)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerPropertiesForReplica.
func (s *ServerPropertiesForReplica) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "infrastructureEncryption":
			err = unpopulate(val, "InfrastructureEncryption", &s.InfrastructureEncryption)
			delete(rawMsg, key)
		case "minimalTlsVersion":
			err = unpopulate(val, "MinimalTLSVersion", &s.MinimalTLSVersion)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "sslEnforcement":
			err = unpopulate(val, "SSLEnforcement", &s.SSLEnforcement)
			delete(rawMsg, key)
		case "sourceServerId":
			err = unpopulate(val, "SourceServerID", &s.SourceServerID)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &s.StorageProfile)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerPropertiesForRestore.
func (s ServerPropertiesForRestore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["createMode"] = CreateModePointInTimeRestore
	populate(objectMap, "infrastructureEncryption", s.InfrastructureEncryption)
	populate(objectMap, "minimalTlsVersion", s.MinimalTLSVersion)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populateTimeRFC3339(objectMap, "restorePointInTime", s.RestorePointInTime)
	populate(objectMap, "sslEnforcement", s.SSLEnforcement)
	populate(objectMap, "sourceServerId", s.SourceServerID)
	populate(objectMap, "storageProfile", s.StorageProfile)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerPropertiesForRestore.
func (s *ServerPropertiesForRestore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "infrastructureEncryption":
			err = unpopulate(val, "InfrastructureEncryption", &s.InfrastructureEncryption)
			delete(rawMsg, key)
		case "minimalTlsVersion":
			err = unpopulate(val, "MinimalTLSVersion", &s.MinimalTLSVersion)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "restorePointInTime":
			err = unpopulateTimeRFC3339(val, "RestorePointInTime", &s.RestorePointInTime)
			delete(rawMsg, key)
		case "sslEnforcement":
			err = unpopulate(val, "SSLEnforcement", &s.SSLEnforcement)
			delete(rawMsg, key)
		case "sourceServerId":
			err = unpopulate(val, "SourceServerID", &s.SourceServerID)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &s.StorageProfile)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerUpdateParameters.
func (s ServerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
