//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmysqlflexibleservers

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Backup.
func (b Backup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupRetentionDays", b.BackupRetentionDays)
	populateTimeRFC3339(objectMap, "earliestRestoreDate", b.EarliestRestoreDate)
	populate(objectMap, "geoRedundantBackup", b.GeoRedundantBackup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Backup.
func (b *Backup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupRetentionDays":
			err = unpopulate(val, "BackupRetentionDays", &b.BackupRetentionDays)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &b.EarliestRestoreDate)
			delete(rawMsg, key)
		case "geoRedundantBackup":
			err = unpopulate(val, "GeoRedundantBackup", &b.GeoRedundantBackup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationListForBatchUpdate.
func (c ConfigurationListForBatchUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerBackupProperties.
func (s ServerBackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupType", s.BackupType)
	populateTimeRFC3339(objectMap, "completedTime", s.CompletedTime)
	populate(objectMap, "source", s.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerBackupProperties.
func (s *ServerBackupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupType":
			err = unpopulate(val, "BackupType", &s.BackupType)
			delete(rawMsg, key)
		case "completedTime":
			err = unpopulateTimeRFC3339(val, "CompletedTime", &s.CompletedTime)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &s.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerForUpdate.
func (s ServerForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerProperties.
func (s ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "administratorLogin", s.AdministratorLogin)
	populate(objectMap, "administratorLoginPassword", s.AdministratorLoginPassword)
	populate(objectMap, "availabilityZone", s.AvailabilityZone)
	populate(objectMap, "backup", s.Backup)
	populate(objectMap, "createMode", s.CreateMode)
	populate(objectMap, "dataEncryption", s.DataEncryption)
	populate(objectMap, "fullyQualifiedDomainName", s.FullyQualifiedDomainName)
	populate(objectMap, "highAvailability", s.HighAvailability)
	populate(objectMap, "maintenanceWindow", s.MaintenanceWindow)
	populate(objectMap, "network", s.Network)
	populate(objectMap, "replicaCapacity", s.ReplicaCapacity)
	populate(objectMap, "replicationRole", s.ReplicationRole)
	populateTimeRFC3339(objectMap, "restorePointInTime", s.RestorePointInTime)
	populate(objectMap, "sourceServerResourceId", s.SourceServerResourceID)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storage", s.Storage)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerProperties.
func (s *ServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorLogin":
			err = unpopulate(val, "AdministratorLogin", &s.AdministratorLogin)
			delete(rawMsg, key)
		case "administratorLoginPassword":
			err = unpopulate(val, "AdministratorLoginPassword", &s.AdministratorLoginPassword)
			delete(rawMsg, key)
		case "availabilityZone":
			err = unpopulate(val, "AvailabilityZone", &s.AvailabilityZone)
			delete(rawMsg, key)
		case "backup":
			err = unpopulate(val, "Backup", &s.Backup)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "dataEncryption":
			err = unpopulate(val, "DataEncryption", &s.DataEncryption)
			delete(rawMsg, key)
		case "fullyQualifiedDomainName":
			err = unpopulate(val, "FullyQualifiedDomainName", &s.FullyQualifiedDomainName)
			delete(rawMsg, key)
		case "highAvailability":
			err = unpopulate(val, "HighAvailability", &s.HighAvailability)
			delete(rawMsg, key)
		case "maintenanceWindow":
			err = unpopulate(val, "MaintenanceWindow", &s.MaintenanceWindow)
			delete(rawMsg, key)
		case "network":
			err = unpopulate(val, "Network", &s.Network)
			delete(rawMsg, key)
		case "replicaCapacity":
			err = unpopulate(val, "ReplicaCapacity", &s.ReplicaCapacity)
			delete(rawMsg, key)
		case "replicationRole":
			err = unpopulate(val, "ReplicationRole", &s.ReplicationRole)
			delete(rawMsg, key)
		case "restorePointInTime":
			err = unpopulateTimeRFC3339(val, "RestorePointInTime", &s.RestorePointInTime)
			delete(rawMsg, key)
		case "sourceServerResourceId":
			err = unpopulate(val, "SourceServerResourceID", &s.SourceServerResourceID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storage":
			err = unpopulate(val, "Storage", &s.Storage)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
