//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevhub

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DeveloperHubServiceClient contains the methods for the DeveloperHubServiceClient group.
// Don't use this type directly, use NewDeveloperHubServiceClient() instead.
type DeveloperHubServiceClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewDeveloperHubServiceClient creates a new instance of DeveloperHubServiceClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewDeveloperHubServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DeveloperHubServiceClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &DeveloperHubServiceClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// GitHubOAuth - Gets GitHubOAuth info used to authenticate users with the Developer Hub GitHub App.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-04-01-preview
// location - The name of Azure region.
// options - DeveloperHubServiceClientGitHubOAuthOptions contains the optional parameters for the DeveloperHubServiceClient.GitHubOAuth
// method.
func (client *DeveloperHubServiceClient) GitHubOAuth(ctx context.Context, location string, options *DeveloperHubServiceClientGitHubOAuthOptions) (DeveloperHubServiceClientGitHubOAuthResponse, error) {
	req, err := client.gitHubOAuthCreateRequest(ctx, location, options)
	if err != nil {
		return DeveloperHubServiceClientGitHubOAuthResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DeveloperHubServiceClientGitHubOAuthResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DeveloperHubServiceClientGitHubOAuthResponse{}, runtime.NewResponseError(resp)
	}
	return client.gitHubOAuthHandleResponse(resp)
}

// gitHubOAuthCreateRequest creates the GitHubOAuth request.
func (client *DeveloperHubServiceClient) gitHubOAuthCreateRequest(ctx context.Context, location string, options *DeveloperHubServiceClientGitHubOAuthOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DevHub/locations/{location}/githuboauth/default/getGitHubOAuthInfo"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Parameters != nil {
		return req, runtime.MarshalAsJSON(req, *options.Parameters)
	}
	return req, nil
}

// gitHubOAuthHandleResponse handles the GitHubOAuth response.
func (client *DeveloperHubServiceClient) gitHubOAuthHandleResponse(resp *http.Response) (DeveloperHubServiceClientGitHubOAuthResponse, error) {
	result := DeveloperHubServiceClientGitHubOAuthResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GitHubOAuthInfoResponse); err != nil {
		return DeveloperHubServiceClientGitHubOAuthResponse{}, err
	}
	return result, nil
}

// GitHubOAuthCallback - Callback URL to hit once authenticated with GitHub App to have the service store the OAuth token.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-04-01-preview
// location - The name of Azure region.
// code - The code response from authenticating the GitHub App.
// state - The state response from authenticating the GitHub App.
// options - DeveloperHubServiceClientGitHubOAuthCallbackOptions contains the optional parameters for the DeveloperHubServiceClient.GitHubOAuthCallback
// method.
func (client *DeveloperHubServiceClient) GitHubOAuthCallback(ctx context.Context, location string, code string, state string, options *DeveloperHubServiceClientGitHubOAuthCallbackOptions) (DeveloperHubServiceClientGitHubOAuthCallbackResponse, error) {
	req, err := client.gitHubOAuthCallbackCreateRequest(ctx, location, code, state, options)
	if err != nil {
		return DeveloperHubServiceClientGitHubOAuthCallbackResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DeveloperHubServiceClientGitHubOAuthCallbackResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DeveloperHubServiceClientGitHubOAuthCallbackResponse{}, runtime.NewResponseError(resp)
	}
	return client.gitHubOAuthCallbackHandleResponse(resp)
}

// gitHubOAuthCallbackCreateRequest creates the GitHubOAuthCallback request.
func (client *DeveloperHubServiceClient) gitHubOAuthCallbackCreateRequest(ctx context.Context, location string, code string, state string, options *DeveloperHubServiceClientGitHubOAuthCallbackOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DevHub/locations/{location}/githuboauth/default"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-04-01-preview")
	reqQP.Set("code", code)
	reqQP.Set("state", state)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// gitHubOAuthCallbackHandleResponse handles the GitHubOAuthCallback response.
func (client *DeveloperHubServiceClient) gitHubOAuthCallbackHandleResponse(resp *http.Response) (DeveloperHubServiceClientGitHubOAuthCallbackResponse, error) {
	result := DeveloperHubServiceClientGitHubOAuthCallbackResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GitHubOAuthResponse); err != nil {
		return DeveloperHubServiceClientGitHubOAuthCallbackResponse{}, err
	}
	return result, nil
}

// ListGitHubOAuth - Callback URL to hit once authenticated with GitHub App to have the service store the OAuth token.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-04-01-preview
// location - The name of Azure region.
// options - DeveloperHubServiceClientListGitHubOAuthOptions contains the optional parameters for the DeveloperHubServiceClient.ListGitHubOAuth
// method.
func (client *DeveloperHubServiceClient) ListGitHubOAuth(ctx context.Context, location string, options *DeveloperHubServiceClientListGitHubOAuthOptions) (DeveloperHubServiceClientListGitHubOAuthResponse, error) {
	req, err := client.listGitHubOAuthCreateRequest(ctx, location, options)
	if err != nil {
		return DeveloperHubServiceClientListGitHubOAuthResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DeveloperHubServiceClientListGitHubOAuthResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DeveloperHubServiceClientListGitHubOAuthResponse{}, runtime.NewResponseError(resp)
	}
	return client.listGitHubOAuthHandleResponse(resp)
}

// listGitHubOAuthCreateRequest creates the ListGitHubOAuth request.
func (client *DeveloperHubServiceClient) listGitHubOAuthCreateRequest(ctx context.Context, location string, options *DeveloperHubServiceClientListGitHubOAuthOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DevHub/locations/{location}/githuboauth"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGitHubOAuthHandleResponse handles the ListGitHubOAuth response.
func (client *DeveloperHubServiceClient) listGitHubOAuthHandleResponse(resp *http.Response) (DeveloperHubServiceClientListGitHubOAuthResponse, error) {
	result := DeveloperHubServiceClientListGitHubOAuthResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GitHubOAuthListResponse); err != nil {
		return DeveloperHubServiceClientListGitHubOAuthResponse{}, err
	}
	return result, nil
}
