//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

import "time"

// AFDCustomDomainsClientBeginCreateOptions contains the optional parameters for the AFDCustomDomainsClient.BeginCreate method.
type AFDCustomDomainsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDCustomDomainsClientBeginDeleteOptions contains the optional parameters for the AFDCustomDomainsClient.BeginDelete method.
type AFDCustomDomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDCustomDomainsClientBeginRefreshValidationTokenOptions contains the optional parameters for the AFDCustomDomainsClient.BeginRefreshValidationToken
// method.
type AFDCustomDomainsClientBeginRefreshValidationTokenOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDCustomDomainsClientBeginUpdateOptions contains the optional parameters for the AFDCustomDomainsClient.BeginUpdate method.
type AFDCustomDomainsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDCustomDomainsClientGetOptions contains the optional parameters for the AFDCustomDomainsClient.Get method.
type AFDCustomDomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AFDCustomDomainsClientListByProfileOptions contains the optional parameters for the AFDCustomDomainsClient.ListByProfile
// method.
type AFDCustomDomainsClientListByProfileOptions struct {
	// placeholder for future optional parameters
}

// AFDDomain - Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g.
// www.contoso.com.
type AFDDomain struct {
	// The JSON object that contains the properties of the domain to create.
	Properties *AFDDomainProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AFDDomainHTTPSParameters - The JSON object that contains the properties to secure a domain.
type AFDDomainHTTPSParameters struct {
	// REQUIRED; Defines the source of the SSL certificate.
	CertificateType *AfdCertificateType `json:"certificateType,omitempty"`

	// TLS protocol version that will be used for Https
	MinimumTLSVersion *AfdMinimumTLSVersion `json:"minimumTlsVersion,omitempty"`

	// Resource reference to the secret. ie. subs/rg/profile/secret
	Secret *ResourceReference `json:"secret,omitempty"`
}

// AFDDomainListResult - Result of the request to list domains. It contains a list of domain objects and a URL link to get
// the next set of results.
type AFDDomainListResult struct {
	// URL to get the next set of domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of AzureFrontDoor domains within a profile.
	Value []*AFDDomain `json:"value,omitempty" azure:"ro"`
}

// AFDDomainProperties - The JSON object that contains the properties of the domain to create.
type AFDDomainProperties struct {
	// REQUIRED; The host name of the domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`

	// Resource reference to the Azure DNS zone
	AzureDNSZone *ResourceReference `json:"azureDnsZone,omitempty"`

	// Resource reference to the Azure resource where custom domain ownership was prevalidated
	PreValidatedCustomDomainResourceID *ResourceReference `json:"preValidatedCustomDomainResourceId,omitempty"`

	// The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own
	// certificate. If not specified, enabling ssl uses AzureFrontDoor managed
	// certificate by default.
	TLSSettings *AFDDomainHTTPSParameters `json:"tlsSettings,omitempty"`

	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. DCV stands
	// for DomainControlValidation.
	DomainValidationState *DomainValidationState `json:"domainValidationState,omitempty" azure:"ro"`

	// READ-ONLY; The name of the profile which holds the domain.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Values the customer needs to validate domain ownership
	ValidationProperties *DomainValidationProperties `json:"validationProperties,omitempty" azure:"ro"`
}

// AFDDomainUpdateParameters - The domain JSON object required for domain creation or update.
type AFDDomainUpdateParameters struct {
	// The JSON object that contains the properties of the domain to create.
	Properties *AFDDomainUpdatePropertiesParameters `json:"properties,omitempty"`
}

// AFDDomainUpdatePropertiesParameters - The JSON object that contains the properties of the domain to create.
type AFDDomainUpdatePropertiesParameters struct {
	// Resource reference to the Azure DNS zone
	AzureDNSZone *ResourceReference `json:"azureDnsZone,omitempty"`

	// Resource reference to the Azure resource where custom domain ownership was prevalidated
	PreValidatedCustomDomainResourceID *ResourceReference `json:"preValidatedCustomDomainResourceId,omitempty"`

	// The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own
	// certificate. If not specified, enabling ssl uses AzureFrontDoor managed
	// certificate by default.
	TLSSettings *AFDDomainHTTPSParameters `json:"tlsSettings,omitempty"`

	// READ-ONLY; The name of the profile which holds the domain.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`
}

// AFDEndpoint - CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol,
// content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format
// .azureedge.net.
type AFDEndpoint struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// The JSON object that contains the properties required to create an endpoint.
	Properties *AFDEndpointProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AFDEndpointListResult - Result of the request to list endpoints. It contains a list of endpoint objects and a URL link
// to get the next set of results.
type AFDEndpointListResult struct {
	// URL to get the next set of endpoint objects if there is any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of AzureFrontDoor endpoints within a profile
	Value []*AFDEndpoint `json:"value,omitempty" azure:"ro"`
}

// AFDEndpointProperties - The JSON object that contains the properties required to create an endpoint.
type AFDEndpointProperties struct {
	// Indicates the endpoint name reuse scope. The default value is TenantReuse.
	AutoGeneratedDomainNameLabelScope *AutoGeneratedDomainNameLabelScope `json:"autoGeneratedDomainNameLabelScope,omitempty"`

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *EnabledState `json:"enabledState,omitempty"`

	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
	HostName *string `json:"hostName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the profile which holds the endpoint.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AFDEndpointPropertiesUpdateParameters - The JSON object containing endpoint update parameters.
type AFDEndpointPropertiesUpdateParameters struct {
	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *EnabledState `json:"enabledState,omitempty"`

	// READ-ONLY; The name of the profile which holds the endpoint.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`
}

// AFDEndpointUpdateParameters - Properties required to create or update an endpoint.
type AFDEndpointUpdateParameters struct {
	// The JSON object containing endpoint update parameters.
	Properties *AFDEndpointPropertiesUpdateParameters `json:"properties,omitempty"`

	// Endpoint tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AFDEndpointsClientBeginCreateOptions contains the optional parameters for the AFDEndpointsClient.BeginCreate method.
type AFDEndpointsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDEndpointsClientBeginDeleteOptions contains the optional parameters for the AFDEndpointsClient.BeginDelete method.
type AFDEndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDEndpointsClientBeginPurgeContentOptions contains the optional parameters for the AFDEndpointsClient.BeginPurgeContent
// method.
type AFDEndpointsClientBeginPurgeContentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDEndpointsClientBeginUpdateOptions contains the optional parameters for the AFDEndpointsClient.BeginUpdate method.
type AFDEndpointsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDEndpointsClientGetOptions contains the optional parameters for the AFDEndpointsClient.Get method.
type AFDEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AFDEndpointsClientListByProfileOptions contains the optional parameters for the AFDEndpointsClient.ListByProfile method.
type AFDEndpointsClientListByProfileOptions struct {
	// placeholder for future optional parameters
}

// AFDEndpointsClientListResourceUsageOptions contains the optional parameters for the AFDEndpointsClient.ListResourceUsage
// method.
type AFDEndpointsClientListResourceUsageOptions struct {
	// placeholder for future optional parameters
}

// AFDEndpointsClientValidateCustomDomainOptions contains the optional parameters for the AFDEndpointsClient.ValidateCustomDomain
// method.
type AFDEndpointsClientValidateCustomDomainOptions struct {
	// placeholder for future optional parameters
}

// AFDOrigin - CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint
// do not have the requested content cached, they attempt to fetch it from one or more of
// the configured origins.
type AFDOrigin struct {
	// The JSON object that contains the properties of the origin.
	Properties *AFDOriginProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AFDOriginGroup - AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
// served from CDN.
type AFDOriginGroup struct {
	// The JSON object that contains the properties of the origin group.
	Properties *AFDOriginGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AFDOriginGroupListResult - Result of the request to list origin groups. It contains a list of origin groups objects and
// a URL link to get the next set of results.
type AFDOriginGroupListResult struct {
	// URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of CDN origin groups within an endpoint
	Value []*AFDOriginGroup `json:"value,omitempty" azure:"ro"`
}

// AFDOriginGroupProperties - The JSON object that contains the properties of the origin group.
type AFDOriginGroupProperties struct {
	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`

	// Load balancing settings for a backend pool
	LoadBalancingSettings *LoadBalancingSettingsParameters `json:"loadBalancingSettings,omitempty"`

	// Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
	SessionAffinityState *EnabledState `json:"sessionAffinityState,omitempty"`

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`

	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The name of the profile which holds the origin group.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AFDOriginGroupUpdateParameters - AFDOrigin group properties needed for origin group creation or update.
type AFDOriginGroupUpdateParameters struct {
	// The JSON object that contains the properties of the origin group.
	Properties *AFDOriginGroupUpdatePropertiesParameters `json:"properties,omitempty"`
}

// AFDOriginGroupUpdatePropertiesParameters - The JSON object that contains the properties of the origin group.
type AFDOriginGroupUpdatePropertiesParameters struct {
	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`

	// Load balancing settings for a backend pool
	LoadBalancingSettings *LoadBalancingSettingsParameters `json:"loadBalancingSettings,omitempty"`

	// Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
	SessionAffinityState *EnabledState `json:"sessionAffinityState,omitempty"`

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`

	// READ-ONLY; The name of the profile which holds the origin group.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`
}

// AFDOriginGroupsClientBeginCreateOptions contains the optional parameters for the AFDOriginGroupsClient.BeginCreate method.
type AFDOriginGroupsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDOriginGroupsClientBeginDeleteOptions contains the optional parameters for the AFDOriginGroupsClient.BeginDelete method.
type AFDOriginGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDOriginGroupsClientBeginUpdateOptions contains the optional parameters for the AFDOriginGroupsClient.BeginUpdate method.
type AFDOriginGroupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDOriginGroupsClientGetOptions contains the optional parameters for the AFDOriginGroupsClient.Get method.
type AFDOriginGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AFDOriginGroupsClientListByProfileOptions contains the optional parameters for the AFDOriginGroupsClient.ListByProfile
// method.
type AFDOriginGroupsClientListByProfileOptions struct {
	// placeholder for future optional parameters
}

// AFDOriginGroupsClientListResourceUsageOptions contains the optional parameters for the AFDOriginGroupsClient.ListResourceUsage
// method.
type AFDOriginGroupsClientListResourceUsageOptions struct {
	// placeholder for future optional parameters
}

// AFDOriginListResult - Result of the request to list origins. It contains a list of origin objects and a URL link to get
// the next set of results.
type AFDOriginListResult struct {
	// URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of CDN origins within an endpoint
	Value []*AFDOrigin `json:"value,omitempty" azure:"ro"`
}

// AFDOriginProperties - The JSON object that contains the properties of the origin.
type AFDOriginProperties struct {
	// Resource reference to the Azure origin resource.
	AzureOrigin *ResourceReference `json:"azureOrigin,omitempty"`

	// Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled
	// if there is a single enabled backend in single enabled backend pool.
	EnabledState *EnabledState `json:"enabledState,omitempty"`

	// Whether to enable certificate name check at origin level
	EnforceCertificateNameCheck *bool `json:"enforceCertificateNameCheck,omitempty"`

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`

	// The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across
	// all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services
	// require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string `json:"originHostHeader,omitempty"`

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5
	Priority *int32 `json:"priority,omitempty"`

	// The properties of the private link resource for private origin.
	SharedPrivateLinkResource *SharedPrivateLinkResourceProperties `json:"sharedPrivateLinkResource,omitempty"`

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`

	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The name of the origin group which contains this origin.
	OriginGroupName *string `json:"originGroupName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AFDOriginUpdateParameters - AFDOrigin properties needed for origin update.
type AFDOriginUpdateParameters struct {
	// The JSON object that contains the properties of the origin.
	Properties *AFDOriginUpdatePropertiesParameters `json:"properties,omitempty"`
}

// AFDOriginUpdatePropertiesParameters - The JSON object that contains the properties of the origin.
type AFDOriginUpdatePropertiesParameters struct {
	// Resource reference to the Azure origin resource.
	AzureOrigin *ResourceReference `json:"azureOrigin,omitempty"`

	// Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled
	// if there is a single enabled backend in single enabled backend pool.
	EnabledState *EnabledState `json:"enabledState,omitempty"`

	// Whether to enable certificate name check at origin level
	EnforceCertificateNameCheck *bool `json:"enforceCertificateNameCheck,omitempty"`

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`

	// The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across
	// all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services
	// require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string `json:"originHostHeader,omitempty"`

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5
	Priority *int32 `json:"priority,omitempty"`

	// The properties of the private link resource for private origin.
	SharedPrivateLinkResource *SharedPrivateLinkResourceProperties `json:"sharedPrivateLinkResource,omitempty"`

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`

	// READ-ONLY; The name of the origin group which contains this origin.
	OriginGroupName *string `json:"originGroupName,omitempty" azure:"ro"`
}

// AFDOriginsClientBeginCreateOptions contains the optional parameters for the AFDOriginsClient.BeginCreate method.
type AFDOriginsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDOriginsClientBeginDeleteOptions contains the optional parameters for the AFDOriginsClient.BeginDelete method.
type AFDOriginsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDOriginsClientBeginUpdateOptions contains the optional parameters for the AFDOriginsClient.BeginUpdate method.
type AFDOriginsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AFDOriginsClientGetOptions contains the optional parameters for the AFDOriginsClient.Get method.
type AFDOriginsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AFDOriginsClientListByOriginGroupOptions contains the optional parameters for the AFDOriginsClient.ListByOriginGroup method.
type AFDOriginsClientListByOriginGroupOptions struct {
	// placeholder for future optional parameters
}

// AFDProfilesClientCheckHostNameAvailabilityOptions contains the optional parameters for the AFDProfilesClient.CheckHostNameAvailability
// method.
type AFDProfilesClientCheckHostNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// AFDProfilesClientListResourceUsageOptions contains the optional parameters for the AFDProfilesClient.ListResourceUsage
// method.
type AFDProfilesClientListResourceUsageOptions struct {
	// placeholder for future optional parameters
}

// AFDStateProperties - The tracking states for afd resources.
type AFDStateProperties struct {
	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ActivatedResourceReference - Reference to another resource along with its state.
type ActivatedResourceReference struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Whether the resource is active or inactive
	IsActive *bool `json:"isActive,omitempty" azure:"ro"`
}

// AfdErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type AfdErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// AfdPurgeParameters - Parameters required for content purge.
type AfdPurgeParameters struct {
	// REQUIRED; The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths []*string `json:"contentPaths,omitempty"`

	// List of domains.
	Domains []*string `json:"domains,omitempty"`
}

// AfdRouteCacheConfiguration - Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration
// object.
type AfdRouteCacheConfiguration struct {
	// compression settings.
	CompressionSettings *CompressionSettings `json:"compressionSettings,omitempty"`

	// query parameters to include or exclude (comma separated).
	QueryParameters *string `json:"queryParameters,omitempty"`

	// Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore
	// specific query strings, cache every request with a unique URL, or cache specific
	// query strings.
	QueryStringCachingBehavior *AfdQueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
}

// AzureFirstPartyManagedCertificate - Azure FirstParty Managed Certificate provided by other first party resource providers
// to enable HTTPS.
type AzureFirstPartyManagedCertificate struct {
	// The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty" azure:"ro"`
}

// AzureFirstPartyManagedCertificateParameters - Azure FirstParty Managed Certificate provided by other first party resource
// providers to enable HTTPS.
type AzureFirstPartyManagedCertificateParameters struct {
	// REQUIRED; The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`
}

// GetSecretParameters implements the SecretParametersClassification interface for type AzureFirstPartyManagedCertificateParameters.
func (a *AzureFirstPartyManagedCertificateParameters) GetSecretParameters() *SecretParameters {
	return &SecretParameters{
		Type: a.Type,
	}
}

// CacheConfiguration - Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration
// object.
type CacheConfiguration struct {
	// Caching behavior for the requests
	CacheBehavior *RuleCacheBehavior `json:"cacheBehavior,omitempty"`

	// The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
	CacheDuration *string `json:"cacheDuration,omitempty"`

	// Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user
	// requests for a compressed version. Content won't be compressed on
	// AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *RuleIsCompressionEnabled `json:"isCompressionEnabled,omitempty"`

	// query parameters to include or exclude (comma separated).
	QueryParameters *string `json:"queryParameters,omitempty"`

	// Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore
	// specific query strings, cache every request with a unique URL, or cache specific
	// query strings.
	QueryStringCachingBehavior *RuleQueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
}

// CacheExpirationActionParameters - Defines the parameters for the cache expiration action.
type CacheExpirationActionParameters struct {
	// REQUIRED; Caching behavior for the requests
	CacheBehavior *CacheBehavior `json:"cacheBehavior,omitempty"`

	// REQUIRED; The level at which the content needs to be cached.
	CacheType *CacheType `json:"cacheType,omitempty"`

	// REQUIRED
	TypeName *CacheExpirationActionParametersTypeName `json:"typeName,omitempty"`

	// The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
	CacheDuration *string `json:"cacheDuration,omitempty"`
}

// CacheKeyQueryStringActionParameters - Defines the parameters for the cache-key query string action.
type CacheKeyQueryStringActionParameters struct {
	// REQUIRED; Caching behavior for the requests
	QueryStringBehavior *QueryStringBehavior `json:"queryStringBehavior,omitempty"`

	// REQUIRED
	TypeName *CacheKeyQueryStringActionParametersTypeName `json:"typeName,omitempty"`

	// query parameters to include or exclude (comma separated).
	QueryParameters *string `json:"queryParameters,omitempty"`
}

// Certificate used for https
type Certificate struct {
	// The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty" azure:"ro"`
}

// CertificateSourceParameters - Defines the parameters for using CDN managed certificate for securing custom domain.
type CertificateSourceParameters struct {
	// REQUIRED; Type of certificate used
	CertificateType *CertificateType `json:"certificateType,omitempty"`

	// REQUIRED
	TypeName *CdnCertificateSourceParametersTypeName `json:"typeName,omitempty"`
}

// CheckEndpointNameAvailabilityInput - Input of CheckNameAvailability API.
type CheckEndpointNameAvailabilityInput struct {
	// REQUIRED; The resource name to validate.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of the resource whose name is to be validated.
	Type *ResourceType `json:"type,omitempty"`

	// Indicates the endpoint name reuse scope. The default value is TenantReuse.
	AutoGeneratedDomainNameLabelScope *AutoGeneratedDomainNameLabelScope `json:"autoGeneratedDomainNameLabelScope,omitempty"`
}

// CheckEndpointNameAvailabilityOutput - Output of check name availability API.
type CheckEndpointNameAvailabilityOutput struct {
	// READ-ONLY; Returns the available hostname generated based on the AutoGeneratedDomainNameLabelScope when the name is available,
	// otherwise it returns empty string
	AvailableHostname *string `json:"availableHostname,omitempty" azure:"ro"`

	// READ-ONLY; The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The reason why the name is not available.
	Reason *string `json:"reason,omitempty" azure:"ro"`
}

// CheckHostNameAvailabilityInput - Input of CheckHostNameAvailability API.
type CheckHostNameAvailabilityInput struct {
	// REQUIRED; The host name to validate.
	HostName *string `json:"hostName,omitempty"`
}

// CheckNameAvailabilityInput - Input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// REQUIRED; The resource name to validate.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of the resource whose name is to be validated.
	Type *ResourceType `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput - Output of check name availability API.
type CheckNameAvailabilityOutput struct {
	// READ-ONLY; The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The reason why the name is not available.
	Reason *string `json:"reason,omitempty" azure:"ro"`
}

// CidrIPAddress - CIDR Ip address
type CidrIPAddress struct {
	// Ip address itself.
	BaseIPAddress *string `json:"baseIpAddress,omitempty"`

	// The length of the prefix of the ip address.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
}

// ClientPortMatchConditionParameters - Defines the parameters for ClientPort match conditions
type ClientPortMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *ClientPortOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *ClientPortMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

type Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems struct {
	DateTime *time.Time `json:"dateTime,omitempty"`
	Value    *float32   `json:"value,omitempty"`
}

type Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems struct {
	DateTime *time.Time `json:"dateTime,omitempty"`
	Value    *float32   `json:"value,omitempty"`
}

type ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems struct {
	Metric     *string  `json:"metric,omitempty"`
	Percentage *float64 `json:"percentage,omitempty"`
	Value      *int64   `json:"value,omitempty"`
}

// CompressionSettings - settings for compression.
type CompressionSettings struct {
	// List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress []*string `json:"contentTypesToCompress,omitempty"`

	// Indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled,
	// content will be served as compressed if user requests for a compressed version.
	// Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
}

// ContinentsResponse - Continents Response
type ContinentsResponse struct {
	Continents       []*ContinentsResponseContinentsItem       `json:"continents,omitempty"`
	CountryOrRegions []*ContinentsResponseCountryOrRegionsItem `json:"countryOrRegions,omitempty"`
}

type ContinentsResponseContinentsItem struct {
	ID *string `json:"id,omitempty"`
}

type ContinentsResponseCountryOrRegionsItem struct {
	ContinentID *string `json:"continentId,omitempty"`
	ID          *string `json:"id,omitempty"`
}

// CookiesMatchConditionParameters - Defines the parameters for Cookies match conditions
type CookiesMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *CookiesOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *CookiesMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// Name of Cookies to be matched
	Selector *string `json:"selector,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// CustomDomain - Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
// e.g. www.contoso.com.
type CustomDomain struct {
	// The JSON object that contains the properties of the custom domain to create.
	Properties *CustomDomainProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomDomainHTTPSParametersClassification provides polymorphic access to related types.
// Call the interface's GetCustomDomainHTTPSParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CustomDomainHTTPSParameters, *ManagedHTTPSParameters, *UserManagedHTTPSParameters
type CustomDomainHTTPSParametersClassification interface {
	// GetCustomDomainHTTPSParameters returns the CustomDomainHTTPSParameters content of the underlying type.
	GetCustomDomainHTTPSParameters() *CustomDomainHTTPSParameters
}

// CustomDomainHTTPSParameters - The JSON object that contains the properties to secure a custom domain.
type CustomDomainHTTPSParameters struct {
	// REQUIRED; Defines the source of the SSL certificate.
	CertificateSource *CertificateSource `json:"certificateSource,omitempty"`

	// REQUIRED; Defines the TLS extension protocol that is used for secure delivery.
	ProtocolType *ProtocolType `json:"protocolType,omitempty"`

	// TLS protocol version that will be used for Https
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
}

// GetCustomDomainHTTPSParameters implements the CustomDomainHTTPSParametersClassification interface for type CustomDomainHTTPSParameters.
func (c *CustomDomainHTTPSParameters) GetCustomDomainHTTPSParameters() *CustomDomainHTTPSParameters {
	return c
}

// CustomDomainListResult - Result of the request to list custom domains. It contains a list of custom domain objects and
// a URL link to get the next set of results.
type CustomDomainListResult struct {
	// URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of CDN CustomDomains within an endpoint.
	Value []*CustomDomain `json:"value,omitempty" azure:"ro"`
}

// CustomDomainParameters - The customDomain JSON object required for custom domain creation or update.
type CustomDomainParameters struct {
	// The JSON object that contains the properties of the custom domain to create.
	Properties *CustomDomainPropertiesParameters `json:"properties,omitempty"`
}

// CustomDomainProperties - The JSON object that contains the properties of the custom domain to create.
type CustomDomainProperties struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`

	// Certificate parameters for securing custom HTTPS
	CustomHTTPSParameters CustomDomainHTTPSParametersClassification `json:"customHttpsParameters,omitempty"`

	// Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP
	// license number of a custom domain is required to deliver content in China.
	ValidationData *string `json:"validationData,omitempty"`

	// READ-ONLY; Provisioning status of the custom domain.
	CustomHTTPSProvisioningState *CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
	CustomHTTPSProvisioningSubstate *CustomHTTPSProvisioningSubstate `json:"customHttpsProvisioningSubstate,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status of Custom Https of the custom domain.
	ProvisioningState *CustomHTTPSProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the custom domain.
	ResourceState *CustomDomainResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// CustomDomainPropertiesParameters - The JSON object that contains the properties of the custom domain to create.
type CustomDomainPropertiesParameters struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// CustomDomainsClientBeginCreateOptions contains the optional parameters for the CustomDomainsClient.BeginCreate method.
type CustomDomainsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomDomainsClientBeginDeleteOptions contains the optional parameters for the CustomDomainsClient.BeginDelete method.
type CustomDomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomDomainsClientDisableCustomHTTPSOptions contains the optional parameters for the CustomDomainsClient.DisableCustomHTTPS
// method.
type CustomDomainsClientDisableCustomHTTPSOptions struct {
	// placeholder for future optional parameters
}

// CustomDomainsClientEnableCustomHTTPSOptions contains the optional parameters for the CustomDomainsClient.EnableCustomHTTPS
// method.
type CustomDomainsClientEnableCustomHTTPSOptions struct {
	// The configuration specifying how to enable HTTPS for the custom domain - using CDN managed certificate or user's own certificate.
	// If not specified, enabling ssl uses CDN managed certificate by
	// default.
	CustomDomainHTTPSParameters CustomDomainHTTPSParametersClassification
}

// CustomDomainsClientGetOptions contains the optional parameters for the CustomDomainsClient.Get method.
type CustomDomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomDomainsClientListByEndpointOptions contains the optional parameters for the CustomDomainsClient.ListByEndpoint method.
type CustomDomainsClientListByEndpointOptions struct {
	// placeholder for future optional parameters
}

// CustomRule - Defines the common attributes for a custom rule that can be included in a waf policy
type CustomRule struct {
	// REQUIRED; Describes what action to be applied when rule matches
	Action *ActionType `json:"action,omitempty"`

	// REQUIRED; List of match conditions.
	MatchConditions []*MatchCondition `json:"matchConditions,omitempty"`

	// REQUIRED; Defines the name of the custom rule
	Name *string `json:"name,omitempty"`

	// REQUIRED; Defines in what order this rule be evaluated in the overall list of custom rules
	Priority *int32 `json:"priority,omitempty"`

	// Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
	EnabledState *CustomRuleEnabledState `json:"enabledState,omitempty"`
}

// CustomRuleList - Defines contents of custom rules
type CustomRuleList struct {
	// List of rules
	Rules []*CustomRule `json:"rules,omitempty"`
}

// CustomerCertificate - Customer Certificate used for https
type CustomerCertificate struct {
	// Resource reference to the Azure Key Vault certificate. Expected to be in format of
	// /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference `json:"secretSource,omitempty"`

	// Certificate version.
	SecretVersion *string `json:"secretVersion,omitempty"`

	// The list of SANs.
	SubjectAlternativeNames []*string `json:"subjectAlternativeNames,omitempty"`

	// The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`

	// Whether to use the latest version for the certificate
	UseLatestVersion *bool `json:"useLatestVersion,omitempty"`

	// READ-ONLY; Certificate issuing authority.
	CertificateAuthority *string `json:"certificateAuthority,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty" azure:"ro"`

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// CustomerCertificateParameters - Customer Certificate used for https
type CustomerCertificateParameters struct {
	// REQUIRED; Resource reference to the Azure Key Vault certificate. Expected to be in format of
	// /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference `json:"secretSource,omitempty"`

	// REQUIRED; The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`

	// Version of the secret to be used
	SecretVersion *string `json:"secretVersion,omitempty"`

	// The list of SANs.
	SubjectAlternativeNames []*string `json:"subjectAlternativeNames,omitempty"`

	// Whether to use the latest version for the certificate
	UseLatestVersion *bool `json:"useLatestVersion,omitempty"`

	// READ-ONLY; Certificate issuing authority.
	CertificateAuthority *string `json:"certificateAuthority,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty" azure:"ro"`

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// GetSecretParameters implements the SecretParametersClassification interface for type CustomerCertificateParameters.
func (c *CustomerCertificateParameters) GetSecretParameters() *SecretParameters {
	return &SecretParameters{
		Type: c.Type,
	}
}

// DeepCreatedOrigin - The main origin of CDN content which is added when creating a CDN endpoint.
type DeepCreatedOrigin struct {
	// REQUIRED; Origin name which must be unique within the endpoint.
	Name *string `json:"name,omitempty"`

	// Properties of the origin created on the CDN endpoint.
	Properties *DeepCreatedOriginProperties `json:"properties,omitempty"`
}

// DeepCreatedOriginGroup - The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent
// to the origins within the origin group based on origin health.
type DeepCreatedOriginGroup struct {
	// REQUIRED; Origin group name which must be unique within the endpoint.
	Name *string `json:"name,omitempty"`

	// Properties of the origin group created on the CDN endpoint.
	Properties *DeepCreatedOriginGroupProperties `json:"properties,omitempty"`
}

// DeepCreatedOriginGroupProperties - Properties of the origin group created on the CDN endpoint.
type DeepCreatedOriginGroupProperties struct {
	// REQUIRED; The source of the content being delivered via CDN within given origin group.
	Origins []*ResourceReference `json:"origins,omitempty"`

	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`

	// The JSON object that contains the properties to determine origin health using real requests/responses.This property is
	// currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters `json:"responseBasedOriginErrorDetectionSettings,omitempty"`

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`
}

// DeepCreatedOriginProperties - Properties of the origin created on the CDN endpoint.
type DeepCreatedOriginProperties struct {
	// REQUIRED; The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across
	// all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`

	// Origin is enabled for load balancing or not. By default, origin is always enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services
	// require this host header value to match the origin hostname by default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5.
	Priority *int32 `json:"priority,omitempty"`

	// The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string `json:"privateLinkAlias,omitempty"`

	// A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string `json:"privateLinkApprovalMessage,omitempty"`

	// The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`

	// The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`

	// READ-ONLY; The approval status for the connection to the Private Link
	PrivateEndpointStatus *PrivateEndpointStatus `json:"privateEndpointStatus,omitempty" azure:"ro"`
}

// DeliveryRule - A rule that specifies a set of actions and conditions
type DeliveryRule struct {
	// REQUIRED; A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions []DeliveryRuleActionAutoGeneratedClassification `json:"actions,omitempty"`

	// REQUIRED; The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser
	// order will be applied before a rule with a greater order. Rule with order 0 is a special
	// rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32 `json:"order,omitempty"`

	// A list of conditions that must be matched for the actions to be executed
	Conditions []DeliveryRuleConditionClassification `json:"conditions,omitempty"`

	// Name of the rule
	Name *string `json:"name,omitempty"`
}

// DeliveryRuleActionAutoGeneratedClassification provides polymorphic access to related types.
// Call the interface's GetDeliveryRuleActionAutoGenerated() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DeliveryRuleActionAutoGenerated, *DeliveryRuleCacheExpirationAction, *DeliveryRuleCacheKeyQueryStringAction, *DeliveryRuleRequestHeaderAction,
// - *DeliveryRuleResponseHeaderAction, *DeliveryRuleRouteConfigurationOverrideAction, *OriginGroupOverrideAction, *URLRedirectAction,
// - *URLRewriteAction, *URLSigningAction
type DeliveryRuleActionAutoGeneratedClassification interface {
	// GetDeliveryRuleActionAutoGenerated returns the DeliveryRuleActionAutoGenerated content of the underlying type.
	GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated
}

// DeliveryRuleActionAutoGenerated - An action for the delivery rule.
type DeliveryRuleActionAutoGenerated struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleActionAutoGenerated.
func (d *DeliveryRuleActionAutoGenerated) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return d
}

// DeliveryRuleCacheExpirationAction - Defines the cache expiration action for the delivery rule.
type DeliveryRuleCacheExpirationAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *CacheExpirationActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleCacheExpirationAction.
func (d *DeliveryRuleCacheExpirationAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleCacheKeyQueryStringAction - Defines the cache-key query string action for the delivery rule.
type DeliveryRuleCacheKeyQueryStringAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *CacheKeyQueryStringActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleCacheKeyQueryStringAction.
func (d *DeliveryRuleCacheKeyQueryStringAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleClientPortCondition - Defines the ClientPort condition for the delivery rule.
type DeliveryRuleClientPortCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *ClientPortMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleClientPortCondition.
func (d *DeliveryRuleClientPortCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleConditionClassification provides polymorphic access to related types.
// Call the interface's GetDeliveryRuleCondition() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DeliveryRuleClientPortCondition, *DeliveryRuleCondition, *DeliveryRuleCookiesCondition, *DeliveryRuleHTTPVersionCondition,
// - *DeliveryRuleHostNameCondition, *DeliveryRuleIsDeviceCondition, *DeliveryRulePostArgsCondition, *DeliveryRuleQueryStringCondition,
// - *DeliveryRuleRemoteAddressCondition, *DeliveryRuleRequestBodyCondition, *DeliveryRuleRequestHeaderCondition, *DeliveryRuleRequestMethodCondition,
// - *DeliveryRuleRequestSchemeCondition, *DeliveryRuleRequestURICondition, *DeliveryRuleSSLProtocolCondition, *DeliveryRuleServerPortCondition,
// - *DeliveryRuleSocketAddrCondition, *DeliveryRuleURLFileExtensionCondition, *DeliveryRuleURLFileNameCondition, *DeliveryRuleURLPathCondition
type DeliveryRuleConditionClassification interface {
	// GetDeliveryRuleCondition returns the DeliveryRuleCondition content of the underlying type.
	GetDeliveryRuleCondition() *DeliveryRuleCondition
}

// DeliveryRuleCondition - A condition for the delivery rule.
type DeliveryRuleCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleCondition.
func (d *DeliveryRuleCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition { return d }

// DeliveryRuleCookiesCondition - Defines the Cookies condition for the delivery rule.
type DeliveryRuleCookiesCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *CookiesMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleCookiesCondition.
func (d *DeliveryRuleCookiesCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleHTTPVersionCondition - Defines the HttpVersion condition for the delivery rule.
type DeliveryRuleHTTPVersionCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *HTTPVersionMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleHTTPVersionCondition.
func (d *DeliveryRuleHTTPVersionCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleHostNameCondition - Defines the HostName condition for the delivery rule.
type DeliveryRuleHostNameCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *HostNameMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleHostNameCondition.
func (d *DeliveryRuleHostNameCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleIsDeviceCondition - Defines the IsDevice condition for the delivery rule.
type DeliveryRuleIsDeviceCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *IsDeviceMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleIsDeviceCondition.
func (d *DeliveryRuleIsDeviceCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRulePostArgsCondition - Defines the PostArgs condition for the delivery rule.
type DeliveryRulePostArgsCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *PostArgsMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRulePostArgsCondition.
func (d *DeliveryRulePostArgsCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleQueryStringCondition - Defines the QueryString condition for the delivery rule.
type DeliveryRuleQueryStringCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *QueryStringMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleQueryStringCondition.
func (d *DeliveryRuleQueryStringCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRemoteAddressCondition - Defines the RemoteAddress condition for the delivery rule.
type DeliveryRuleRemoteAddressCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RemoteAddressMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRemoteAddressCondition.
func (d *DeliveryRuleRemoteAddressCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestBodyCondition - Defines the RequestBody condition for the delivery rule.
type DeliveryRuleRequestBodyCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestBodyMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestBodyCondition.
func (d *DeliveryRuleRequestBodyCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestHeaderAction - Defines the request header action for the delivery rule.
type DeliveryRuleRequestHeaderAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *HeaderActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleRequestHeaderAction.
func (d *DeliveryRuleRequestHeaderAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleRequestHeaderCondition - Defines the RequestHeader condition for the delivery rule.
type DeliveryRuleRequestHeaderCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestHeaderMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestHeaderCondition.
func (d *DeliveryRuleRequestHeaderCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestMethodCondition - Defines the RequestMethod condition for the delivery rule.
type DeliveryRuleRequestMethodCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestMethodMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestMethodCondition.
func (d *DeliveryRuleRequestMethodCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestSchemeCondition - Defines the RequestScheme condition for the delivery rule.
type DeliveryRuleRequestSchemeCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestSchemeMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestSchemeCondition.
func (d *DeliveryRuleRequestSchemeCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestURICondition - Defines the RequestUri condition for the delivery rule.
type DeliveryRuleRequestURICondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestURIMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestURICondition.
func (d *DeliveryRuleRequestURICondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleResponseHeaderAction - Defines the response header action for the delivery rule.
type DeliveryRuleResponseHeaderAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *HeaderActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleResponseHeaderAction.
func (d *DeliveryRuleResponseHeaderAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleRouteConfigurationOverrideAction - Defines the route configuration override action for the delivery rule. Only
// applicable to Frontdoor Standard/Premium Profiles.
type DeliveryRuleRouteConfigurationOverrideAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *RouteConfigurationOverrideActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleRouteConfigurationOverrideAction.
func (d *DeliveryRuleRouteConfigurationOverrideAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleSSLProtocolCondition - Defines the SslProtocol condition for the delivery rule.
type DeliveryRuleSSLProtocolCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *SSLProtocolMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleSSLProtocolCondition.
func (d *DeliveryRuleSSLProtocolCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleServerPortCondition - Defines the ServerPort condition for the delivery rule.
type DeliveryRuleServerPortCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *ServerPortMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleServerPortCondition.
func (d *DeliveryRuleServerPortCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleSocketAddrCondition - Defines the SocketAddress condition for the delivery rule.
type DeliveryRuleSocketAddrCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *SocketAddrMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleSocketAddrCondition.
func (d *DeliveryRuleSocketAddrCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleURLFileExtensionCondition - Defines the UrlFileExtension condition for the delivery rule.
type DeliveryRuleURLFileExtensionCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *URLFileExtensionMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleURLFileExtensionCondition.
func (d *DeliveryRuleURLFileExtensionCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleURLFileNameCondition - Defines the UrlFileName condition for the delivery rule.
type DeliveryRuleURLFileNameCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *URLFileNameMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleURLFileNameCondition.
func (d *DeliveryRuleURLFileNameCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleURLPathCondition - Defines the UrlPath condition for the delivery rule.
type DeliveryRuleURLPathCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the condition.
	Parameters *URLPathMatchConditionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleURLPathCondition.
func (d *DeliveryRuleURLPathCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DimensionProperties - Type of operation: get, read, delete, etc.
type DimensionProperties struct {
	// Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Internal name of dimension.
	InternalName *string `json:"internalName,omitempty"`

	// Name of dimension.
	Name *string `json:"name,omitempty"`
}

// DomainValidationProperties - The JSON object that contains the properties to validate a domain.
type DomainValidationProperties struct {
	// READ-ONLY; The date time that the token expires
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Challenge used for DNS TXT record or file based validation
	ValidationToken *string `json:"validationToken,omitempty" azure:"ro"`
}

// EdgeNode - Edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.
type EdgeNode struct {
	// The JSON object that contains the properties required to create an edgenode.
	Properties *EdgeNodeProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EdgeNodeProperties - The JSON object that contains the properties required to create an edgenode.
type EdgeNodeProperties struct {
	// REQUIRED; List of ip address groups.
	IPAddressGroups []*IPAddressGroup `json:"ipAddressGroups,omitempty"`
}

// EdgeNodesClientListOptions contains the optional parameters for the EdgeNodesClient.List method.
type EdgeNodesClientListOptions struct {
	// placeholder for future optional parameters
}

// EdgenodeResult - Result of the request to list CDN edgenodes. It contains a list of ip address group and a URL link to
// get the next set of results.
type EdgenodeResult struct {
	// URL to get the next set of edgenode list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Edge node of CDN service.
	Value []*EdgeNode `json:"value,omitempty" azure:"ro"`
}

// Endpoint - CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol,
// content caching and delivery behavior. The CDN endpoint uses the URL format
// .azureedge.net.
type Endpoint struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// The JSON object that contains the properties required to create an endpoint.
	Properties *EndpointProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EndpointListResult - Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to
// get the next set of results.
type EndpointListResult struct {
	// URL to get the next set of endpoint objects if there is any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of CDN endpoints within a profile
	Value []*Endpoint `json:"value,omitempty" azure:"ro"`
}

// EndpointProperties - The JSON object that contains the properties required to create an endpoint.
type EndpointProperties struct {
	// REQUIRED; The source of the content being delivered via CDN.
	Origins []*DeepCreatedOrigin `json:"origins,omitempty"`

	// List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress []*string `json:"contentTypesToCompress,omitempty"`

	// A reference to the origin group.
	DefaultOriginGroup *ResourceReference `json:"defaultOriginGroup,omitempty"`

	// A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy `json:"deliveryPolicy,omitempty"`

	// List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified
	// path or content, e.g. block APAC for path /pictures/
	GeoFilters []*GeoFilter `json:"geoFilters,omitempty"`

	// Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will
	// be served as compressed if user requests for a compressed version. Content
	// won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`

	// Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
	// must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`

	// Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
	// must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`

	// Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this
	// information, CDN can apply scenario driven optimization.
	OptimizationType *OptimizationType `json:"optimizationType,omitempty"`

	// The origin groups comprising of origins that are used for load balancing the traffic based on availability.
	OriginGroups []*DeepCreatedOriginGroup `json:"originGroups,omitempty"`

	// The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses
	// single origin and can be overridden by the same property specified at origin.If
	// you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and
	// Cloud Services require this host header value to match the origin hostname by
	// default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`

	// A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`

	// Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal
	// routes for the CDN. This is relative to the origin path. This property is only
	// relevant when using a single origin.
	ProbePath *string `json:"probePath,omitempty"`

	// Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching
	// to prevent requests that contain query strings from being cached, or cache
	// every request with a unique URL.
	QueryStringCachingBehavior *QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`

	// List of keys used to validate the signed URL hashes.
	URLSigningKeys []*URLSigningKey `json:"urlSigningKeys,omitempty"`

	// Defines the Web Application Firewall policy for the endpoint (if applicable)
	WebApplicationFirewallPolicyLink *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`

	// READ-ONLY; The custom domains under the endpoint.
	CustomDomains []*CustomDomain `json:"customDomains,omitempty" azure:"ro"`

	// READ-ONLY; The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
	HostName *string `json:"hostName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status of the endpoint.
	ProvisioningState *EndpointProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the endpoint.
	ResourceState *EndpointResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// EndpointPropertiesUpdateParameters - The JSON object containing endpoint update parameters.
type EndpointPropertiesUpdateParameters struct {
	// List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress []*string `json:"contentTypesToCompress,omitempty"`

	// A reference to the origin group.
	DefaultOriginGroup *ResourceReference `json:"defaultOriginGroup,omitempty"`

	// A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy `json:"deliveryPolicy,omitempty"`

	// List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified
	// path or content, e.g. block APAC for path /pictures/
	GeoFilters []*GeoFilter `json:"geoFilters,omitempty"`

	// Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will
	// be served as compressed if user requests for a compressed version. Content
	// won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`

	// Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
	// must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`

	// Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
	// must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`

	// Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this
	// information, CDN can apply scenario driven optimization.
	OptimizationType *OptimizationType `json:"optimizationType,omitempty"`

	// The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses
	// single origin and can be overridden by the same property specified at origin.If
	// you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and
	// Cloud Services require this host header value to match the origin hostname by
	// default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`

	// A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`

	// Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal
	// routes for the CDN. This is relative to the origin path. This property is only
	// relevant when using a single origin.
	ProbePath *string `json:"probePath,omitempty"`

	// Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching
	// to prevent requests that contain query strings from being cached, or cache
	// every request with a unique URL.
	QueryStringCachingBehavior *QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`

	// List of keys used to validate the signed URL hashes.
	URLSigningKeys []*URLSigningKey `json:"urlSigningKeys,omitempty"`

	// Defines the Web Application Firewall policy for the endpoint (if applicable)
	WebApplicationFirewallPolicyLink *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// EndpointPropertiesUpdateParametersDeliveryPolicy - A policy that specifies the delivery rules to be used for an endpoint.
type EndpointPropertiesUpdateParametersDeliveryPolicy struct {
	// REQUIRED; A list of the delivery rules.
	Rules []*DeliveryRule `json:"rules,omitempty"`

	// User-friendly description of the policy.
	Description *string `json:"description,omitempty"`
}

// EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for the
// endpoint (if applicable)
type EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// EndpointUpdateParameters - Properties required to create or update an endpoint.
type EndpointUpdateParameters struct {
	// The JSON object containing endpoint update parameters.
	Properties *EndpointPropertiesUpdateParameters `json:"properties,omitempty"`

	// Endpoint tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// EndpointsClientBeginCreateOptions contains the optional parameters for the EndpointsClient.BeginCreate method.
type EndpointsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EndpointsClientBeginDeleteOptions contains the optional parameters for the EndpointsClient.BeginDelete method.
type EndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EndpointsClientBeginLoadContentOptions contains the optional parameters for the EndpointsClient.BeginLoadContent method.
type EndpointsClientBeginLoadContentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EndpointsClientBeginPurgeContentOptions contains the optional parameters for the EndpointsClient.BeginPurgeContent method.
type EndpointsClientBeginPurgeContentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EndpointsClientBeginStartOptions contains the optional parameters for the EndpointsClient.BeginStart method.
type EndpointsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EndpointsClientBeginStopOptions contains the optional parameters for the EndpointsClient.BeginStop method.
type EndpointsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EndpointsClientBeginUpdateOptions contains the optional parameters for the EndpointsClient.BeginUpdate method.
type EndpointsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EndpointsClientGetOptions contains the optional parameters for the EndpointsClient.Get method.
type EndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientListByProfileOptions contains the optional parameters for the EndpointsClient.ListByProfile method.
type EndpointsClientListByProfileOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientListResourceUsageOptions contains the optional parameters for the EndpointsClient.ListResourceUsage method.
type EndpointsClientListResourceUsageOptions struct {
	// placeholder for future optional parameters
}

// EndpointsClientValidateCustomDomainOptions contains the optional parameters for the EndpointsClient.ValidateCustomDomain
// method.
type EndpointsClientValidateCustomDomainOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Error response indicates Azure Front Door Standard or Azure Front Door Premium or CDN service is not able
// to process the incoming request. The reason is provided in the error message.
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GeoFilter - Rules defining user's geo access within a CDN endpoint.
type GeoFilter struct {
	// REQUIRED; Action of the geo filter, i.e. allow or block access.
	Action *GeoFilterActions `json:"action,omitempty"`

	// REQUIRED; Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
	CountryCodes []*string `json:"countryCodes,omitempty"`

	// REQUIRED; Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
	RelativePath *string `json:"relativePath,omitempty"`
}

// HTTPErrorRangeParameters - The JSON object that represents the range for http status codes
type HTTPErrorRangeParameters struct {
	// The inclusive start of the http status code range.
	Begin *int32 `json:"begin,omitempty"`

	// The inclusive end of the http status code range.
	End *int32 `json:"end,omitempty"`
}

// HTTPVersionMatchConditionParameters - Defines the parameters for HttpVersion match conditions
type HTTPVersionMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *HTTPVersionOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *HTTPVersionMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// HeaderActionParameters - Defines the parameters for the request header action.
type HeaderActionParameters struct {
	// REQUIRED; Action to perform
	HeaderAction *HeaderAction `json:"headerAction,omitempty"`

	// REQUIRED; Name of the header to modify
	HeaderName *string `json:"headerName,omitempty"`

	// REQUIRED
	TypeName *HeaderActionParametersTypeName `json:"typeName,omitempty"`

	// Value for the specified action
	Value *string `json:"value,omitempty"`
}

// HealthProbeParameters - The JSON object that contains the properties to send health probes to origin.
type HealthProbeParameters struct {
	// The number of seconds between health probes.Default is 240sec.
	ProbeIntervalInSeconds *int32 `json:"probeIntervalInSeconds,omitempty"`

	// The path relative to the origin that is used to determine the health of the origin.
	ProbePath *string `json:"probePath,omitempty"`

	// Protocol to use for health probe.
	ProbeProtocol *ProbeProtocol `json:"probeProtocol,omitempty"`

	// The type of health probe request that is made.
	ProbeRequestType *HealthProbeRequestType `json:"probeRequestType,omitempty"`
}

// HostNameMatchConditionParameters - Defines the parameters for HostName match conditions
type HostNameMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *HostNameOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *HostNameMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// IPAddressGroup - CDN Ip address group
type IPAddressGroup struct {
	// The delivery region of the ip address group
	DeliveryRegion *string `json:"deliveryRegion,omitempty"`

	// The list of ip v4 addresses.
	IPv4Addresses []*CidrIPAddress `json:"ipv4Addresses,omitempty"`

	// The list of ip v6 addresses.
	IPv6Addresses []*CidrIPAddress `json:"ipv6Addresses,omitempty"`
}

// IsDeviceMatchConditionParameters - Defines the parameters for IsDevice match conditions
type IsDeviceMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *IsDeviceOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *IsDeviceMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*IsDeviceMatchConditionParametersMatchValuesItem `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// KeyVaultCertificateSourceParameters - Describes the parameters for using a user's KeyVault certificate for securing custom
// domain.
type KeyVaultCertificateSourceParameters struct {
	// REQUIRED; Describes the action that shall be taken when the certificate is removed from Key Vault.
	DeleteRule *DeleteRule `json:"deleteRule,omitempty"`

	// REQUIRED; Resource group of the user's Key Vault containing the SSL certificate
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// REQUIRED; The name of Key Vault Secret (representing the full certificate PFX) in Key Vault.
	SecretName *string `json:"secretName,omitempty"`

	// REQUIRED; Subscription Id of the user's Key Vault containing the SSL certificate
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// REQUIRED
	TypeName *KeyVaultCertificateSourceParametersTypeName `json:"typeName,omitempty"`

	// REQUIRED; Describes the action that shall be taken when the certificate is updated in Key Vault.
	UpdateRule *UpdateRule `json:"updateRule,omitempty"`

	// REQUIRED; The name of the user's Key Vault containing the SSL certificate
	VaultName *string `json:"vaultName,omitempty"`

	// The version(GUID) of Key Vault Secret in Key Vault.
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// KeyVaultSigningKeyParameters - Describes the parameters for using a user's KeyVault for URL Signing Key.
type KeyVaultSigningKeyParameters struct {
	// REQUIRED; Resource group of the user's Key Vault containing the secret
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// REQUIRED; The name of secret in Key Vault.
	SecretName *string `json:"secretName,omitempty"`

	// REQUIRED; The version(GUID) of secret in Key Vault.
	SecretVersion *string `json:"secretVersion,omitempty"`

	// REQUIRED; Subscription Id of the user's Key Vault containing the secret
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// REQUIRED
	TypeName *KeyVaultSigningKeyParametersTypeName `json:"typeName,omitempty"`

	// REQUIRED; The name of the user's Key Vault containing the secret
	VaultName *string `json:"vaultName,omitempty"`
}

// LinkedEndpoint - Defines the ARM Resource ID for the linked endpoints
type LinkedEndpoint struct {
	// ARM Resource ID string.
	ID *string `json:"id,omitempty"`
}

// LoadBalancingSettingsParameters - Round-Robin load balancing settings for a backend pool
type LoadBalancingSettingsParameters struct {
	// The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyInMilliseconds *int32 `json:"additionalLatencyInMilliseconds,omitempty"`

	// The number of samples to consider for load balancing decisions
	SampleSize *int32 `json:"sampleSize,omitempty"`

	// The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32 `json:"successfulSamplesRequired,omitempty"`
}

// LoadParameters - Parameters required for content load.
type LoadParameters struct {
	// REQUIRED; The path to the content to be loaded. Path should be a relative file URL of the origin.
	ContentPaths []*string `json:"contentPaths,omitempty"`
}

// LogAnalyticsClientGetLogAnalyticsLocationsOptions contains the optional parameters for the LogAnalyticsClient.GetLogAnalyticsLocations
// method.
type LogAnalyticsClientGetLogAnalyticsLocationsOptions struct {
	// placeholder for future optional parameters
}

// LogAnalyticsClientGetLogAnalyticsMetricsOptions contains the optional parameters for the LogAnalyticsClient.GetLogAnalyticsMetrics
// method.
type LogAnalyticsClientGetLogAnalyticsMetricsOptions struct {
	Continents       []string
	CountryOrRegions []string
	GroupBy          []LogMetricsGroupBy
}

// LogAnalyticsClientGetLogAnalyticsRankingsOptions contains the optional parameters for the LogAnalyticsClient.GetLogAnalyticsRankings
// method.
type LogAnalyticsClientGetLogAnalyticsRankingsOptions struct {
	CustomDomains []string
}

// LogAnalyticsClientGetLogAnalyticsResourcesOptions contains the optional parameters for the LogAnalyticsClient.GetLogAnalyticsResources
// method.
type LogAnalyticsClientGetLogAnalyticsResourcesOptions struct {
	// placeholder for future optional parameters
}

// LogAnalyticsClientGetWafLogAnalyticsMetricsOptions contains the optional parameters for the LogAnalyticsClient.GetWafLogAnalyticsMetrics
// method.
type LogAnalyticsClientGetWafLogAnalyticsMetricsOptions struct {
	Actions   []WafAction
	GroupBy   []WafRankingGroupBy
	RuleTypes []WafRuleType
}

// LogAnalyticsClientGetWafLogAnalyticsRankingsOptions contains the optional parameters for the LogAnalyticsClient.GetWafLogAnalyticsRankings
// method.
type LogAnalyticsClientGetWafLogAnalyticsRankingsOptions struct {
	Actions   []WafAction
	RuleTypes []WafRuleType
}

// LogSpecification - Log specification of operation.
type LogSpecification struct {
	// Blob duration of specification.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Display name of log specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Pattern to filter based on name
	LogFilterPattern *string `json:"logFilterPattern,omitempty"`

	// Name of log specification.
	Name *string `json:"name,omitempty"`
}

// ManagedCertificate - Managed Certificate used for https
type ManagedCertificate struct {
	// The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty" azure:"ro"`
}

// ManagedCertificateParameters - Managed Certificate used for https
type ManagedCertificateParameters struct {
	// REQUIRED; The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty" azure:"ro"`
}

// GetSecretParameters implements the SecretParametersClassification interface for type ManagedCertificateParameters.
func (m *ManagedCertificateParameters) GetSecretParameters() *SecretParameters {
	return &SecretParameters{
		Type: m.Type,
	}
}

// ManagedHTTPSParameters - Defines the certificate source parameters using CDN managed certificate for enabling SSL.
type ManagedHTTPSParameters struct {
	// REQUIRED; Defines the source of the SSL certificate.
	CertificateSource *CertificateSource `json:"certificateSource,omitempty"`

	// REQUIRED; Defines the certificate source parameters using CDN managed certificate for enabling SSL.
	CertificateSourceParameters *CertificateSourceParameters `json:"certificateSourceParameters,omitempty"`

	// REQUIRED; Defines the TLS extension protocol that is used for secure delivery.
	ProtocolType *ProtocolType `json:"protocolType,omitempty"`

	// TLS protocol version that will be used for Https
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
}

// GetCustomDomainHTTPSParameters implements the CustomDomainHTTPSParametersClassification interface for type ManagedHTTPSParameters.
func (m *ManagedHTTPSParameters) GetCustomDomainHTTPSParameters() *CustomDomainHTTPSParameters {
	return &CustomDomainHTTPSParameters{
		CertificateSource: m.CertificateSource,
		ProtocolType:      m.ProtocolType,
		MinimumTLSVersion: m.MinimumTLSVersion,
	}
}

// ManagedRuleDefinition - Describes a managed rule definition.
type ManagedRuleDefinition struct {
	// READ-ONLY; Describes the functionality of the managed rule.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty" azure:"ro"`
}

// ManagedRuleGroupDefinition - Describes a managed rule group.
type ManagedRuleGroupDefinition struct {
	// READ-ONLY; Description of the managed rule group.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Name of the managed rule group.
	RuleGroupName *string `json:"ruleGroupName,omitempty" azure:"ro"`

	// READ-ONLY; List of rules within the managed rule group.
	Rules []*ManagedRuleDefinition `json:"rules,omitempty" azure:"ro"`
}

// ManagedRuleGroupOverride - Defines a managed rule group override setting.
type ManagedRuleGroupOverride struct {
	// REQUIRED; Describes the managed rule group within the rule set to override
	RuleGroupName *string `json:"ruleGroupName,omitempty"`

	// List of rules that will be disabled. If none specified, all rules in the group will be disabled.
	Rules []*ManagedRuleOverride `json:"rules,omitempty"`
}

// ManagedRuleOverride - Defines a managed rule group override setting.
type ManagedRuleOverride struct {
	// REQUIRED; Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`

	// Describes the override action to be applied when rule matches.
	Action *ActionType `json:"action,omitempty"`

	// Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
	EnabledState *ManagedRuleEnabledState `json:"enabledState,omitempty"`
}

// ManagedRuleSet - Defines a managed rule set.
type ManagedRuleSet struct {
	// REQUIRED; Defines the rule set type to use.
	RuleSetType *string `json:"ruleSetType,omitempty"`

	// REQUIRED; Defines the version of the rule set to use.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`

	// Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
	AnomalyScore *int32 `json:"anomalyScore,omitempty"`

	// Defines the rule overrides to apply to the rule set.
	RuleGroupOverrides []*ManagedRuleGroupOverride `json:"ruleGroupOverrides,omitempty"`
}

// ManagedRuleSetDefinition - Describes a managed rule set definition.
type ManagedRuleSetDefinition struct {
	// Describes managed rule set definition properties.
	Properties *ManagedRuleSetDefinitionProperties `json:"properties,omitempty"`

	// The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedRuleSetDefinitionList - List of managed rule set definitions available for use in a policy.
type ManagedRuleSetDefinitionList struct {
	// URL to retrieve next set of managed rule set definitions.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of managed rule set definitions.
	Value []*ManagedRuleSetDefinition `json:"value,omitempty" azure:"ro"`
}

// ManagedRuleSetDefinitionProperties - Properties for a managed rule set definition.
type ManagedRuleSetDefinitionProperties struct {
	// READ-ONLY; Provisioning state of the managed rule set.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Rule groups of the managed rule set.
	RuleGroups []*ManagedRuleGroupDefinition `json:"ruleGroups,omitempty" azure:"ro"`

	// READ-ONLY; Type of the managed rule set.
	RuleSetType *string `json:"ruleSetType,omitempty" azure:"ro"`

	// READ-ONLY; Version of the managed rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty" azure:"ro"`
}

// ManagedRuleSetList - Defines the list of managed rule sets for the policy.
type ManagedRuleSetList struct {
	// List of rule sets.
	ManagedRuleSets []*ManagedRuleSet `json:"managedRuleSets,omitempty"`
}

// ManagedRuleSetsClientListOptions contains the optional parameters for the ManagedRuleSetsClient.List method.
type ManagedRuleSetsClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientCheckEndpointNameAvailabilityOptions contains the optional parameters for the ManagementClient.CheckEndpointNameAvailability
// method.
type ManagementClientCheckEndpointNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientCheckNameAvailabilityOptions contains the optional parameters for the ManagementClient.CheckNameAvailability
// method.
type ManagementClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientCheckNameAvailabilityWithSubscriptionOptions contains the optional parameters for the ManagementClient.CheckNameAvailabilityWithSubscription
// method.
type ManagementClientCheckNameAvailabilityWithSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientValidateProbeOptions contains the optional parameters for the ManagementClient.ValidateProbe method.
type ManagementClientValidateProbeOptions struct {
	// placeholder for future optional parameters
}

// MatchCondition - Define match conditions
type MatchCondition struct {
	// REQUIRED; List of possible match values.
	MatchValue []*string `json:"matchValue,omitempty"`

	// REQUIRED; Match variable to compare against.
	MatchVariable *WafMatchVariable `json:"matchVariable,omitempty"`

	// REQUIRED; Describes operator to be matched
	Operator *Operator `json:"operator,omitempty"`

	// Describes if the result of this condition should be negated.
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
	Selector *string `json:"selector,omitempty"`

	// List of transforms.
	Transforms []*TransformType `json:"transforms,omitempty"`
}

// MetricAvailability - Retention policy of a resource metric.
type MetricAvailability struct {
	BlobDuration *string `json:"blobDuration,omitempty"`
	TimeGrain    *string `json:"timeGrain,omitempty"`
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'.
	AggregationType *string `json:"aggregationType,omitempty"`

	// Retention policies of a resource metric.
	Availabilities []*MetricAvailability `json:"availabilities,omitempty"`

	// The dimensions of metric
	Dimensions []*DimensionProperties `json:"dimensions,omitempty"`

	// Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Property to specify whether to fill gap with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Property to specify metric is internal or not.
	IsInternal *bool `json:"isInternal,omitempty"`

	// Pattern to filter based on name
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`

	// Name of metric specification.
	Name *string `json:"name,omitempty"`

	// The supported time grain types for the metrics.
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
	Unit *string `json:"unit,omitempty"`
}

// MetricsResponse - Metrics Response
type MetricsResponse struct {
	DateTimeBegin *time.Time                   `json:"dateTimeBegin,omitempty"`
	DateTimeEnd   *time.Time                   `json:"dateTimeEnd,omitempty"`
	Granularity   *MetricsResponseGranularity  `json:"granularity,omitempty"`
	Series        []*MetricsResponseSeriesItem `json:"series,omitempty"`
}

type MetricsResponseSeriesItem struct {
	Data   []*Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems `json:"data,omitempty"`
	Groups []*MetricsResponseSeriesPropertiesItemsItem                                        `json:"groups,omitempty"`
	Metric *string                                                                            `json:"metric,omitempty"`
	Unit   *MetricsResponseSeriesItemUnit                                                     `json:"unit,omitempty"`
}

type MetricsResponseSeriesPropertiesItemsItem struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// Operation - CDN REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin of operations.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.Cdn
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsListResult - Result of the request to list CDN operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationsListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of CDN operations supported by the CDN resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// Origin - CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint
// do not have the requested content cached, they attempt to fetch it from one or more of
// the configured origins.
type Origin struct {
	// The JSON object that contains the properties of the origin.
	Properties *OriginProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OriginGroup - Origin group comprising of origins is used for load balancing to origins when the content cannot be served
// from CDN.
type OriginGroup struct {
	// The JSON object that contains the properties of the origin group.
	Properties *OriginGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OriginGroupListResult - Result of the request to list origin groups. It contains a list of origin groups objects and a
// URL link to get the next set of results.
type OriginGroupListResult struct {
	// URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of CDN origin groups within an endpoint
	Value []*OriginGroup `json:"value,omitempty" azure:"ro"`
}

// OriginGroupOverride - Defines the parameters for the origin group override configuration.
type OriginGroupOverride struct {
	// Protocol this rule will use when forwarding traffic to backends.
	ForwardingProtocol *ForwardingProtocol `json:"forwardingProtocol,omitempty"`

	// defines the OriginGroup that would override the DefaultOriginGroup on route.
	OriginGroup *ResourceReference `json:"originGroup,omitempty"`
}

// OriginGroupOverrideAction - Defines the origin group override action for the delivery rule.
type OriginGroupOverrideAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *OriginGroupOverrideActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type OriginGroupOverrideAction.
func (o *OriginGroupOverrideAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: o.Name,
	}
}

// OriginGroupOverrideActionParameters - Defines the parameters for the origin group override action.
type OriginGroupOverrideActionParameters struct {
	// REQUIRED; defines the OriginGroup that would override the DefaultOriginGroup.
	OriginGroup *ResourceReference `json:"originGroup,omitempty"`

	// REQUIRED
	TypeName *OriginGroupOverrideActionParametersTypeName `json:"typeName,omitempty"`
}

// OriginGroupProperties - The JSON object that contains the properties of the origin group.
type OriginGroupProperties struct {
	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`

	// The source of the content being delivered via CDN within given origin group.
	Origins []*ResourceReference `json:"origins,omitempty"`

	// The JSON object that contains the properties to determine origin health using real requests/responses. This property is
	// currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters `json:"responseBasedOriginErrorDetectionSettings,omitempty"`

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`

	// READ-ONLY; Provisioning status of the origin group.
	ProvisioningState *OriginGroupProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the origin group.
	ResourceState *OriginGroupResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// OriginGroupUpdateParameters - Origin group properties needed for origin group creation or update.
type OriginGroupUpdateParameters struct {
	// The JSON object that contains the properties of the origin group.
	Properties *OriginGroupUpdatePropertiesParameters `json:"properties,omitempty"`
}

// OriginGroupUpdatePropertiesParameters - The JSON object that contains the properties of the origin group.
type OriginGroupUpdatePropertiesParameters struct {
	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`

	// The source of the content being delivered via CDN within given origin group.
	Origins []*ResourceReference `json:"origins,omitempty"`

	// The JSON object that contains the properties to determine origin health using real requests/responses. This property is
	// currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters `json:"responseBasedOriginErrorDetectionSettings,omitempty"`

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`
}

// OriginGroupsClientBeginCreateOptions contains the optional parameters for the OriginGroupsClient.BeginCreate method.
type OriginGroupsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OriginGroupsClientBeginDeleteOptions contains the optional parameters for the OriginGroupsClient.BeginDelete method.
type OriginGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OriginGroupsClientBeginUpdateOptions contains the optional parameters for the OriginGroupsClient.BeginUpdate method.
type OriginGroupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OriginGroupsClientGetOptions contains the optional parameters for the OriginGroupsClient.Get method.
type OriginGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OriginGroupsClientListByEndpointOptions contains the optional parameters for the OriginGroupsClient.ListByEndpoint method.
type OriginGroupsClientListByEndpointOptions struct {
	// placeholder for future optional parameters
}

// OriginListResult - Result of the request to list origins. It contains a list of origin objects and a URL link to get the
// next set of results.
type OriginListResult struct {
	// URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of CDN origins within an endpoint
	Value []*Origin `json:"value,omitempty" azure:"ro"`
}

// OriginProperties - The JSON object that contains the properties of the origin.
type OriginProperties struct {
	// Origin is enabled for load balancing or not
	Enabled *bool `json:"enabled,omitempty"`

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`

	// The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across
	// all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services
	// require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string `json:"originHostHeader,omitempty"`

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5
	Priority *int32 `json:"priority,omitempty"`

	// The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string `json:"privateLinkAlias,omitempty"`

	// A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string `json:"privateLinkApprovalMessage,omitempty"`

	// The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`

	// The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`

	// READ-ONLY; The approval status for the connection to the Private Link
	PrivateEndpointStatus *PrivateEndpointStatus `json:"privateEndpointStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status of the origin.
	ProvisioningState *OriginProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the origin.
	ResourceState *OriginResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// OriginUpdateParameters - Origin properties needed for origin update.
type OriginUpdateParameters struct {
	// The JSON object that contains the properties of the origin.
	Properties *OriginUpdatePropertiesParameters `json:"properties,omitempty"`
}

// OriginUpdatePropertiesParameters - The JSON object that contains the properties of the origin.
type OriginUpdatePropertiesParameters struct {
	// Origin is enabled for load balancing or not
	Enabled *bool `json:"enabled,omitempty"`

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`

	// The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across
	// all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services
	// require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string `json:"originHostHeader,omitempty"`

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5
	Priority *int32 `json:"priority,omitempty"`

	// The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string `json:"privateLinkAlias,omitempty"`

	// A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string `json:"privateLinkApprovalMessage,omitempty"`

	// The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`

	// The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`
}

// OriginsClientBeginCreateOptions contains the optional parameters for the OriginsClient.BeginCreate method.
type OriginsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OriginsClientBeginDeleteOptions contains the optional parameters for the OriginsClient.BeginDelete method.
type OriginsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OriginsClientBeginUpdateOptions contains the optional parameters for the OriginsClient.BeginUpdate method.
type OriginsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OriginsClientGetOptions contains the optional parameters for the OriginsClient.Get method.
type OriginsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OriginsClientListByEndpointOptions contains the optional parameters for the OriginsClient.ListByEndpoint method.
type OriginsClientListByEndpointOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the PoliciesClient.BeginCreateOrUpdate method.
type PoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoliciesClientBeginUpdateOptions contains the optional parameters for the PoliciesClient.BeginUpdate method.
type PoliciesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PoliciesClientDeleteOptions contains the optional parameters for the PoliciesClient.Delete method.
type PoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientGetOptions contains the optional parameters for the PoliciesClient.Get method.
type PoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientListOptions contains the optional parameters for the PoliciesClient.List method.
type PoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// PolicySettings - Defines contents of a web application firewall global configuration
type PolicySettings struct {
	// If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
	DefaultCustomBlockResponseBody *string `json:"defaultCustomBlockResponseBody,omitempty"`

	// If the action type is block, this field defines the default customer overridable http response status code.
	DefaultCustomBlockResponseStatusCode *PolicySettingsDefaultCustomBlockResponseStatusCode `json:"defaultCustomBlockResponseStatusCode,omitempty"`

	// If action type is redirect, this field represents the default redirect URL for the client.
	DefaultRedirectURL *string `json:"defaultRedirectUrl,omitempty"`

	// describes if the policy is in enabled state or disabled state
	EnabledState *PolicyEnabledState `json:"enabledState,omitempty"`

	// Describes if it is in detection mode or prevention mode at policy level.
	Mode *PolicyMode `json:"mode,omitempty"`
}

// PostArgsMatchConditionParameters - Defines the parameters for PostArgs match conditions
type PostArgsMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *PostArgsOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *PostArgsMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// Name of PostArg to be matched
	Selector *string `json:"selector,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// Profile - A profile is a logical grouping of endpoints that share the same settings.
type Profile struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the
	// profile.
	SKU *SKU `json:"sku,omitempty"`

	// The JSON object that contains the properties required to create a profile.
	Properties *ProfileProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD profile.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProfileListResult - Result of the request to list profiles. It contains a list of profile objects and a URL link to get
// the next set of results.
type ProfileListResult struct {
	// URL to get the next set of profile objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of CDN profiles within a resource group.
	Value []*Profile `json:"value,omitempty" azure:"ro"`
}

// ProfileProperties - The JSON object that contains the properties required to create a profile.
type ProfileProperties struct {
	// Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
	OriginResponseTimeoutSeconds *int32 `json:"originResponseTimeoutSeconds,omitempty"`

	// READ-ONLY; The Id of the frontdoor.
	FrontDoorID *string `json:"frontDoorId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status of the profile.
	ProvisioningState *ProfileProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the profile.
	ResourceState *ProfileResourceState `json:"resourceState,omitempty" azure:"ro"`
}

// ProfilePropertiesUpdateParameters - The JSON object containing profile update parameters.
type ProfilePropertiesUpdateParameters struct {
	// Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
	OriginResponseTimeoutSeconds *int32 `json:"originResponseTimeoutSeconds,omitempty"`
}

// ProfileUpdateParameters - Properties required to update a profile.
type ProfileUpdateParameters struct {
	// The JSON object containing profile update parameters.
	Properties *ProfilePropertiesUpdateParameters `json:"properties,omitempty"`

	// Profile tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ProfilesClientBeginCreateOptions contains the optional parameters for the ProfilesClient.BeginCreate method.
type ProfilesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProfilesClientBeginDeleteOptions contains the optional parameters for the ProfilesClient.BeginDelete method.
type ProfilesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProfilesClientBeginUpdateOptions contains the optional parameters for the ProfilesClient.BeginUpdate method.
type ProfilesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProfilesClientGenerateSsoURIOptions contains the optional parameters for the ProfilesClient.GenerateSsoURI method.
type ProfilesClientGenerateSsoURIOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientGetOptions contains the optional parameters for the ProfilesClient.Get method.
type ProfilesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientListByResourceGroupOptions contains the optional parameters for the ProfilesClient.ListByResourceGroup method.
type ProfilesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientListOptions contains the optional parameters for the ProfilesClient.List method.
type ProfilesClientListOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientListResourceUsageOptions contains the optional parameters for the ProfilesClient.ListResourceUsage method.
type ProfilesClientListResourceUsageOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientListSupportedOptimizationTypesOptions contains the optional parameters for the ProfilesClient.ListSupportedOptimizationTypes
// method.
type ProfilesClientListSupportedOptimizationTypesOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PurgeParameters - Parameters required for content purge.
type PurgeParameters struct {
	// REQUIRED; The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths []*string `json:"contentPaths,omitempty"`
}

// QueryStringMatchConditionParameters - Defines the parameters for QueryString match conditions
type QueryStringMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *QueryStringOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *QueryStringMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// RankingsResponse - Rankings Response
type RankingsResponse struct {
	DateTimeBegin *time.Time                    `json:"dateTimeBegin,omitempty"`
	DateTimeEnd   *time.Time                    `json:"dateTimeEnd,omitempty"`
	Tables        []*RankingsResponseTablesItem `json:"tables,omitempty"`
}

type RankingsResponseTablesItem struct {
	Data    []*RankingsResponseTablesPropertiesItemsItem `json:"data,omitempty"`
	Ranking *string                                      `json:"ranking,omitempty"`
}

type RankingsResponseTablesPropertiesItemsItem struct {
	Metrics []*RankingsResponseTablesPropertiesItemsMetricsItem `json:"metrics,omitempty"`
	Name    *string                                             `json:"name,omitempty"`
}

type RankingsResponseTablesPropertiesItemsMetricsItem struct {
	Metric     *string  `json:"metric,omitempty"`
	Percentage *float32 `json:"percentage,omitempty"`
	Value      *int64   `json:"value,omitempty"`
}

// RateLimitRule - Defines a rate limiting rule that can be included in a waf policy
type RateLimitRule struct {
	// REQUIRED; Describes what action to be applied when rule matches
	Action *ActionType `json:"action,omitempty"`

	// REQUIRED; List of match conditions.
	MatchConditions []*MatchCondition `json:"matchConditions,omitempty"`

	// REQUIRED; Defines the name of the custom rule
	Name *string `json:"name,omitempty"`

	// REQUIRED; Defines in what order this rule be evaluated in the overall list of custom rules
	Priority *int32 `json:"priority,omitempty"`

	// REQUIRED; Defines rate limit duration. Default is 1 minute.
	RateLimitDurationInMinutes *int32 `json:"rateLimitDurationInMinutes,omitempty"`

	// REQUIRED; Defines rate limit threshold.
	RateLimitThreshold *int32 `json:"rateLimitThreshold,omitempty"`

	// Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
	EnabledState *CustomRuleEnabledState `json:"enabledState,omitempty"`
}

// RateLimitRuleList - Defines contents of rate limit rules
type RateLimitRuleList struct {
	// List of rules
	Rules []*RateLimitRule `json:"rules,omitempty"`
}

// RemoteAddressMatchConditionParameters - Defines the parameters for RemoteAddress match conditions
type RemoteAddressMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RemoteAddressOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *RemoteAddressMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the
	// variable with the given operator this match condition is considered a match.
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// RequestBodyMatchConditionParameters - Defines the parameters for RequestBody match conditions
type RequestBodyMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestBodyOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *RequestBodyMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// RequestHeaderMatchConditionParameters - Defines the parameters for RequestHeader match conditions
type RequestHeaderMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestHeaderOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *RequestHeaderMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// Name of Header to be matched
	Selector *string `json:"selector,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// RequestMethodMatchConditionParameters - Defines the parameters for RequestMethod match conditions
type RequestMethodMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestMethodOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *RequestMethodMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*RequestMethodMatchConditionParametersMatchValuesItem `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// RequestSchemeMatchConditionParameters - Defines the parameters for RequestScheme match conditions
type RequestSchemeMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestSchemeMatchConditionParametersOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *RequestSchemeMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*RequestSchemeMatchConditionParametersMatchValuesItem `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// RequestURIMatchConditionParameters - Defines the parameters for RequestUri match conditions
type RequestURIMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestURIOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *RequestURIMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// Resource - The core properties of ARM resources
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceReference - Reference to another resource.
type ResourceReference struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// ResourceUsage - Output of check resource usage API.
type ResourceUsage struct {
	// READ-ONLY; Actual value of usage on the specified resource type.
	CurrentValue *int32 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Quota of the specified resource type.
	Limit *int32 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Resource type for which the usage is provided.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; Unit of the usage. e.g. count.
	Unit *ResourceUsageUnit `json:"unit,omitempty" azure:"ro"`
}

// ResourceUsageClientListOptions contains the optional parameters for the ResourceUsageClient.List method.
type ResourceUsageClientListOptions struct {
	// placeholder for future optional parameters
}

// ResourceUsageListResult - Output of check resource usage API.
type ResourceUsageListResult struct {
	// URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of resource usages.
	Value []*ResourceUsage `json:"value,omitempty" azure:"ro"`
}

// ResourcesResponse - Resources Response
type ResourcesResponse struct {
	CustomDomains []*ResourcesResponseCustomDomainsItem `json:"customDomains,omitempty"`
	Endpoints     []*ResourcesResponseEndpointsItem     `json:"endpoints,omitempty"`
}

type ResourcesResponseCustomDomainsItem struct {
	EndpointID *string `json:"endpointId,omitempty"`
	History    *bool   `json:"history,omitempty"`
	ID         *string `json:"id,omitempty"`
	Name       *string `json:"name,omitempty"`
}

type ResourcesResponseEndpointsItem struct {
	CustomDomains []*ResourcesResponseEndpointsPropertiesItemsItem `json:"customDomains,omitempty"`
	History       *bool                                            `json:"history,omitempty"`
	ID            *string                                          `json:"id,omitempty"`
	Name          *string                                          `json:"name,omitempty"`
}

type ResourcesResponseEndpointsPropertiesItemsItem struct {
	EndpointID *string `json:"endpointId,omitempty"`
	History    *bool   `json:"history,omitempty"`
	ID         *string `json:"id,omitempty"`
	Name       *string `json:"name,omitempty"`
}

// ResponseBasedOriginErrorDetectionParameters - The JSON object that contains the properties to determine origin health using
// real requests/responses.
type ResponseBasedOriginErrorDetectionParameters struct {
	// The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
	HTTPErrorRanges []*HTTPErrorRangeParameters `json:"httpErrorRanges,omitempty"`

	// Type of response errors for real user requests for which origin will be deemed unhealthy
	ResponseBasedDetectedErrorTypes *ResponseBasedDetectedErrorTypes `json:"responseBasedDetectedErrorTypes,omitempty"`

	// The percentage of failed requests in the sample where failover should trigger.
	ResponseBasedFailoverThresholdPercentage *int32 `json:"responseBasedFailoverThresholdPercentage,omitempty"`
}

// Route - Friendly Routes name mapping to the any Routes or secret related information.
type Route struct {
	// The JSON object that contains the properties of the Routes to create.
	Properties *RouteProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RouteConfigurationOverrideActionParameters - Defines the parameters for the route configuration override action.
type RouteConfigurationOverrideActionParameters struct {
	// REQUIRED
	TypeName *RouteConfigurationOverrideActionParametersTypeName `json:"typeName,omitempty"`

	// The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *CacheConfiguration `json:"cacheConfiguration,omitempty"`

	// A reference to the origin group override configuration. Leave empty to use the default origin group on route.
	OriginGroupOverride *OriginGroupOverride `json:"originGroupOverride,omitempty"`
}

// RouteListResult - Result of the request to list routes. It contains a list of route objects and a URL link to get the next
// set of results.
type RouteListResult struct {
	// URL to get the next set of route objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of AzureFrontDoor routes within a profile.
	Value []*Route `json:"value,omitempty" azure:"ro"`
}

// RouteProperties - The JSON object that contains the properties of the Routes to create.
type RouteProperties struct {
	// The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *AfdRouteCacheConfiguration `json:"cacheConfiguration,omitempty"`

	// Domains referenced by this endpoint.
	CustomDomains []*ActivatedResourceReference `json:"customDomains,omitempty"`

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *EnabledState `json:"enabledState,omitempty"`

	// Protocol this rule will use when forwarding traffic to backends.
	ForwardingProtocol *ForwardingProtocol `json:"forwardingProtocol,omitempty"`

	// Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it
	// will be the first rule that gets executed.
	HTTPSRedirect *HTTPSRedirect `json:"httpsRedirect,omitempty"`

	// whether this route will be linked to the default endpoint domain.
	LinkToDefaultDomain *LinkToDefaultDomain `json:"linkToDefaultDomain,omitempty"`

	// A reference to the origin group.
	OriginGroup *ResourceReference `json:"originGroup,omitempty"`

	// A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`

	// The route patterns of the rule.
	PatternsToMatch []*string `json:"patternsToMatch,omitempty"`

	// rule sets referenced by this endpoint.
	RuleSets []*ResourceReference `json:"ruleSets,omitempty"`

	// List of supported protocols for this route.
	SupportedProtocols []*AFDEndpointProtocols `json:"supportedProtocols,omitempty"`

	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The name of the endpoint which holds the route.
	EndpointName *string `json:"endpointName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RouteUpdateParameters - The domain JSON object required for domain creation or update.
type RouteUpdateParameters struct {
	// The JSON object that contains the properties of the domain to create.
	Properties *RouteUpdatePropertiesParameters `json:"properties,omitempty"`
}

// RouteUpdatePropertiesParameters - The JSON object that contains the properties of the domain to create.
type RouteUpdatePropertiesParameters struct {
	// The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *AfdRouteCacheConfiguration `json:"cacheConfiguration,omitempty"`

	// Domains referenced by this endpoint.
	CustomDomains []*ActivatedResourceReference `json:"customDomains,omitempty"`

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *EnabledState `json:"enabledState,omitempty"`

	// Protocol this rule will use when forwarding traffic to backends.
	ForwardingProtocol *ForwardingProtocol `json:"forwardingProtocol,omitempty"`

	// Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it
	// will be the first rule that gets executed.
	HTTPSRedirect *HTTPSRedirect `json:"httpsRedirect,omitempty"`

	// whether this route will be linked to the default endpoint domain.
	LinkToDefaultDomain *LinkToDefaultDomain `json:"linkToDefaultDomain,omitempty"`

	// A reference to the origin group.
	OriginGroup *ResourceReference `json:"originGroup,omitempty"`

	// A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`

	// The route patterns of the rule.
	PatternsToMatch []*string `json:"patternsToMatch,omitempty"`

	// rule sets referenced by this endpoint.
	RuleSets []*ResourceReference `json:"ruleSets,omitempty"`

	// List of supported protocols for this route.
	SupportedProtocols []*AFDEndpointProtocols `json:"supportedProtocols,omitempty"`

	// READ-ONLY; The name of the endpoint which holds the route.
	EndpointName *string `json:"endpointName,omitempty" azure:"ro"`
}

// RoutesClientBeginCreateOptions contains the optional parameters for the RoutesClient.BeginCreate method.
type RoutesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutesClientBeginDeleteOptions contains the optional parameters for the RoutesClient.BeginDelete method.
type RoutesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutesClientBeginUpdateOptions contains the optional parameters for the RoutesClient.BeginUpdate method.
type RoutesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutesClientGetOptions contains the optional parameters for the RoutesClient.Get method.
type RoutesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RoutesClientListByEndpointOptions contains the optional parameters for the RoutesClient.ListByEndpoint method.
type RoutesClientListByEndpointOptions struct {
	// placeholder for future optional parameters
}

// Rule - Friendly Rules name mapping to the any Rules or secret related information.
type Rule struct {
	// The JSON object that contains the properties of the Rules to create.
	Properties *RuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RuleListResult - Result of the request to list rules. It contains a list of rule objects and a URL link to get the next
// set of results.
type RuleListResult struct {
	// URL to get the next set of rule objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of AzureFrontDoor rules within a rule set.
	Value []*Rule `json:"value,omitempty" azure:"ro"`
}

// RuleProperties - The JSON object that contains the properties of the Rules to create.
type RuleProperties struct {
	// A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions []DeliveryRuleActionAutoGeneratedClassification `json:"actions,omitempty"`

	// A list of conditions that must be matched for the actions to be executed
	Conditions []DeliveryRuleConditionClassification `json:"conditions,omitempty"`

	// If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults
	// to Continue.
	MatchProcessingBehavior *MatchProcessingBehavior `json:"matchProcessingBehavior,omitempty"`

	// The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will
	// be applied before a rule with a greater order. Rule with order 0 is a special
	// rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32 `json:"order,omitempty"`

	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The name of the rule set containing the rule.
	RuleSetName *string `json:"ruleSetName,omitempty" azure:"ro"`
}

// RuleSet - Friendly RuleSet name mapping to the any RuleSet or secret related information.
type RuleSet struct {
	// The JSON object that contains the properties of the Rule Set to create.
	Properties *RuleSetProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RuleSetListResult - Result of the request to list rule sets. It contains a list of rule set objects and a URL link to get
// the next set of results.
type RuleSetListResult struct {
	// URL to get the next set of rule set objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of AzureFrontDoor rule sets within a profile.
	Value []*RuleSet `json:"value,omitempty" azure:"ro"`
}

// RuleSetProperties - The JSON object that contains the properties of the Rule Set to create.
type RuleSetProperties struct {
	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The name of the profile which holds the rule set.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RuleSetsClientBeginDeleteOptions contains the optional parameters for the RuleSetsClient.BeginDelete method.
type RuleSetsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RuleSetsClientCreateOptions contains the optional parameters for the RuleSetsClient.Create method.
type RuleSetsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// RuleSetsClientGetOptions contains the optional parameters for the RuleSetsClient.Get method.
type RuleSetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RuleSetsClientListByProfileOptions contains the optional parameters for the RuleSetsClient.ListByProfile method.
type RuleSetsClientListByProfileOptions struct {
	// placeholder for future optional parameters
}

// RuleSetsClientListResourceUsageOptions contains the optional parameters for the RuleSetsClient.ListResourceUsage method.
type RuleSetsClientListResourceUsageOptions struct {
	// placeholder for future optional parameters
}

// RuleUpdateParameters - The domain JSON object required for domain creation or update.
type RuleUpdateParameters struct {
	// The JSON object that contains the properties of the rule to update.
	Properties *RuleUpdatePropertiesParameters `json:"properties,omitempty"`
}

// RuleUpdatePropertiesParameters - The JSON object that contains the properties of the rule to update.
type RuleUpdatePropertiesParameters struct {
	// A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions []DeliveryRuleActionAutoGeneratedClassification `json:"actions,omitempty"`

	// A list of conditions that must be matched for the actions to be executed
	Conditions []DeliveryRuleConditionClassification `json:"conditions,omitempty"`

	// If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults
	// to Continue.
	MatchProcessingBehavior *MatchProcessingBehavior `json:"matchProcessingBehavior,omitempty"`

	// The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will
	// be applied before a rule with a greater order. Rule with order 0 is a special
	// rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32 `json:"order,omitempty"`

	// READ-ONLY; The name of the rule set containing the rule.
	RuleSetName *string `json:"ruleSetName,omitempty" azure:"ro"`
}

// RulesClientBeginCreateOptions contains the optional parameters for the RulesClient.BeginCreate method.
type RulesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RulesClientBeginDeleteOptions contains the optional parameters for the RulesClient.BeginDelete method.
type RulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RulesClientBeginUpdateOptions contains the optional parameters for the RulesClient.BeginUpdate method.
type RulesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RulesClientGetOptions contains the optional parameters for the RulesClient.Get method.
type RulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RulesClientListByRuleSetOptions contains the optional parameters for the RulesClient.ListByRuleSet method.
type RulesClientListByRuleSetOptions struct {
	// placeholder for future optional parameters
}

// SKU - StandardVerizon = The SKU name for a Standard Verizon CDN profile. PremiumVerizon = The SKU name for a Premium Verizon
// CDN profile. CustomVerizon = The SKU name for a Custom Verizon CDN profile.
// StandardAkamai = The SKU name for an Akamai CDN profile. StandardChinaCdn = The SKU name for a China CDN profile for VOD,
// Web and download scenarios using GB based billing model. StandardMicrosoft =
// The SKU name for a Standard Microsoft CDN profile. StandardAzureFrontDoor = The SKU name for an Azure Front Door Standard
// profile. PremiumAzureFrontDoor = The SKU name for an Azure Front Door Premium
// profile. Standard955BandWidthChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using
// 95-5 peak bandwidth billing model. StandardAvgBandWidthChinaCdn = The SKU name
// for a China CDN profile for VOD, Web and download scenarios using monthly average peak bandwidth billing model. StandardPlusChinaCdn
// = The SKU name for a China CDN profile for live-streaming using GB
// based billing model. StandardPlus955BandWidthChinaCdn = The SKU name for a China CDN live-streaming profile using 95-5
// peak bandwidth billing model. StandardPlusAvgBandWidth_ChinaCdn = The SKU name
// for a China CDN live-streaming profile using monthly average peak bandwidth billing model.
type SKU struct {
	// Name of the pricing tier.
	Name *SKUName `json:"name,omitempty"`
}

// SSLProtocolMatchConditionParameters - Defines the parameters for SslProtocol match conditions
type SSLProtocolMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *SSLProtocolOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *SSLProtocolMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*SSLProtocol `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// Secret - Friendly Secret name mapping to the any Secret or secret related information.
type Secret struct {
	// The JSON object that contains the properties of the Secret to create.
	Properties *SecretProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecretListResult - Result of the request to list secrets. It contains a list of Secret objects and a URL link to get the
// next set of results.
type SecretListResult struct {
	// URL to get the next set of Secret objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of AzureFrontDoor secrets within a profile.
	Value []*Secret `json:"value,omitempty" azure:"ro"`
}

// SecretParametersClassification provides polymorphic access to related types.
// Call the interface's GetSecretParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFirstPartyManagedCertificateParameters, *CustomerCertificateParameters, *ManagedCertificateParameters, *SecretParameters,
// - *URLSigningKeyParameters
type SecretParametersClassification interface {
	// GetSecretParameters returns the SecretParameters content of the underlying type.
	GetSecretParameters() *SecretParameters
}

// SecretParameters - The json object containing secret parameters
type SecretParameters struct {
	// REQUIRED; The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`
}

// GetSecretParameters implements the SecretParametersClassification interface for type SecretParameters.
func (s *SecretParameters) GetSecretParameters() *SecretParameters { return s }

// SecretProperties - The JSON object that contains the properties of the Secret to create.
type SecretProperties struct {
	// object which contains secret parameters
	Parameters SecretParametersClassification `json:"parameters,omitempty"`

	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The name of the profile which holds the secret.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SecretsClientBeginCreateOptions contains the optional parameters for the SecretsClient.BeginCreate method.
type SecretsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecretsClientBeginDeleteOptions contains the optional parameters for the SecretsClient.BeginDelete method.
type SecretsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecretsClientGetOptions contains the optional parameters for the SecretsClient.Get method.
type SecretsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecretsClientListByProfileOptions contains the optional parameters for the SecretsClient.ListByProfile method.
type SecretsClientListByProfileOptions struct {
	// placeholder for future optional parameters
}

// SecurityPoliciesClientBeginCreateOptions contains the optional parameters for the SecurityPoliciesClient.BeginCreate method.
type SecurityPoliciesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityPoliciesClientBeginDeleteOptions contains the optional parameters for the SecurityPoliciesClient.BeginDelete method.
type SecurityPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityPoliciesClientBeginPatchOptions contains the optional parameters for the SecurityPoliciesClient.BeginPatch method.
type SecurityPoliciesClientBeginPatchOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityPoliciesClientGetOptions contains the optional parameters for the SecurityPoliciesClient.Get method.
type SecurityPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecurityPoliciesClientListByProfileOptions contains the optional parameters for the SecurityPoliciesClient.ListByProfile
// method.
type SecurityPoliciesClientListByProfileOptions struct {
	// placeholder for future optional parameters
}

// SecurityPolicy association for AzureFrontDoor profile
type SecurityPolicy struct {
	// The json object that contains properties required to create a security policy
	Properties *SecurityPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecurityPolicyListResult - Result of the request to list security policies. It contains a list of security policy objects
// and a URL link to get the next set of results.
type SecurityPolicyListResult struct {
	// URL to get the next set of security policy objects if there is any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Security policies within a profile
	Value []*SecurityPolicy `json:"value,omitempty" azure:"ro"`
}

// SecurityPolicyProperties - The json object that contains properties required to create a security policy
type SecurityPolicyProperties struct {
	// object which contains security policy parameters
	Parameters SecurityPolicyPropertiesParametersClassification `json:"parameters,omitempty"`

	// READ-ONLY
	DeploymentStatus *DeploymentStatus `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The name of the profile which holds the security policy.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SecurityPolicyPropertiesParametersClassification provides polymorphic access to related types.
// Call the interface's GetSecurityPolicyPropertiesParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *SecurityPolicyPropertiesParameters, *SecurityPolicyWebApplicationFirewallParameters
type SecurityPolicyPropertiesParametersClassification interface {
	// GetSecurityPolicyPropertiesParameters returns the SecurityPolicyPropertiesParameters content of the underlying type.
	GetSecurityPolicyPropertiesParameters() *SecurityPolicyPropertiesParameters
}

// SecurityPolicyPropertiesParameters - The json object containing security policy parameters
type SecurityPolicyPropertiesParameters struct {
	// REQUIRED; The type of the Security policy to create.
	Type *SecurityPolicyType `json:"type,omitempty"`
}

// GetSecurityPolicyPropertiesParameters implements the SecurityPolicyPropertiesParametersClassification interface for type
// SecurityPolicyPropertiesParameters.
func (s *SecurityPolicyPropertiesParameters) GetSecurityPolicyPropertiesParameters() *SecurityPolicyPropertiesParameters {
	return s
}

// SecurityPolicyUpdateParameters - The JSON object containing security policy update parameters.
type SecurityPolicyUpdateParameters struct {
	// The json object that contains properties required to update a security policy
	Properties *SecurityPolicyUpdateProperties `json:"properties,omitempty"`
}

// SecurityPolicyUpdateProperties - The json object that contains properties required to update a security policy
type SecurityPolicyUpdateProperties struct {
	// object which contains security policy parameters
	Parameters SecurityPolicyPropertiesParametersClassification `json:"parameters,omitempty"`
}

// SecurityPolicyWebApplicationFirewallAssociation - settings for security policy patterns to match
type SecurityPolicyWebApplicationFirewallAssociation struct {
	// List of domains.
	Domains []*ActivatedResourceReference `json:"domains,omitempty"`

	// List of paths
	PatternsToMatch []*string `json:"patternsToMatch,omitempty"`
}

// SecurityPolicyWebApplicationFirewallParameters - The json object containing security policy waf parameters
type SecurityPolicyWebApplicationFirewallParameters struct {
	// REQUIRED; The type of the Security policy to create.
	Type *SecurityPolicyType `json:"type,omitempty"`

	// Waf associations
	Associations []*SecurityPolicyWebApplicationFirewallAssociation `json:"associations,omitempty"`

	// Resource ID.
	WafPolicy *ResourceReference `json:"wafPolicy,omitempty"`
}

// GetSecurityPolicyPropertiesParameters implements the SecurityPolicyPropertiesParametersClassification interface for type
// SecurityPolicyWebApplicationFirewallParameters.
func (s *SecurityPolicyWebApplicationFirewallParameters) GetSecurityPolicyPropertiesParameters() *SecurityPolicyPropertiesParameters {
	return &SecurityPolicyPropertiesParameters{
		Type: s.Type,
	}
}

// ServerPortMatchConditionParameters - Defines the parameters for ServerPort match conditions
type ServerPortMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *ServerPortOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *ServerPortMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// ServiceSpecification - One property of operation, include log specifications.
type ServiceSpecification struct {
	// Log specifications of operation.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// SharedPrivateLinkResourceProperties - Describes the properties of an existing Shared Private Link Resource to use when
// connecting to a private origin.
type SharedPrivateLinkResourceProperties struct {
	// The group id from the provider of resource the shared private link resource is for.
	GroupID *string `json:"groupId,omitempty"`

	// The resource id of the resource the shared private link resource is for.
	PrivateLink *ResourceReference `json:"privateLink,omitempty"`

	// The location of the shared private link resource
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`

	// The request message for requesting approval of the shared private link resource.
	RequestMessage *string `json:"requestMessage,omitempty"`

	// Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout.
	Status *SharedPrivateLinkResourceStatus `json:"status,omitempty"`
}

// SocketAddrMatchConditionParameters - Defines the parameters for SocketAddress match conditions
type SocketAddrMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *SocketAddrOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *SocketAddrMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// SsoURI - The URI required to login to the supplemental portal from the Azure portal.
type SsoURI struct {
	// READ-ONLY; The URI used to login to the supplemental portal.
	SsoURIValue *string `json:"ssoUriValue,omitempty" azure:"ro"`
}

// SupportedOptimizationTypesListResult - The result of the GetSupportedOptimizationTypes API
type SupportedOptimizationTypesListResult struct {
	// READ-ONLY; Supported optimization types for a profile.
	SupportedOptimizationTypes []*OptimizationType `json:"supportedOptimizationTypes,omitempty" azure:"ro"`
}

// SystemData - Read only system data
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// An identifier for the identity that created the resource
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource
	CreatedByType *IdentityType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// An identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// URLFileExtensionMatchConditionParameters - Defines the parameters for UrlFileExtension match conditions
type URLFileExtensionMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *URLFileExtensionOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *URLFileExtensionMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// URLFileNameMatchConditionParameters - Defines the parameters for UrlFilename match conditions
type URLFileNameMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *URLFileNameOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *URLFileNameMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// URLPathMatchConditionParameters - Defines the parameters for UrlPath match conditions
type URLPathMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *URLPathOperator `json:"operator,omitempty"`

	// REQUIRED
	TypeName *URLPathMatchConditionParametersTypeName `json:"typeName,omitempty"`

	// The match value for the condition of the delivery rule
	MatchValues []*string `json:"matchValues,omitempty"`

	// Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`

	// List of transforms
	Transforms []*Transform `json:"transforms,omitempty"`
}

// URLRedirectAction - Defines the url redirect action for the delivery rule.
type URLRedirectAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *URLRedirectActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type URLRedirectAction.
func (u *URLRedirectAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: u.Name,
	}
}

// URLRedirectActionParameters - Defines the parameters for the url redirect action.
type URLRedirectActionParameters struct {
	// REQUIRED; The redirect type the rule will use when redirecting traffic.
	RedirectType *RedirectType `json:"redirectType,omitempty"`

	// REQUIRED
	TypeName *URLRedirectActionParametersTypeName `json:"typeName,omitempty"`

	// Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
	CustomFragment *string `json:"customFragment,omitempty"`

	// Host to redirect. Leave empty to use the incoming host as the destination host.
	CustomHostname *string `json:"customHostname,omitempty"`

	// The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination
	// path.
	CustomPath *string `json:"customPath,omitempty"`

	// The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string;
	// leave empty to preserve the incoming query string. Query string must be in =
	// format. ? and & will be added automatically so do not include them.
	CustomQueryString *string `json:"customQueryString,omitempty"`

	// Protocol to use for the redirect. The default value is MatchRequest
	DestinationProtocol *DestinationProtocol `json:"destinationProtocol,omitempty"`
}

// URLRewriteAction - Defines the url rewrite action for the delivery rule.
type URLRewriteAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *URLRewriteActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type URLRewriteAction.
func (u *URLRewriteAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: u.Name,
	}
}

// URLRewriteActionParameters - Defines the parameters for the url rewrite action.
type URLRewriteActionParameters struct {
	// REQUIRED; Define the relative URL to which the above requests will be rewritten by.
	Destination *string `json:"destination,omitempty"`

	// REQUIRED; define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all
	// strings are matched.
	SourcePattern *string `json:"sourcePattern,omitempty"`

	// REQUIRED
	TypeName *URLRewriteActionParametersTypeName `json:"typeName,omitempty"`

	// Whether to preserve unmatched path. Default value is true.
	PreserveUnmatchedPath *bool `json:"preserveUnmatchedPath,omitempty"`
}

// URLSigningAction - Defines the url signing action for the delivery rule.
type URLSigningAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction `json:"name,omitempty"`

	// REQUIRED; Defines the parameters for the action.
	Parameters *URLSigningActionParameters `json:"parameters,omitempty"`
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type URLSigningAction.
func (u *URLSigningAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: u.Name,
	}
}

// URLSigningActionParameters - Defines the parameters for the Url Signing action.
type URLSigningActionParameters struct {
	// REQUIRED
	TypeName *URLSigningActionParametersTypeName `json:"typeName,omitempty"`

	// Algorithm to use for URL signing
	Algorithm *Algorithm `json:"algorithm,omitempty"`

	// Defines which query string parameters in the url to be considered for expires, key id etc.
	ParameterNameOverride []*URLSigningParamIdentifier `json:"parameterNameOverride,omitempty"`
}

// URLSigningKey - Url signing key
type URLSigningKey struct {
	// REQUIRED; Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form
	// the hash.
	KeyID *string `json:"keyId,omitempty"`

	// REQUIRED; Defines the parameters for using customer key vault for Url Signing Key.
	KeySourceParameters *KeyVaultSigningKeyParameters `json:"keySourceParameters,omitempty"`
}

// URLSigningKeyParameters - Url signing key parameters
type URLSigningKeyParameters struct {
	// REQUIRED; Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form
	// the hash.
	KeyID *string `json:"keyId,omitempty"`

	// REQUIRED; Resource reference to the Azure Key Vault secret. Expected to be in format of
	// /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference `json:"secretSource,omitempty"`

	// REQUIRED; The type of the secret resource.
	Type *SecretType `json:"type,omitempty"`

	// Version of the secret to be used
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// GetSecretParameters implements the SecretParametersClassification interface for type URLSigningKeyParameters.
func (u *URLSigningKeyParameters) GetSecretParameters() *SecretParameters {
	return &SecretParameters{
		Type: u.Type,
	}
}

// URLSigningParamIdentifier - Defines how to identify a parameter for a specific purpose e.g. expires
type URLSigningParamIdentifier struct {
	// REQUIRED; Indicates the purpose of the parameter
	ParamIndicator *ParamIndicator `json:"paramIndicator,omitempty"`

	// REQUIRED; Parameter name
	ParamName *string `json:"paramName,omitempty"`
}

// Usage - Describes resource usage.
type Usage struct {
	// REQUIRED; The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// REQUIRED; The limit of usage.
	Limit *int64 `json:"limit,omitempty"`

	// REQUIRED; The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`

	// REQUIRED; An enum describing the unit of measurement.
	Unit *UsageUnit `json:"unit,omitempty"`

	// READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// UsageName - The usage names.
type UsageName struct {
	// A localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// A string describing the resource name.
	Value *string `json:"value,omitempty"`
}

// UsagesListResult - The list usages operation response.
type UsagesListResult struct {
	// URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of resource usages.
	Value []*Usage `json:"value,omitempty"`
}

// UserManagedHTTPSParameters - Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
type UserManagedHTTPSParameters struct {
	// REQUIRED; Defines the source of the SSL certificate.
	CertificateSource *CertificateSource `json:"certificateSource,omitempty"`

	// REQUIRED; Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
	CertificateSourceParameters *KeyVaultCertificateSourceParameters `json:"certificateSourceParameters,omitempty"`

	// REQUIRED; Defines the TLS extension protocol that is used for secure delivery.
	ProtocolType *ProtocolType `json:"protocolType,omitempty"`

	// TLS protocol version that will be used for Https
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
}

// GetCustomDomainHTTPSParameters implements the CustomDomainHTTPSParametersClassification interface for type UserManagedHTTPSParameters.
func (u *UserManagedHTTPSParameters) GetCustomDomainHTTPSParameters() *CustomDomainHTTPSParameters {
	return &CustomDomainHTTPSParameters{
		CertificateSource: u.CertificateSource,
		ProtocolType:      u.ProtocolType,
		MinimumTLSVersion: u.MinimumTLSVersion,
	}
}

// ValidateClientSecretOptions contains the optional parameters for the ValidateClient.Secret method.
type ValidateClientSecretOptions struct {
	// placeholder for future optional parameters
}

// ValidateCustomDomainInput - Input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput - Output of custom domain validation.
type ValidateCustomDomainOutput struct {
	// READ-ONLY; Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty" azure:"ro"`

	// READ-ONLY; Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty" azure:"ro"`
}

// ValidateProbeInput - Input of the validate probe API.
type ValidateProbeInput struct {
	// REQUIRED; The probe URL to validate.
	ProbeURL *string `json:"probeURL,omitempty"`
}

// ValidateProbeOutput - Output of the validate probe API.
type ValidateProbeOutput struct {
	// READ-ONLY; Specifies the error code when the probe url is not accepted.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the probe URL is accepted or not.
	IsValid *bool `json:"isValid,omitempty" azure:"ro"`

	// READ-ONLY; The detailed error message describing why the probe URL is not accepted.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ValidateSecretInput - Input of the secret to be validated.
type ValidateSecretInput struct {
	// REQUIRED; Resource reference to the Azure Key Vault secret. Expected to be in format of
	// /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference `json:"secretSource,omitempty"`

	// REQUIRED; The secret type.
	SecretType *SecretType `json:"secretType,omitempty"`

	// Secret version, if customer is using a specific version.
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// ValidateSecretOutput - Output of the validated secret.
type ValidateSecretOutput struct {
	// Detailed error message
	Message *string `json:"message,omitempty"`

	// The validation status.
	Status *Status `json:"status,omitempty"`
}

// ValidationToken - The validation token.
type ValidationToken struct {
	// READ-ONLY
	Token *string `json:"token,omitempty" azure:"ro"`
}

// WafMetricsResponse - Waf Metrics Response
type WafMetricsResponse struct {
	DateTimeBegin *time.Time                      `json:"dateTimeBegin,omitempty"`
	DateTimeEnd   *time.Time                      `json:"dateTimeEnd,omitempty"`
	Granularity   *WafMetricsResponseGranularity  `json:"granularity,omitempty"`
	Series        []*WafMetricsResponseSeriesItem `json:"series,omitempty"`
}

type WafMetricsResponseSeriesItem struct {
	Data   []*Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems `json:"data,omitempty"`
	Groups []*WafMetricsResponseSeriesPropertiesItemsItem                                        `json:"groups,omitempty"`
	Metric *string                                                                               `json:"metric,omitempty"`
	Unit   *WafMetricsResponseSeriesItemUnit                                                     `json:"unit,omitempty"`
}

type WafMetricsResponseSeriesPropertiesItemsItem struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// WafRankingsResponse - Waf Rankings Response
type WafRankingsResponse struct {
	Data          []*WafRankingsResponseDataItem `json:"data,omitempty"`
	DateTimeBegin *time.Time                     `json:"dateTimeBegin,omitempty"`
	DateTimeEnd   *time.Time                     `json:"dateTimeEnd,omitempty"`
	Groups        []*string                      `json:"groups,omitempty"`
}

type WafRankingsResponseDataItem struct {
	GroupValues []*string                                                                              `json:"groupValues,omitempty"`
	Metrics     []*ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems `json:"metrics,omitempty"`
}

// WebApplicationFirewallPolicy - Defines web application firewall policy for Azure CDN.
type WebApplicationFirewallPolicy struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
	SKU *SKU `json:"sku,omitempty"`

	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Properties of the web application firewall policy.
	Properties *WebApplicationFirewallPolicyProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Read only system data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebApplicationFirewallPolicyList - Defines a list of WebApplicationFirewallPolicies for Azure CDN. It contains a list of
// WebApplicationFirewallPolicy objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyList struct {
	// URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; List of Azure CDN WebApplicationFirewallPolicies within a resource group.
	Value []*WebApplicationFirewallPolicy `json:"value,omitempty" azure:"ro"`
}

// WebApplicationFirewallPolicyPatchParameters - Properties required to update a CdnWebApplicationFirewallPolicy.
type WebApplicationFirewallPolicyPatchParameters struct {
	// CdnWebApplicationFirewallPolicy tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// WebApplicationFirewallPolicyProperties - Defines CDN web application firewall policy properties.
type WebApplicationFirewallPolicyProperties struct {
	// Describes custom rules inside the policy.
	CustomRules *CustomRuleList `json:"customRules,omitempty"`

	// Describes managed rules inside the policy.
	ManagedRules *ManagedRuleSetList `json:"managedRules,omitempty"`

	// Describes policySettings for policy
	PolicySettings *PolicySettings `json:"policySettings,omitempty"`

	// Describes rate limit rules inside the policy.
	RateLimitRules *RateLimitRuleList `json:"rateLimitRules,omitempty"`

	// READ-ONLY; Describes Azure CDN endpoints associated with this Web Application Firewall policy.
	EndpointLinks []*LinkedEndpoint `json:"endpointLinks,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the WebApplicationFirewallPolicy.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource status of the policy.
	ResourceState *PolicyResourceState `json:"resourceState,omitempty" azure:"ro"`
}
