//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// RecommendationsClient contains the methods for the Recommendations group.
// Don't use this type directly, use NewRecommendationsClient() instead.
type RecommendationsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewRecommendationsClient creates a new instance of RecommendationsClient with the specified values.
// subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewRecommendationsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*RecommendationsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &RecommendationsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// DisableAllForHostingEnvironment - Description for Disable all recommendations for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// environmentName - Name of the app.
// options - RecommendationsClientDisableAllForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.DisableAllForHostingEnvironment
// method.
func (client *RecommendationsClient) DisableAllForHostingEnvironment(ctx context.Context, resourceGroupName string, environmentName string, hostingEnvironmentName string, options *RecommendationsClientDisableAllForHostingEnvironmentOptions) (RecommendationsClientDisableAllForHostingEnvironmentResponse, error) {
	req, err := client.disableAllForHostingEnvironmentCreateRequest(ctx, resourceGroupName, environmentName, hostingEnvironmentName, options)
	if err != nil {
		return RecommendationsClientDisableAllForHostingEnvironmentResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientDisableAllForHostingEnvironmentResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return RecommendationsClientDisableAllForHostingEnvironmentResponse{}, runtime.NewResponseError(resp)
	}
	return RecommendationsClientDisableAllForHostingEnvironmentResponse{}, nil
}

// disableAllForHostingEnvironmentCreateRequest creates the DisableAllForHostingEnvironment request.
func (client *RecommendationsClient) disableAllForHostingEnvironmentCreateRequest(ctx context.Context, resourceGroupName string, environmentName string, hostingEnvironmentName string, options *RecommendationsClientDisableAllForHostingEnvironmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/disable"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hostingEnvironmentName == "" {
		return nil, errors.New("parameter hostingEnvironmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostingEnvironmentName}", url.PathEscape(hostingEnvironmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("environmentName", environmentName)
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DisableAllForWebApp - Description for Disable all recommendations for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Name of the app.
// options - RecommendationsClientDisableAllForWebAppOptions contains the optional parameters for the RecommendationsClient.DisableAllForWebApp
// method.
func (client *RecommendationsClient) DisableAllForWebApp(ctx context.Context, resourceGroupName string, siteName string, options *RecommendationsClientDisableAllForWebAppOptions) (RecommendationsClientDisableAllForWebAppResponse, error) {
	req, err := client.disableAllForWebAppCreateRequest(ctx, resourceGroupName, siteName, options)
	if err != nil {
		return RecommendationsClientDisableAllForWebAppResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientDisableAllForWebAppResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return RecommendationsClientDisableAllForWebAppResponse{}, runtime.NewResponseError(resp)
	}
	return RecommendationsClientDisableAllForWebAppResponse{}, nil
}

// disableAllForWebAppCreateRequest creates the DisableAllForWebApp request.
func (client *RecommendationsClient) disableAllForWebAppCreateRequest(ctx context.Context, resourceGroupName string, siteName string, options *RecommendationsClientDisableAllForWebAppOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/disable"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DisableRecommendationForHostingEnvironment - Description for Disables the specific rule for a web site permanently.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// environmentName - Site name
// name - Rule name
// options - RecommendationsClientDisableRecommendationForHostingEnvironmentOptions contains the optional parameters for the
// RecommendationsClient.DisableRecommendationForHostingEnvironment method.
func (client *RecommendationsClient) DisableRecommendationForHostingEnvironment(ctx context.Context, resourceGroupName string, environmentName string, name string, hostingEnvironmentName string, options *RecommendationsClientDisableRecommendationForHostingEnvironmentOptions) (RecommendationsClientDisableRecommendationForHostingEnvironmentResponse, error) {
	req, err := client.disableRecommendationForHostingEnvironmentCreateRequest(ctx, resourceGroupName, environmentName, name, hostingEnvironmentName, options)
	if err != nil {
		return RecommendationsClientDisableRecommendationForHostingEnvironmentResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientDisableRecommendationForHostingEnvironmentResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RecommendationsClientDisableRecommendationForHostingEnvironmentResponse{}, runtime.NewResponseError(resp)
	}
	return RecommendationsClientDisableRecommendationForHostingEnvironmentResponse{}, nil
}

// disableRecommendationForHostingEnvironmentCreateRequest creates the DisableRecommendationForHostingEnvironment request.
func (client *RecommendationsClient) disableRecommendationForHostingEnvironmentCreateRequest(ctx context.Context, resourceGroupName string, environmentName string, name string, hostingEnvironmentName string, options *RecommendationsClientDisableRecommendationForHostingEnvironmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}/disable"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if hostingEnvironmentName == "" {
		return nil, errors.New("parameter hostingEnvironmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostingEnvironmentName}", url.PathEscape(hostingEnvironmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("environmentName", environmentName)
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DisableRecommendationForSite - Description for Disables the specific rule for a web site permanently.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Site name
// name - Rule name
// options - RecommendationsClientDisableRecommendationForSiteOptions contains the optional parameters for the RecommendationsClient.DisableRecommendationForSite
// method.
func (client *RecommendationsClient) DisableRecommendationForSite(ctx context.Context, resourceGroupName string, siteName string, name string, options *RecommendationsClientDisableRecommendationForSiteOptions) (RecommendationsClientDisableRecommendationForSiteResponse, error) {
	req, err := client.disableRecommendationForSiteCreateRequest(ctx, resourceGroupName, siteName, name, options)
	if err != nil {
		return RecommendationsClientDisableRecommendationForSiteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientDisableRecommendationForSiteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RecommendationsClientDisableRecommendationForSiteResponse{}, runtime.NewResponseError(resp)
	}
	return RecommendationsClientDisableRecommendationForSiteResponse{}, nil
}

// disableRecommendationForSiteCreateRequest creates the DisableRecommendationForSite request.
func (client *RecommendationsClient) disableRecommendationForSiteCreateRequest(ctx context.Context, resourceGroupName string, siteName string, name string, options *RecommendationsClientDisableRecommendationForSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}/disable"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DisableRecommendationForSubscription - Description for Disables the specified rule so it will not apply to a subscription
// in the future.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// name - Rule name
// options - RecommendationsClientDisableRecommendationForSubscriptionOptions contains the optional parameters for the RecommendationsClient.DisableRecommendationForSubscription
// method.
func (client *RecommendationsClient) DisableRecommendationForSubscription(ctx context.Context, name string, options *RecommendationsClientDisableRecommendationForSubscriptionOptions) (RecommendationsClientDisableRecommendationForSubscriptionResponse, error) {
	req, err := client.disableRecommendationForSubscriptionCreateRequest(ctx, name, options)
	if err != nil {
		return RecommendationsClientDisableRecommendationForSubscriptionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientDisableRecommendationForSubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RecommendationsClientDisableRecommendationForSubscriptionResponse{}, runtime.NewResponseError(resp)
	}
	return RecommendationsClientDisableRecommendationForSubscriptionResponse{}, nil
}

// disableRecommendationForSubscriptionCreateRequest creates the DisableRecommendationForSubscription request.
func (client *RecommendationsClient) disableRecommendationForSubscriptionCreateRequest(ctx context.Context, name string, options *RecommendationsClientDisableRecommendationForSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/{name}/disable"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetRuleDetailsByHostingEnvironment - Description for Get a recommendation rule for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// hostingEnvironmentName - Name of the hosting environment.
// name - Name of the recommendation.
// options - RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.GetRuleDetailsByHostingEnvironment
// method.
func (client *RecommendationsClient) GetRuleDetailsByHostingEnvironment(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, name string, options *RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions) (RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse, error) {
	req, err := client.getRuleDetailsByHostingEnvironmentCreateRequest(ctx, resourceGroupName, hostingEnvironmentName, name, options)
	if err != nil {
		return RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse{}, runtime.NewResponseError(resp)
	}
	return client.getRuleDetailsByHostingEnvironmentHandleResponse(resp)
}

// getRuleDetailsByHostingEnvironmentCreateRequest creates the GetRuleDetailsByHostingEnvironment request.
func (client *RecommendationsClient) getRuleDetailsByHostingEnvironmentCreateRequest(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, name string, options *RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hostingEnvironmentName == "" {
		return nil, errors.New("parameter hostingEnvironmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostingEnvironmentName}", url.PathEscape(hostingEnvironmentName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.UpdateSeen != nil {
		reqQP.Set("updateSeen", strconv.FormatBool(*options.UpdateSeen))
	}
	if options != nil && options.RecommendationID != nil {
		reqQP.Set("recommendationId", *options.RecommendationID)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRuleDetailsByHostingEnvironmentHandleResponse handles the GetRuleDetailsByHostingEnvironment response.
func (client *RecommendationsClient) getRuleDetailsByHostingEnvironmentHandleResponse(resp *http.Response) (RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse, error) {
	result := RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RecommendationRule); err != nil {
		return RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse{}, err
	}
	return result, nil
}

// GetRuleDetailsByWebApp - Description for Get a recommendation rule for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Name of the app.
// name - Name of the recommendation.
// options - RecommendationsClientGetRuleDetailsByWebAppOptions contains the optional parameters for the RecommendationsClient.GetRuleDetailsByWebApp
// method.
func (client *RecommendationsClient) GetRuleDetailsByWebApp(ctx context.Context, resourceGroupName string, siteName string, name string, options *RecommendationsClientGetRuleDetailsByWebAppOptions) (RecommendationsClientGetRuleDetailsByWebAppResponse, error) {
	req, err := client.getRuleDetailsByWebAppCreateRequest(ctx, resourceGroupName, siteName, name, options)
	if err != nil {
		return RecommendationsClientGetRuleDetailsByWebAppResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientGetRuleDetailsByWebAppResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RecommendationsClientGetRuleDetailsByWebAppResponse{}, runtime.NewResponseError(resp)
	}
	return client.getRuleDetailsByWebAppHandleResponse(resp)
}

// getRuleDetailsByWebAppCreateRequest creates the GetRuleDetailsByWebApp request.
func (client *RecommendationsClient) getRuleDetailsByWebAppCreateRequest(ctx context.Context, resourceGroupName string, siteName string, name string, options *RecommendationsClientGetRuleDetailsByWebAppOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.UpdateSeen != nil {
		reqQP.Set("updateSeen", strconv.FormatBool(*options.UpdateSeen))
	}
	if options != nil && options.RecommendationID != nil {
		reqQP.Set("recommendationId", *options.RecommendationID)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRuleDetailsByWebAppHandleResponse handles the GetRuleDetailsByWebApp response.
func (client *RecommendationsClient) getRuleDetailsByWebAppHandleResponse(resp *http.Response) (RecommendationsClientGetRuleDetailsByWebAppResponse, error) {
	result := RecommendationsClientGetRuleDetailsByWebAppResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RecommendationRule); err != nil {
		return RecommendationsClientGetRuleDetailsByWebAppResponse{}, err
	}
	return result, nil
}

// NewListPager - Description for List all recommendations for a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - RecommendationsClientListOptions contains the optional parameters for the RecommendationsClient.List method.
func (client *RecommendationsClient) NewListPager(options *RecommendationsClientListOptions) *runtime.Pager[RecommendationsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[RecommendationsClientListResponse]{
		More: func(page RecommendationsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RecommendationsClientListResponse) (RecommendationsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return RecommendationsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return RecommendationsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return RecommendationsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *RecommendationsClient) listCreateRequest(ctx context.Context, options *RecommendationsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Featured != nil {
		reqQP.Set("featured", strconv.FormatBool(*options.Featured))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *RecommendationsClient) listHandleResponse(resp *http.Response) (RecommendationsClientListResponse, error) {
	result := RecommendationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RecommendationCollection); err != nil {
		return RecommendationsClientListResponse{}, err
	}
	return result, nil
}

// NewListHistoryForHostingEnvironmentPager - Description for Get past recommendations for an app, optionally specified by
// the time range.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// hostingEnvironmentName - Name of the hosting environment.
// options - RecommendationsClientListHistoryForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.ListHistoryForHostingEnvironment
// method.
func (client *RecommendationsClient) NewListHistoryForHostingEnvironmentPager(resourceGroupName string, hostingEnvironmentName string, options *RecommendationsClientListHistoryForHostingEnvironmentOptions) *runtime.Pager[RecommendationsClientListHistoryForHostingEnvironmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[RecommendationsClientListHistoryForHostingEnvironmentResponse]{
		More: func(page RecommendationsClientListHistoryForHostingEnvironmentResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RecommendationsClientListHistoryForHostingEnvironmentResponse) (RecommendationsClientListHistoryForHostingEnvironmentResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listHistoryForHostingEnvironmentCreateRequest(ctx, resourceGroupName, hostingEnvironmentName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return RecommendationsClientListHistoryForHostingEnvironmentResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return RecommendationsClientListHistoryForHostingEnvironmentResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return RecommendationsClientListHistoryForHostingEnvironmentResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHistoryForHostingEnvironmentHandleResponse(resp)
		},
	})
}

// listHistoryForHostingEnvironmentCreateRequest creates the ListHistoryForHostingEnvironment request.
func (client *RecommendationsClient) listHistoryForHostingEnvironmentCreateRequest(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, options *RecommendationsClientListHistoryForHostingEnvironmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendationHistory"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hostingEnvironmentName == "" {
		return nil, errors.New("parameter hostingEnvironmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostingEnvironmentName}", url.PathEscape(hostingEnvironmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.ExpiredOnly != nil {
		reqQP.Set("expiredOnly", strconv.FormatBool(*options.ExpiredOnly))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHistoryForHostingEnvironmentHandleResponse handles the ListHistoryForHostingEnvironment response.
func (client *RecommendationsClient) listHistoryForHostingEnvironmentHandleResponse(resp *http.Response) (RecommendationsClientListHistoryForHostingEnvironmentResponse, error) {
	result := RecommendationsClientListHistoryForHostingEnvironmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RecommendationCollection); err != nil {
		return RecommendationsClientListHistoryForHostingEnvironmentResponse{}, err
	}
	return result, nil
}

// NewListHistoryForWebAppPager - Description for Get past recommendations for an app, optionally specified by the time range.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Name of the app.
// options - RecommendationsClientListHistoryForWebAppOptions contains the optional parameters for the RecommendationsClient.ListHistoryForWebApp
// method.
func (client *RecommendationsClient) NewListHistoryForWebAppPager(resourceGroupName string, siteName string, options *RecommendationsClientListHistoryForWebAppOptions) *runtime.Pager[RecommendationsClientListHistoryForWebAppResponse] {
	return runtime.NewPager(runtime.PagingHandler[RecommendationsClientListHistoryForWebAppResponse]{
		More: func(page RecommendationsClientListHistoryForWebAppResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RecommendationsClientListHistoryForWebAppResponse) (RecommendationsClientListHistoryForWebAppResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listHistoryForWebAppCreateRequest(ctx, resourceGroupName, siteName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return RecommendationsClientListHistoryForWebAppResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return RecommendationsClientListHistoryForWebAppResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return RecommendationsClientListHistoryForWebAppResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHistoryForWebAppHandleResponse(resp)
		},
	})
}

// listHistoryForWebAppCreateRequest creates the ListHistoryForWebApp request.
func (client *RecommendationsClient) listHistoryForWebAppCreateRequest(ctx context.Context, resourceGroupName string, siteName string, options *RecommendationsClientListHistoryForWebAppOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendationHistory"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.ExpiredOnly != nil {
		reqQP.Set("expiredOnly", strconv.FormatBool(*options.ExpiredOnly))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHistoryForWebAppHandleResponse handles the ListHistoryForWebApp response.
func (client *RecommendationsClient) listHistoryForWebAppHandleResponse(resp *http.Response) (RecommendationsClientListHistoryForWebAppResponse, error) {
	result := RecommendationsClientListHistoryForWebAppResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RecommendationCollection); err != nil {
		return RecommendationsClientListHistoryForWebAppResponse{}, err
	}
	return result, nil
}

// NewListRecommendedRulesForHostingEnvironmentPager - Description for Get all recommendations for a hosting environment.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// hostingEnvironmentName - Name of the app.
// options - RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions contains the optional parameters for the
// RecommendationsClient.ListRecommendedRulesForHostingEnvironment method.
func (client *RecommendationsClient) NewListRecommendedRulesForHostingEnvironmentPager(resourceGroupName string, hostingEnvironmentName string, options *RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions) *runtime.Pager[RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse]{
		More: func(page RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse) (RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listRecommendedRulesForHostingEnvironmentCreateRequest(ctx, resourceGroupName, hostingEnvironmentName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse{}, runtime.NewResponseError(resp)
			}
			return client.listRecommendedRulesForHostingEnvironmentHandleResponse(resp)
		},
	})
}

// listRecommendedRulesForHostingEnvironmentCreateRequest creates the ListRecommendedRulesForHostingEnvironment request.
func (client *RecommendationsClient) listRecommendedRulesForHostingEnvironmentCreateRequest(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, options *RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hostingEnvironmentName == "" {
		return nil, errors.New("parameter hostingEnvironmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostingEnvironmentName}", url.PathEscape(hostingEnvironmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Featured != nil {
		reqQP.Set("featured", strconv.FormatBool(*options.Featured))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRecommendedRulesForHostingEnvironmentHandleResponse handles the ListRecommendedRulesForHostingEnvironment response.
func (client *RecommendationsClient) listRecommendedRulesForHostingEnvironmentHandleResponse(resp *http.Response) (RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse, error) {
	result := RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RecommendationCollection); err != nil {
		return RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse{}, err
	}
	return result, nil
}

// NewListRecommendedRulesForWebAppPager - Description for Get all recommendations for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Name of the app.
// options - RecommendationsClientListRecommendedRulesForWebAppOptions contains the optional parameters for the RecommendationsClient.ListRecommendedRulesForWebApp
// method.
func (client *RecommendationsClient) NewListRecommendedRulesForWebAppPager(resourceGroupName string, siteName string, options *RecommendationsClientListRecommendedRulesForWebAppOptions) *runtime.Pager[RecommendationsClientListRecommendedRulesForWebAppResponse] {
	return runtime.NewPager(runtime.PagingHandler[RecommendationsClientListRecommendedRulesForWebAppResponse]{
		More: func(page RecommendationsClientListRecommendedRulesForWebAppResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RecommendationsClientListRecommendedRulesForWebAppResponse) (RecommendationsClientListRecommendedRulesForWebAppResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listRecommendedRulesForWebAppCreateRequest(ctx, resourceGroupName, siteName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return RecommendationsClientListRecommendedRulesForWebAppResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return RecommendationsClientListRecommendedRulesForWebAppResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return RecommendationsClientListRecommendedRulesForWebAppResponse{}, runtime.NewResponseError(resp)
			}
			return client.listRecommendedRulesForWebAppHandleResponse(resp)
		},
	})
}

// listRecommendedRulesForWebAppCreateRequest creates the ListRecommendedRulesForWebApp request.
func (client *RecommendationsClient) listRecommendedRulesForWebAppCreateRequest(ctx context.Context, resourceGroupName string, siteName string, options *RecommendationsClientListRecommendedRulesForWebAppOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Featured != nil {
		reqQP.Set("featured", strconv.FormatBool(*options.Featured))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRecommendedRulesForWebAppHandleResponse handles the ListRecommendedRulesForWebApp response.
func (client *RecommendationsClient) listRecommendedRulesForWebAppHandleResponse(resp *http.Response) (RecommendationsClientListRecommendedRulesForWebAppResponse, error) {
	result := RecommendationsClientListRecommendedRulesForWebAppResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RecommendationCollection); err != nil {
		return RecommendationsClientListRecommendedRulesForWebAppResponse{}, err
	}
	return result, nil
}

// ResetAllFilters - Description for Reset all recommendation opt-out settings for a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - RecommendationsClientResetAllFiltersOptions contains the optional parameters for the RecommendationsClient.ResetAllFilters
// method.
func (client *RecommendationsClient) ResetAllFilters(ctx context.Context, options *RecommendationsClientResetAllFiltersOptions) (RecommendationsClientResetAllFiltersResponse, error) {
	req, err := client.resetAllFiltersCreateRequest(ctx, options)
	if err != nil {
		return RecommendationsClientResetAllFiltersResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientResetAllFiltersResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return RecommendationsClientResetAllFiltersResponse{}, runtime.NewResponseError(resp)
	}
	return RecommendationsClientResetAllFiltersResponse{}, nil
}

// resetAllFiltersCreateRequest creates the ResetAllFilters request.
func (client *RecommendationsClient) resetAllFiltersCreateRequest(ctx context.Context, options *RecommendationsClientResetAllFiltersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/reset"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// ResetAllFiltersForHostingEnvironment - Description for Reset all recommendation opt-out settings for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// environmentName - Name of the app.
// options - RecommendationsClientResetAllFiltersForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.ResetAllFiltersForHostingEnvironment
// method.
func (client *RecommendationsClient) ResetAllFiltersForHostingEnvironment(ctx context.Context, resourceGroupName string, environmentName string, hostingEnvironmentName string, options *RecommendationsClientResetAllFiltersForHostingEnvironmentOptions) (RecommendationsClientResetAllFiltersForHostingEnvironmentResponse, error) {
	req, err := client.resetAllFiltersForHostingEnvironmentCreateRequest(ctx, resourceGroupName, environmentName, hostingEnvironmentName, options)
	if err != nil {
		return RecommendationsClientResetAllFiltersForHostingEnvironmentResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientResetAllFiltersForHostingEnvironmentResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return RecommendationsClientResetAllFiltersForHostingEnvironmentResponse{}, runtime.NewResponseError(resp)
	}
	return RecommendationsClientResetAllFiltersForHostingEnvironmentResponse{}, nil
}

// resetAllFiltersForHostingEnvironmentCreateRequest creates the ResetAllFiltersForHostingEnvironment request.
func (client *RecommendationsClient) resetAllFiltersForHostingEnvironmentCreateRequest(ctx context.Context, resourceGroupName string, environmentName string, hostingEnvironmentName string, options *RecommendationsClientResetAllFiltersForHostingEnvironmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/reset"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hostingEnvironmentName == "" {
		return nil, errors.New("parameter hostingEnvironmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hostingEnvironmentName}", url.PathEscape(hostingEnvironmentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("environmentName", environmentName)
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// ResetAllFiltersForWebApp - Description for Reset all recommendation opt-out settings for an app.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// siteName - Name of the app.
// options - RecommendationsClientResetAllFiltersForWebAppOptions contains the optional parameters for the RecommendationsClient.ResetAllFiltersForWebApp
// method.
func (client *RecommendationsClient) ResetAllFiltersForWebApp(ctx context.Context, resourceGroupName string, siteName string, options *RecommendationsClientResetAllFiltersForWebAppOptions) (RecommendationsClientResetAllFiltersForWebAppResponse, error) {
	req, err := client.resetAllFiltersForWebAppCreateRequest(ctx, resourceGroupName, siteName, options)
	if err != nil {
		return RecommendationsClientResetAllFiltersForWebAppResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecommendationsClientResetAllFiltersForWebAppResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return RecommendationsClientResetAllFiltersForWebAppResponse{}, runtime.NewResponseError(resp)
	}
	return RecommendationsClientResetAllFiltersForWebAppResponse{}, nil
}

// resetAllFiltersForWebAppCreateRequest creates the ResetAllFiltersForWebApp request.
func (client *RecommendationsClient) resetAllFiltersForWebAppCreateRequest(ctx context.Context, resourceGroupName string, siteName string, options *RecommendationsClientResetAllFiltersForWebAppOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/reset"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if siteName == "" {
		return nil, errors.New("parameter siteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{siteName}", url.PathEscape(siteName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
