// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/securitycenter/v2/resource_value_config.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Value enum to map to a resource
type ResourceValue int32

const (
	// Unspecific value
	ResourceValue_RESOURCE_VALUE_UNSPECIFIED ResourceValue = 0
	// High resource value
	ResourceValue_HIGH ResourceValue = 1
	// Medium resource value
	ResourceValue_MEDIUM ResourceValue = 2
	// Low resource value
	ResourceValue_LOW ResourceValue = 3
	// No resource value, e.g. ignore these resources
	ResourceValue_NONE ResourceValue = 4
)

// Enum value maps for ResourceValue.
var (
	ResourceValue_name = map[int32]string{
		0: "RESOURCE_VALUE_UNSPECIFIED",
		1: "HIGH",
		2: "MEDIUM",
		3: "LOW",
		4: "NONE",
	}
	ResourceValue_value = map[string]int32{
		"RESOURCE_VALUE_UNSPECIFIED": 0,
		"HIGH":                       1,
		"MEDIUM":                     2,
		"LOW":                        3,
		"NONE":                       4,
	}
)

func (x ResourceValue) Enum() *ResourceValue {
	p := new(ResourceValue)
	*p = x
	return p
}

func (x ResourceValue) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceValue) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_resource_value_config_proto_enumTypes[0].Descriptor()
}

func (ResourceValue) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_resource_value_config_proto_enumTypes[0]
}

func (x ResourceValue) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceValue.Descriptor instead.
func (ResourceValue) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescGZIP(), []int{0}
}

// A resource value config (RVC) is a mapping configuration of user's resources
// to resource values. Used in Attack path simulations.
type ResourceValueConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name for the resource value config
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Resource value level this expression represents
	// Only required when there is no SDP mapping in the request
	ResourceValue ResourceValue `protobuf:"varint,2,opt,name=resource_value,json=resourceValue,proto3,enum=google.cloud.securitycenter.v2.ResourceValue" json:"resource_value,omitempty"`
	// Required. Tag values combined with AND to check against.
	// Values in the form "tagValues/123"
	// E.g. [ "tagValues/123", "tagValues/456", "tagValues/789" ]
	// https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing
	TagValues []string `protobuf:"bytes,3,rep,name=tag_values,json=tagValues,proto3" json:"tag_values,omitempty"`
	// Apply resource_value only to resources that match resource_type.
	// resource_type will be checked with "AND" of other resources.
	// E.g. "storage.googleapis.com/Bucket" with resource_value "HIGH" will
	// apply "HIGH" value only to "storage.googleapis.com/Bucket" resources.
	ResourceType string `protobuf:"bytes,4,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Project or folder to scope this config to.
	// For example, "project/456" would apply this config only to resources in
	// "project/456"
	// scope will be checked with "AND" of other resources.
	Scope string `protobuf:"bytes,5,opt,name=scope,proto3" json:"scope,omitempty"`
	// List of resource labels to search for, evaluated with AND.
	// E.g. "resource_labels_selector": {"key": "value", "env": "prod"}
	// will match resources with labels "key": "value" AND "env": "prod"
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels
	ResourceLabelsSelector map[string]string `protobuf:"bytes,6,rep,name=resource_labels_selector,json=resourceLabelsSelector,proto3" json:"resource_labels_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Description of the resource value config.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Timestamp this resource value config was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp this resource value config was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// A mapping of the sensitivity on Sensitive Data Protection finding to
	// resource values. This mapping can only be used in combination with a
	// resource_type that is related to BigQuery, e.g.
	// "bigquery.googleapis.com/Dataset".
	SensitiveDataProtectionMapping *ResourceValueConfig_SensitiveDataProtectionMapping `protobuf:"bytes,11,opt,name=sensitive_data_protection_mapping,json=sensitiveDataProtectionMapping,proto3" json:"sensitive_data_protection_mapping,omitempty"`
}

func (x *ResourceValueConfig) Reset() {
	*x = ResourceValueConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_resource_value_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceValueConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceValueConfig) ProtoMessage() {}

func (x *ResourceValueConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_value_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceValueConfig.ProtoReflect.Descriptor instead.
func (*ResourceValueConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescGZIP(), []int{0}
}

func (x *ResourceValueConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourceValueConfig) GetResourceValue() ResourceValue {
	if x != nil {
		return x.ResourceValue
	}
	return ResourceValue_RESOURCE_VALUE_UNSPECIFIED
}

func (x *ResourceValueConfig) GetTagValues() []string {
	if x != nil {
		return x.TagValues
	}
	return nil
}

func (x *ResourceValueConfig) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *ResourceValueConfig) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *ResourceValueConfig) GetResourceLabelsSelector() map[string]string {
	if x != nil {
		return x.ResourceLabelsSelector
	}
	return nil
}

func (x *ResourceValueConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ResourceValueConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ResourceValueConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ResourceValueConfig) GetSensitiveDataProtectionMapping() *ResourceValueConfig_SensitiveDataProtectionMapping {
	if x != nil {
		return x.SensitiveDataProtectionMapping
	}
	return nil
}

// Resource value mapping for Sensitive Data Protection findings
// If any of these mappings have a resource value that is not unspecified,
// the resource_value field will be ignored when reading this configuration.
type ResourceValueConfig_SensitiveDataProtectionMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource value mapping for high-sensitivity Sensitive Data Protection
	// findings
	HighSensitivityMapping ResourceValue `protobuf:"varint,1,opt,name=high_sensitivity_mapping,json=highSensitivityMapping,proto3,enum=google.cloud.securitycenter.v2.ResourceValue" json:"high_sensitivity_mapping,omitempty"`
	// Resource value mapping for medium-sensitivity Sensitive Data Protection
	// findings
	MediumSensitivityMapping ResourceValue `protobuf:"varint,2,opt,name=medium_sensitivity_mapping,json=mediumSensitivityMapping,proto3,enum=google.cloud.securitycenter.v2.ResourceValue" json:"medium_sensitivity_mapping,omitempty"`
}

func (x *ResourceValueConfig_SensitiveDataProtectionMapping) Reset() {
	*x = ResourceValueConfig_SensitiveDataProtectionMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_resource_value_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceValueConfig_SensitiveDataProtectionMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceValueConfig_SensitiveDataProtectionMapping) ProtoMessage() {}

func (x *ResourceValueConfig_SensitiveDataProtectionMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_value_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceValueConfig_SensitiveDataProtectionMapping.ProtoReflect.Descriptor instead.
func (*ResourceValueConfig_SensitiveDataProtectionMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ResourceValueConfig_SensitiveDataProtectionMapping) GetHighSensitivityMapping() ResourceValue {
	if x != nil {
		return x.HighSensitivityMapping
	}
	return ResourceValue_RESOURCE_VALUE_UNSPECIFIED
}

func (x *ResourceValueConfig_SensitiveDataProtectionMapping) GetMediumSensitivityMapping() ResourceValue {
	if x != nil {
		return x.MediumSensitivityMapping
	}
	return ResourceValue_RESOURCE_VALUE_UNSPECIFIED
}

var File_google_cloud_securitycenter_v2_resource_value_config_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf8, 0x08, 0x0a, 0x13, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x74,
	0x61, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x61, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x18, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x5f, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x16,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x9d, 0x01, 0x0a,
	0x21, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x1e, 0x73, 0x65,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x1a, 0xf6, 0x01, 0x0a,
	0x1e, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12,
	0x67, 0x0a, 0x18, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x16, 0x68, 0x69, 0x67, 0x68, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x6b, 0x0a, 0x1a, 0x6d, 0x65, 0x64, 0x69,
	0x75, 0x6d, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x6d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x6d, 0x65, 0x64,
	0x69, 0x75, 0x6d, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x4d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x1a, 0x49, 0x0a, 0x1b, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x31, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x7d, 0x2a, 0x58, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x4c,
	0x4f, 0x57, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x04, 0x42, 0xf2,
	0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x18, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x32, 0xca, 0x02,
	0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x32, 0xea,
	0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a,
	0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescData = file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_resource_value_config_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v2_resource_value_config_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_securitycenter_v2_resource_value_config_proto_goTypes = []interface{}{
	(ResourceValue)(0),          // 0: google.cloud.securitycenter.v2.ResourceValue
	(*ResourceValueConfig)(nil), // 1: google.cloud.securitycenter.v2.ResourceValueConfig
	(*ResourceValueConfig_SensitiveDataProtectionMapping)(nil), // 2: google.cloud.securitycenter.v2.ResourceValueConfig.SensitiveDataProtectionMapping
	nil,                           // 3: google.cloud.securitycenter.v2.ResourceValueConfig.ResourceLabelsSelectorEntry
	(*timestamppb.Timestamp)(nil), // 4: google.protobuf.Timestamp
}
var file_google_cloud_securitycenter_v2_resource_value_config_proto_depIdxs = []int32{
	0, // 0: google.cloud.securitycenter.v2.ResourceValueConfig.resource_value:type_name -> google.cloud.securitycenter.v2.ResourceValue
	3, // 1: google.cloud.securitycenter.v2.ResourceValueConfig.resource_labels_selector:type_name -> google.cloud.securitycenter.v2.ResourceValueConfig.ResourceLabelsSelectorEntry
	4, // 2: google.cloud.securitycenter.v2.ResourceValueConfig.create_time:type_name -> google.protobuf.Timestamp
	4, // 3: google.cloud.securitycenter.v2.ResourceValueConfig.update_time:type_name -> google.protobuf.Timestamp
	2, // 4: google.cloud.securitycenter.v2.ResourceValueConfig.sensitive_data_protection_mapping:type_name -> google.cloud.securitycenter.v2.ResourceValueConfig.SensitiveDataProtectionMapping
	0, // 5: google.cloud.securitycenter.v2.ResourceValueConfig.SensitiveDataProtectionMapping.high_sensitivity_mapping:type_name -> google.cloud.securitycenter.v2.ResourceValue
	0, // 6: google.cloud.securitycenter.v2.ResourceValueConfig.SensitiveDataProtectionMapping.medium_sensitivity_mapping:type_name -> google.cloud.securitycenter.v2.ResourceValue
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_resource_value_config_proto_init() }
func file_google_cloud_securitycenter_v2_resource_value_config_proto_init() {
	if File_google_cloud_securitycenter_v2_resource_value_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_v2_resource_value_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceValueConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_resource_value_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceValueConfig_SensitiveDataProtectionMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_resource_value_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_resource_value_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_resource_value_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_resource_value_config_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_resource_value_config_proto = out.File
	file_google_cloud_securitycenter_v2_resource_value_config_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_resource_value_config_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_resource_value_config_proto_depIdxs = nil
}
