// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/policysimulator/v1/simulator.proto

package policysimulatorpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	date "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the [Replay][google.cloud.policysimulator.v1.Replay].
type Replay_State int32

const (
	// Default value. This value is unused.
	Replay_STATE_UNSPECIFIED Replay_State = 0
	// The `Replay` has not started yet.
	Replay_PENDING Replay_State = 1
	// The `Replay` is currently running.
	Replay_RUNNING Replay_State = 2
	// The `Replay` has successfully completed.
	Replay_SUCCEEDED Replay_State = 3
	// The `Replay` has finished with an error.
	Replay_FAILED Replay_State = 4
)

// Enum value maps for Replay_State.
var (
	Replay_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
	}
	Replay_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"FAILED":            4,
	}
)

func (x Replay_State) Enum() *Replay_State {
	p := new(Replay_State)
	*p = x
	return p
}

func (x Replay_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Replay_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policysimulator_v1_simulator_proto_enumTypes[0].Descriptor()
}

func (Replay_State) Type() protoreflect.EnumType {
	return &file_google_cloud_policysimulator_v1_simulator_proto_enumTypes[0]
}

func (x Replay_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Replay_State.Descriptor instead.
func (Replay_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{0, 0}
}

// The source of the logs to use for a
// [Replay][google.cloud.policysimulator.v1.Replay].
type ReplayConfig_LogSource int32

const (
	// An unspecified log source.
	// If the log source is unspecified, the
	// [Replay][google.cloud.policysimulator.v1.Replay] defaults to using
	// `RECENT_ACCESSES`.
	ReplayConfig_LOG_SOURCE_UNSPECIFIED ReplayConfig_LogSource = 0
	// All access logs from the last 90 days. These logs may not include logs
	// from the most recent 7 days.
	ReplayConfig_RECENT_ACCESSES ReplayConfig_LogSource = 1
)

// Enum value maps for ReplayConfig_LogSource.
var (
	ReplayConfig_LogSource_name = map[int32]string{
		0: "LOG_SOURCE_UNSPECIFIED",
		1: "RECENT_ACCESSES",
	}
	ReplayConfig_LogSource_value = map[string]int32{
		"LOG_SOURCE_UNSPECIFIED": 0,
		"RECENT_ACCESSES":        1,
	}
)

func (x ReplayConfig_LogSource) Enum() *ReplayConfig_LogSource {
	p := new(ReplayConfig_LogSource)
	*p = x
	return p
}

func (x ReplayConfig_LogSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplayConfig_LogSource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policysimulator_v1_simulator_proto_enumTypes[1].Descriptor()
}

func (ReplayConfig_LogSource) Type() protoreflect.EnumType {
	return &file_google_cloud_policysimulator_v1_simulator_proto_enumTypes[1]
}

func (x ReplayConfig_LogSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReplayConfig_LogSource.Descriptor instead.
func (ReplayConfig_LogSource) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{7, 0}
}

// How the principal's access, specified in the AccessState field, changed
// between the current (baseline) policies and proposed (simulated) policies.
type AccessStateDiff_AccessChangeType int32

const (
	// Default value. This value is unused.
	AccessStateDiff_ACCESS_CHANGE_TYPE_UNSPECIFIED AccessStateDiff_AccessChangeType = 0
	// The principal's access did not change.
	// This includes the case where both baseline and simulated are UNKNOWN,
	// but the unknown information is equivalent.
	AccessStateDiff_NO_CHANGE AccessStateDiff_AccessChangeType = 1
	// The principal's access under both the current policies and the proposed
	// policies is `UNKNOWN`, but the unknown information differs between them.
	AccessStateDiff_UNKNOWN_CHANGE AccessStateDiff_AccessChangeType = 2
	// The principal had access under the current policies (`GRANTED`), but will
	// no longer have access after the proposed changes (`NOT_GRANTED`).
	AccessStateDiff_ACCESS_REVOKED AccessStateDiff_AccessChangeType = 3
	// The principal did not have access under the current policies
	// (`NOT_GRANTED`), but will have access after the proposed changes
	// (`GRANTED`).
	AccessStateDiff_ACCESS_GAINED AccessStateDiff_AccessChangeType = 4
	// This result can occur for the following reasons:
	//
	//   - The principal had access under the current policies (`GRANTED`), but
	//     their access after the proposed changes is `UNKNOWN`.
	//
	// * The principal's access under the current policies is `UNKNOWN`, but
	// they
	//
	//	will not have access after the proposed changes (`NOT_GRANTED`).
	AccessStateDiff_ACCESS_MAYBE_REVOKED AccessStateDiff_AccessChangeType = 5
	// This result can occur for the following reasons:
	//
	//   - The principal did not have access under the current policies
	//     (`NOT_GRANTED`), but their access after the proposed changes is
	//     `UNKNOWN`.
	//
	// * The principal's access under the current policies is `UNKNOWN`, but
	// they will have access after the proposed changes (`GRANTED`).
	AccessStateDiff_ACCESS_MAYBE_GAINED AccessStateDiff_AccessChangeType = 6
)

// Enum value maps for AccessStateDiff_AccessChangeType.
var (
	AccessStateDiff_AccessChangeType_name = map[int32]string{
		0: "ACCESS_CHANGE_TYPE_UNSPECIFIED",
		1: "NO_CHANGE",
		2: "UNKNOWN_CHANGE",
		3: "ACCESS_REVOKED",
		4: "ACCESS_GAINED",
		5: "ACCESS_MAYBE_REVOKED",
		6: "ACCESS_MAYBE_GAINED",
	}
	AccessStateDiff_AccessChangeType_value = map[string]int32{
		"ACCESS_CHANGE_TYPE_UNSPECIFIED": 0,
		"NO_CHANGE":                      1,
		"UNKNOWN_CHANGE":                 2,
		"ACCESS_REVOKED":                 3,
		"ACCESS_GAINED":                  4,
		"ACCESS_MAYBE_REVOKED":           5,
		"ACCESS_MAYBE_GAINED":            6,
	}
)

func (x AccessStateDiff_AccessChangeType) Enum() *AccessStateDiff_AccessChangeType {
	p := new(AccessStateDiff_AccessChangeType)
	*p = x
	return p
}

func (x AccessStateDiff_AccessChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessStateDiff_AccessChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policysimulator_v1_simulator_proto_enumTypes[2].Descriptor()
}

func (AccessStateDiff_AccessChangeType) Type() protoreflect.EnumType {
	return &file_google_cloud_policysimulator_v1_simulator_proto_enumTypes[2]
}

func (x AccessStateDiff_AccessChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessStateDiff_AccessChangeType.Descriptor instead.
func (AccessStateDiff_AccessChangeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{9, 0}
}

// A resource describing a `Replay`, or simulation.
type Replay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the `Replay`, which has the following
	// format:
	//
	// `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
	// where `{resource-id}` is the ID of the project, folder, or organization
	// that owns the Replay.
	//
	// Example:
	// `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The current state of the `Replay`.
	State Replay_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.policysimulator.v1.Replay_State" json:"state,omitempty"`
	// Required. The configuration used for the `Replay`.
	Config *ReplayConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	// Output only. Summary statistics about the replayed log entries.
	ResultsSummary *Replay_ResultsSummary `protobuf:"bytes,5,opt,name=results_summary,json=resultsSummary,proto3" json:"results_summary,omitempty"`
}

func (x *Replay) Reset() {
	*x = Replay{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Replay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Replay) ProtoMessage() {}

func (x *Replay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Replay.ProtoReflect.Descriptor instead.
func (*Replay) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{0}
}

func (x *Replay) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Replay) GetState() Replay_State {
	if x != nil {
		return x.State
	}
	return Replay_STATE_UNSPECIFIED
}

func (x *Replay) GetConfig() *ReplayConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Replay) GetResultsSummary() *Replay_ResultsSummary {
	if x != nil {
		return x.ResultsSummary
	}
	return nil
}

// The result of replaying a single access tuple against a simulated state.
type ReplayResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of replaying the access tuple.
	//
	// Types that are assignable to Result:
	//
	//	*ReplayResult_Diff
	//	*ReplayResult_Error
	Result isReplayResult_Result `protobuf_oneof:"result"`
	// The resource name of the `ReplayResult`, in the following format:
	//
	// `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
	// where `{resource-id}` is the ID of the project, folder, or organization
	// that owns the [Replay][google.cloud.policysimulator.v1.Replay].
	//
	// Example:
	// `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
	// was included in.
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The access tuple that was replayed. This field includes information about
	// the principal, resource, and permission that were involved in the access
	// attempt.
	AccessTuple *AccessTuple `protobuf:"bytes,3,opt,name=access_tuple,json=accessTuple,proto3" json:"access_tuple,omitempty"`
	// The latest date this access tuple was seen in the logs.
	LastSeenDate *date.Date `protobuf:"bytes,4,opt,name=last_seen_date,json=lastSeenDate,proto3" json:"last_seen_date,omitempty"`
}

func (x *ReplayResult) Reset() {
	*x = ReplayResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplayResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplayResult) ProtoMessage() {}

func (x *ReplayResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplayResult.ProtoReflect.Descriptor instead.
func (*ReplayResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{1}
}

func (m *ReplayResult) GetResult() isReplayResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *ReplayResult) GetDiff() *ReplayDiff {
	if x, ok := x.GetResult().(*ReplayResult_Diff); ok {
		return x.Diff
	}
	return nil
}

func (x *ReplayResult) GetError() *status.Status {
	if x, ok := x.GetResult().(*ReplayResult_Error); ok {
		return x.Error
	}
	return nil
}

func (x *ReplayResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReplayResult) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ReplayResult) GetAccessTuple() *AccessTuple {
	if x != nil {
		return x.AccessTuple
	}
	return nil
}

func (x *ReplayResult) GetLastSeenDate() *date.Date {
	if x != nil {
		return x.LastSeenDate
	}
	return nil
}

type isReplayResult_Result interface {
	isReplayResult_Result()
}

type ReplayResult_Diff struct {
	// The difference between the principal's access under the current
	// (baseline) policies and the principal's access under the proposed
	// (simulated) policies.
	//
	// This field is only included for access tuples that were successfully
	// replayed and had different results under the current policies and the
	// proposed policies.
	Diff *ReplayDiff `protobuf:"bytes,5,opt,name=diff,proto3,oneof"`
}

type ReplayResult_Error struct {
	// The error that caused the access tuple replay to fail.
	//
	// This field is only included for access tuples that were not replayed
	// successfully.
	Error *status.Status `protobuf:"bytes,6,opt,name=error,proto3,oneof"`
}

func (*ReplayResult_Diff) isReplayResult_Result() {}

func (*ReplayResult_Error) isReplayResult_Result() {}

// Request message for
// [Simulator.CreateReplay][google.cloud.policysimulator.v1.Simulator.CreateReplay].
type CreateReplayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this
	// [Replay][google.cloud.policysimulator.v1.Replay] will be created. This
	// resource must be a project, folder, or organization with a location.
	//
	// Example: `projects/my-example-project/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [Replay][google.cloud.policysimulator.v1.Replay] to create.
	// Set `Replay.ReplayConfig` to configure the replay.
	Replay *Replay `protobuf:"bytes,2,opt,name=replay,proto3" json:"replay,omitempty"`
}

func (x *CreateReplayRequest) Reset() {
	*x = CreateReplayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReplayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReplayRequest) ProtoMessage() {}

func (x *CreateReplayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReplayRequest.ProtoReflect.Descriptor instead.
func (*CreateReplayRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{2}
}

func (x *CreateReplayRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReplayRequest) GetReplay() *Replay {
	if x != nil {
		return x.Replay
	}
	return nil
}

// Metadata about a Replay operation.
type ReplayOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time when the request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *ReplayOperationMetadata) Reset() {
	*x = ReplayOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplayOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplayOperationMetadata) ProtoMessage() {}

func (x *ReplayOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplayOperationMetadata.ProtoReflect.Descriptor instead.
func (*ReplayOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{3}
}

func (x *ReplayOperationMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Request message for
// [Simulator.GetReplay][google.cloud.policysimulator.v1.Simulator.GetReplay].
type GetReplayRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the [Replay][google.cloud.policysimulator.v1.Replay]
	// to retrieve, in the following format:
	//
	// `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
	// where `{resource-id}` is the ID of the project, folder, or organization
	// that owns the `Replay`.
	//
	// Example:
	// `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReplayRequest) Reset() {
	*x = GetReplayRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReplayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReplayRequest) ProtoMessage() {}

func (x *GetReplayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReplayRequest.ProtoReflect.Descriptor instead.
func (*GetReplayRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{4}
}

func (x *GetReplayRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [Simulator.ListReplayResults][google.cloud.policysimulator.v1.Simulator.ListReplayResults].
type ListReplayResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [Replay][google.cloud.policysimulator.v1.Replay] whose
	// results are listed, in the following format:
	//
	// `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`
	//
	// Example:
	// `projects/my-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of
	// [ReplayResult][google.cloud.policysimulator.v1.ReplayResult] objects to
	// return. Defaults to 5000.
	//
	// The maximum value is 5000; values above 5000 are rounded down to 5000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [Simulator.ListReplayResults][google.cloud.policysimulator.v1.Simulator.ListReplayResults]
	// call. Provide this token to retrieve the next page of results.
	//
	// When paginating, all other parameters provided to
	// [Simulator.ListReplayResults[] must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListReplayResultsRequest) Reset() {
	*x = ListReplayResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReplayResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReplayResultsRequest) ProtoMessage() {}

func (x *ListReplayResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReplayResultsRequest.ProtoReflect.Descriptor instead.
func (*ListReplayResultsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{5}
}

func (x *ListReplayResultsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReplayResultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReplayResultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [Simulator.ListReplayResults][google.cloud.policysimulator.v1.Simulator.ListReplayResults].
type ListReplayResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results of running a [Replay][google.cloud.policysimulator.v1.Replay].
	ReplayResults []*ReplayResult `protobuf:"bytes,1,rep,name=replay_results,json=replayResults,proto3" json:"replay_results,omitempty"`
	// A token that you can use to retrieve the next page of
	// [ReplayResult][google.cloud.policysimulator.v1.ReplayResult] objects. If
	// this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReplayResultsResponse) Reset() {
	*x = ListReplayResultsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReplayResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReplayResultsResponse) ProtoMessage() {}

func (x *ListReplayResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReplayResultsResponse.ProtoReflect.Descriptor instead.
func (*ListReplayResultsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{6}
}

func (x *ListReplayResultsResponse) GetReplayResults() []*ReplayResult {
	if x != nil {
		return x.ReplayResults
	}
	return nil
}

func (x *ListReplayResultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The configuration used for a
// [Replay][google.cloud.policysimulator.v1.Replay].
type ReplayConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A mapping of the resources that you want to simulate policies for and the
	// policies that you want to simulate.
	//
	// Keys are the full resource names for the resources. For example,
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	// For examples of full resource names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	//
	// Values are [Policy][google.iam.v1.Policy] objects representing the policies
	// that you want to simulate.
	//
	// Replays automatically take into account any IAM policies inherited through
	// the resource hierarchy, and any policies set on descendant resources. You
	// do not need to include these policies in the policy overlay.
	PolicyOverlay map[string]*iampb.Policy `protobuf:"bytes,1,rep,name=policy_overlay,json=policyOverlay,proto3" json:"policy_overlay,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The logs to use as input for the
	// [Replay][google.cloud.policysimulator.v1.Replay].
	LogSource ReplayConfig_LogSource `protobuf:"varint,2,opt,name=log_source,json=logSource,proto3,enum=google.cloud.policysimulator.v1.ReplayConfig_LogSource" json:"log_source,omitempty"`
}

func (x *ReplayConfig) Reset() {
	*x = ReplayConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplayConfig) ProtoMessage() {}

func (x *ReplayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplayConfig.ProtoReflect.Descriptor instead.
func (*ReplayConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{7}
}

func (x *ReplayConfig) GetPolicyOverlay() map[string]*iampb.Policy {
	if x != nil {
		return x.PolicyOverlay
	}
	return nil
}

func (x *ReplayConfig) GetLogSource() ReplayConfig_LogSource {
	if x != nil {
		return x.LogSource
	}
	return ReplayConfig_LOG_SOURCE_UNSPECIFIED
}

// The difference between the results of evaluating an access tuple under
// the current (baseline) policies and under the proposed (simulated) policies.
// This difference explains how a principal's access could change if the
// proposed policies were applied.
type ReplayDiff struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A summary and comparison of the principal's access under the current
	// (baseline) policies and the proposed (simulated) policies for a single
	// access tuple.
	//
	// The evaluation of the principal's access is reported in the
	// [AccessState][google.cloud.policysimulator.v1.AccessState] field.
	AccessDiff *AccessStateDiff `protobuf:"bytes,2,opt,name=access_diff,json=accessDiff,proto3" json:"access_diff,omitempty"`
}

func (x *ReplayDiff) Reset() {
	*x = ReplayDiff{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplayDiff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplayDiff) ProtoMessage() {}

func (x *ReplayDiff) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplayDiff.ProtoReflect.Descriptor instead.
func (*ReplayDiff) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{8}
}

func (x *ReplayDiff) GetAccessDiff() *AccessStateDiff {
	if x != nil {
		return x.AccessDiff
	}
	return nil
}

// A summary and comparison of the principal's access under the current
// (baseline) policies and the proposed (simulated) policies for a single
// access tuple.
type AccessStateDiff struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results of evaluating the access tuple under the current (baseline)
	// policies.
	//
	// If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
	// be fully evaluated, this field explains why.
	Baseline *ExplainedAccess `protobuf:"bytes,1,opt,name=baseline,proto3" json:"baseline,omitempty"`
	// The results of evaluating the access tuple under the proposed (simulated)
	// policies.
	//
	// If the AccessState couldn't be fully evaluated, this field explains why.
	Simulated *ExplainedAccess `protobuf:"bytes,2,opt,name=simulated,proto3" json:"simulated,omitempty"`
	// How the principal's access, specified in the AccessState field, changed
	// between the current (baseline) policies and proposed (simulated) policies.
	AccessChange AccessStateDiff_AccessChangeType `protobuf:"varint,3,opt,name=access_change,json=accessChange,proto3,enum=google.cloud.policysimulator.v1.AccessStateDiff_AccessChangeType" json:"access_change,omitempty"`
}

func (x *AccessStateDiff) Reset() {
	*x = AccessStateDiff{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessStateDiff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessStateDiff) ProtoMessage() {}

func (x *AccessStateDiff) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessStateDiff.ProtoReflect.Descriptor instead.
func (*AccessStateDiff) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{9}
}

func (x *AccessStateDiff) GetBaseline() *ExplainedAccess {
	if x != nil {
		return x.Baseline
	}
	return nil
}

func (x *AccessStateDiff) GetSimulated() *ExplainedAccess {
	if x != nil {
		return x.Simulated
	}
	return nil
}

func (x *AccessStateDiff) GetAccessChange() AccessStateDiff_AccessChangeType {
	if x != nil {
		return x.AccessChange
	}
	return AccessStateDiff_ACCESS_CHANGE_TYPE_UNSPECIFIED
}

// Details about how a set of policies, listed in
// [ExplainedPolicy][google.cloud.policysimulator.v1.ExplainedPolicy], resulted
// in a certain [AccessState][google.cloud.policysimulator.v1.AccessState] when
// replaying an access tuple.
type ExplainedAccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the principal in the access tuple has permission to access the
	// resource in the access tuple under the given policies.
	AccessState AccessState `protobuf:"varint,1,opt,name=access_state,json=accessState,proto3,enum=google.cloud.policysimulator.v1.AccessState" json:"access_state,omitempty"`
	// If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
	// `UNKNOWN`, this field contains the policies that led to that result.
	//
	// If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
	// omitted.
	Policies []*ExplainedPolicy `protobuf:"bytes,2,rep,name=policies,proto3" json:"policies,omitempty"`
	// If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
	// `UNKNOWN`, this field contains a list of errors explaining why the result
	// is `UNKNOWN`.
	//
	// If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
	// omitted.
	Errors []*status.Status `protobuf:"bytes,3,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *ExplainedAccess) Reset() {
	*x = ExplainedAccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplainedAccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplainedAccess) ProtoMessage() {}

func (x *ExplainedAccess) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplainedAccess.ProtoReflect.Descriptor instead.
func (*ExplainedAccess) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{10}
}

func (x *ExplainedAccess) GetAccessState() AccessState {
	if x != nil {
		return x.AccessState
	}
	return AccessState_ACCESS_STATE_UNSPECIFIED
}

func (x *ExplainedAccess) GetPolicies() []*ExplainedPolicy {
	if x != nil {
		return x.Policies
	}
	return nil
}

func (x *ExplainedAccess) GetErrors() []*status.Status {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Summary statistics about the replayed log entries.
type Replay_ResultsSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of log entries replayed.
	LogCount int32 `protobuf:"varint,1,opt,name=log_count,json=logCount,proto3" json:"log_count,omitempty"`
	// The number of replayed log entries with no difference between
	// baseline and simulated policies.
	UnchangedCount int32 `protobuf:"varint,2,opt,name=unchanged_count,json=unchangedCount,proto3" json:"unchanged_count,omitempty"`
	// The number of replayed log entries with a difference between baseline and
	// simulated policies.
	DifferenceCount int32 `protobuf:"varint,3,opt,name=difference_count,json=differenceCount,proto3" json:"difference_count,omitempty"`
	// The number of log entries that could not be replayed.
	ErrorCount int32 `protobuf:"varint,4,opt,name=error_count,json=errorCount,proto3" json:"error_count,omitempty"`
	// The date of the oldest log entry replayed.
	OldestDate *date.Date `protobuf:"bytes,5,opt,name=oldest_date,json=oldestDate,proto3" json:"oldest_date,omitempty"`
	// The date of the newest log entry replayed.
	NewestDate *date.Date `protobuf:"bytes,6,opt,name=newest_date,json=newestDate,proto3" json:"newest_date,omitempty"`
}

func (x *Replay_ResultsSummary) Reset() {
	*x = Replay_ResultsSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Replay_ResultsSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Replay_ResultsSummary) ProtoMessage() {}

func (x *Replay_ResultsSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Replay_ResultsSummary.ProtoReflect.Descriptor instead.
func (*Replay_ResultsSummary) Descriptor() ([]byte, []int) {
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Replay_ResultsSummary) GetLogCount() int32 {
	if x != nil {
		return x.LogCount
	}
	return 0
}

func (x *Replay_ResultsSummary) GetUnchangedCount() int32 {
	if x != nil {
		return x.UnchangedCount
	}
	return 0
}

func (x *Replay_ResultsSummary) GetDifferenceCount() int32 {
	if x != nil {
		return x.DifferenceCount
	}
	return 0
}

func (x *Replay_ResultsSummary) GetErrorCount() int32 {
	if x != nil {
		return x.ErrorCount
	}
	return 0
}

func (x *Replay_ResultsSummary) GetOldestDate() *date.Date {
	if x != nil {
		return x.OldestDate
	}
	return nil
}

func (x *Replay_ResultsSummary) GetNewestDate() *date.Date {
	if x != nil {
		return x.NewestDate
	}
	return nil
}

var File_google_cloud_policysimulator_v1_simulator_proto protoreflect.FileDescriptor

var file_google_cloud_policysimulator_v1_simulator_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x6f, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x06, 0x0a,
	0x06, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x1a, 0x8a, 0x02, 0x0a,
	0x0e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12,
	0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f,
	0x75, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x75, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0f, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x32, 0x0a, 0x0b, 0x6f, 0x6c, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x6f, 0x6c, 0x64, 0x65, 0x73,
	0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a, 0x0b, 0x6e, 0x65, 0x77, 0x65, 0x73, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x6e,
	0x65, 0x77, 0x65, 0x73, 0x74, 0x44, 0x61, 0x74, 0x65, 0x22, 0x53, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0xe1,
	0x01, 0xea, 0x41, 0xdd, 0x01, 0x0a, 0x25, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x12, 0x38, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x72,
	0x65, 0x70, 0x6c, 0x61, 0x79, 0x7d, 0x12, 0x36, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65,
	0x70, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x7d, 0x12, 0x42,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x79, 0x7d, 0x22, 0x9b, 0x05, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x64, 0x69, 0x66, 0x66, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x69, 0x66, 0x66, 0x48, 0x00,
	0x52, 0x04, 0x64, 0x69, 0x66, 0x66, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c,
	0x61, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x0c, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x75, 0x70, 0x6c, 0x65, 0x52, 0x0b,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x75, 0x70, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x0e, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e,
	0x44, 0x61, 0x74, 0x65, 0x3a, 0xaf, 0x02, 0xea, 0x41, 0xab, 0x02, 0x0a, 0x2b, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c,
	0x61, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x79, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0x12, 0x4e, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x79, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0x12, 0x5a, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65,
	0x70, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x7d, 0x2f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0x78, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x22, 0x54, 0x0a, 0x17, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x55, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x61,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6c, 0x61, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x99, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0d, 0x72, 0x65,
	0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xe6, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6f,
	0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x12, 0x56, 0x0a,
	0x0a, 0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4c, 0x6f, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x6c, 0x6f, 0x67, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x57, 0x0a, 0x12, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f,
	0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2b, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3c,
	0x0a, 0x09, 0x4c, 0x6f, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4c,
	0x4f, 0x47, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x43, 0x45, 0x4e,
	0x54, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x45, 0x53, 0x10, 0x01, 0x22, 0x5f, 0x0a, 0x0a,
	0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x44, 0x69, 0x66, 0x66, 0x12, 0x51, 0x0a, 0x0b, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x69, 0x66, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x44, 0x69, 0x66,
	0x66, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x69, 0x66, 0x66, 0x22, 0xcd, 0x03,
	0x0a, 0x0f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x44, 0x69, 0x66,
	0x66, 0x12, 0x4c, 0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x08, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12,
	0x4e, 0x0a, 0x09, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x09, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x66, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x44, 0x69, 0x66, 0x66, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0xb3, 0x01, 0x0a, 0x10, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e,
	0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x01, 0x12,
	0x12, 0x0a, 0x0e, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47,
	0x45, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x52, 0x45,
	0x56, 0x4f, 0x4b, 0x45, 0x44, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x5f, 0x47, 0x41, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x5f, 0x4d, 0x41, 0x59, 0x42, 0x45, 0x5f, 0x52, 0x45, 0x56, 0x4f, 0x4b,
	0x45, 0x44, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x4d,
	0x41, 0x59, 0x42, 0x45, 0x5f, 0x47, 0x41, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x06, 0x22, 0xdc, 0x01,
	0x0a, 0x0f, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x4f, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x4c, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x12, 0x2a, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x32, 0x81, 0x08, 0x0a,
	0x09, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x87, 0x02, 0x0a, 0x09, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x79, 0x22, 0x9d, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x8f, 0x01, 0x5a, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x73,
	0x2f, 0x2a, 0x7d, 0x5a, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70,
	0x6c, 0x61, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x02, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6c, 0x61, 0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe2, 0x01, 0xca, 0x41, 0x21,
	0x0a, 0x06, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x12, 0x17, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa7, 0x01, 0x3a, 0x06, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79,
	0x5a, 0x34, 0x3a, 0x06, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72,
	0x65, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x5a, 0x3a, 0x3a, 0x06, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79,
	0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x79, 0x73, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x12,
	0xca, 0x02, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x61, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbd, 0x01, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xad, 0x01, 0x5a,
	0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5a, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x52, 0xca, 0x41,
	0x1e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xf2, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x6f, 0x72, 0x70, 0x62, 0x3b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x73, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f,
	0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_policysimulator_v1_simulator_proto_rawDescOnce sync.Once
	file_google_cloud_policysimulator_v1_simulator_proto_rawDescData = file_google_cloud_policysimulator_v1_simulator_proto_rawDesc
)

func file_google_cloud_policysimulator_v1_simulator_proto_rawDescGZIP() []byte {
	file_google_cloud_policysimulator_v1_simulator_proto_rawDescOnce.Do(func() {
		file_google_cloud_policysimulator_v1_simulator_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_policysimulator_v1_simulator_proto_rawDescData)
	})
	return file_google_cloud_policysimulator_v1_simulator_proto_rawDescData
}

var file_google_cloud_policysimulator_v1_simulator_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_policysimulator_v1_simulator_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_policysimulator_v1_simulator_proto_goTypes = []interface{}{
	(Replay_State)(0),                     // 0: google.cloud.policysimulator.v1.Replay.State
	(ReplayConfig_LogSource)(0),           // 1: google.cloud.policysimulator.v1.ReplayConfig.LogSource
	(AccessStateDiff_AccessChangeType)(0), // 2: google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType
	(*Replay)(nil),                        // 3: google.cloud.policysimulator.v1.Replay
	(*ReplayResult)(nil),                  // 4: google.cloud.policysimulator.v1.ReplayResult
	(*CreateReplayRequest)(nil),           // 5: google.cloud.policysimulator.v1.CreateReplayRequest
	(*ReplayOperationMetadata)(nil),       // 6: google.cloud.policysimulator.v1.ReplayOperationMetadata
	(*GetReplayRequest)(nil),              // 7: google.cloud.policysimulator.v1.GetReplayRequest
	(*ListReplayResultsRequest)(nil),      // 8: google.cloud.policysimulator.v1.ListReplayResultsRequest
	(*ListReplayResultsResponse)(nil),     // 9: google.cloud.policysimulator.v1.ListReplayResultsResponse
	(*ReplayConfig)(nil),                  // 10: google.cloud.policysimulator.v1.ReplayConfig
	(*ReplayDiff)(nil),                    // 11: google.cloud.policysimulator.v1.ReplayDiff
	(*AccessStateDiff)(nil),               // 12: google.cloud.policysimulator.v1.AccessStateDiff
	(*ExplainedAccess)(nil),               // 13: google.cloud.policysimulator.v1.ExplainedAccess
	(*Replay_ResultsSummary)(nil),         // 14: google.cloud.policysimulator.v1.Replay.ResultsSummary
	nil,                                   // 15: google.cloud.policysimulator.v1.ReplayConfig.PolicyOverlayEntry
	(*status.Status)(nil),                 // 16: google.rpc.Status
	(*AccessTuple)(nil),                   // 17: google.cloud.policysimulator.v1.AccessTuple
	(*date.Date)(nil),                     // 18: google.type.Date
	(*timestamppb.Timestamp)(nil),         // 19: google.protobuf.Timestamp
	(AccessState)(0),                      // 20: google.cloud.policysimulator.v1.AccessState
	(*ExplainedPolicy)(nil),               // 21: google.cloud.policysimulator.v1.ExplainedPolicy
	(*iampb.Policy)(nil),                  // 22: google.iam.v1.Policy
	(*longrunningpb.Operation)(nil),       // 23: google.longrunning.Operation
}
var file_google_cloud_policysimulator_v1_simulator_proto_depIdxs = []int32{
	0,  // 0: google.cloud.policysimulator.v1.Replay.state:type_name -> google.cloud.policysimulator.v1.Replay.State
	10, // 1: google.cloud.policysimulator.v1.Replay.config:type_name -> google.cloud.policysimulator.v1.ReplayConfig
	14, // 2: google.cloud.policysimulator.v1.Replay.results_summary:type_name -> google.cloud.policysimulator.v1.Replay.ResultsSummary
	11, // 3: google.cloud.policysimulator.v1.ReplayResult.diff:type_name -> google.cloud.policysimulator.v1.ReplayDiff
	16, // 4: google.cloud.policysimulator.v1.ReplayResult.error:type_name -> google.rpc.Status
	17, // 5: google.cloud.policysimulator.v1.ReplayResult.access_tuple:type_name -> google.cloud.policysimulator.v1.AccessTuple
	18, // 6: google.cloud.policysimulator.v1.ReplayResult.last_seen_date:type_name -> google.type.Date
	3,  // 7: google.cloud.policysimulator.v1.CreateReplayRequest.replay:type_name -> google.cloud.policysimulator.v1.Replay
	19, // 8: google.cloud.policysimulator.v1.ReplayOperationMetadata.start_time:type_name -> google.protobuf.Timestamp
	4,  // 9: google.cloud.policysimulator.v1.ListReplayResultsResponse.replay_results:type_name -> google.cloud.policysimulator.v1.ReplayResult
	15, // 10: google.cloud.policysimulator.v1.ReplayConfig.policy_overlay:type_name -> google.cloud.policysimulator.v1.ReplayConfig.PolicyOverlayEntry
	1,  // 11: google.cloud.policysimulator.v1.ReplayConfig.log_source:type_name -> google.cloud.policysimulator.v1.ReplayConfig.LogSource
	12, // 12: google.cloud.policysimulator.v1.ReplayDiff.access_diff:type_name -> google.cloud.policysimulator.v1.AccessStateDiff
	13, // 13: google.cloud.policysimulator.v1.AccessStateDiff.baseline:type_name -> google.cloud.policysimulator.v1.ExplainedAccess
	13, // 14: google.cloud.policysimulator.v1.AccessStateDiff.simulated:type_name -> google.cloud.policysimulator.v1.ExplainedAccess
	2,  // 15: google.cloud.policysimulator.v1.AccessStateDiff.access_change:type_name -> google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType
	20, // 16: google.cloud.policysimulator.v1.ExplainedAccess.access_state:type_name -> google.cloud.policysimulator.v1.AccessState
	21, // 17: google.cloud.policysimulator.v1.ExplainedAccess.policies:type_name -> google.cloud.policysimulator.v1.ExplainedPolicy
	16, // 18: google.cloud.policysimulator.v1.ExplainedAccess.errors:type_name -> google.rpc.Status
	18, // 19: google.cloud.policysimulator.v1.Replay.ResultsSummary.oldest_date:type_name -> google.type.Date
	18, // 20: google.cloud.policysimulator.v1.Replay.ResultsSummary.newest_date:type_name -> google.type.Date
	22, // 21: google.cloud.policysimulator.v1.ReplayConfig.PolicyOverlayEntry.value:type_name -> google.iam.v1.Policy
	7,  // 22: google.cloud.policysimulator.v1.Simulator.GetReplay:input_type -> google.cloud.policysimulator.v1.GetReplayRequest
	5,  // 23: google.cloud.policysimulator.v1.Simulator.CreateReplay:input_type -> google.cloud.policysimulator.v1.CreateReplayRequest
	8,  // 24: google.cloud.policysimulator.v1.Simulator.ListReplayResults:input_type -> google.cloud.policysimulator.v1.ListReplayResultsRequest
	3,  // 25: google.cloud.policysimulator.v1.Simulator.GetReplay:output_type -> google.cloud.policysimulator.v1.Replay
	23, // 26: google.cloud.policysimulator.v1.Simulator.CreateReplay:output_type -> google.longrunning.Operation
	9,  // 27: google.cloud.policysimulator.v1.Simulator.ListReplayResults:output_type -> google.cloud.policysimulator.v1.ListReplayResultsResponse
	25, // [25:28] is the sub-list for method output_type
	22, // [22:25] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_cloud_policysimulator_v1_simulator_proto_init() }
func file_google_cloud_policysimulator_v1_simulator_proto_init() {
	if File_google_cloud_policysimulator_v1_simulator_proto != nil {
		return
	}
	file_google_cloud_policysimulator_v1_explanations_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Replay); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplayResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReplayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplayOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReplayRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReplayResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReplayResultsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplayConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplayDiff); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessStateDiff); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplainedAccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Replay_ResultsSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_policysimulator_v1_simulator_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ReplayResult_Diff)(nil),
		(*ReplayResult_Error)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_policysimulator_v1_simulator_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_policysimulator_v1_simulator_proto_goTypes,
		DependencyIndexes: file_google_cloud_policysimulator_v1_simulator_proto_depIdxs,
		EnumInfos:         file_google_cloud_policysimulator_v1_simulator_proto_enumTypes,
		MessageInfos:      file_google_cloud_policysimulator_v1_simulator_proto_msgTypes,
	}.Build()
	File_google_cloud_policysimulator_v1_simulator_proto = out.File
	file_google_cloud_policysimulator_v1_simulator_proto_rawDesc = nil
	file_google_cloud_policysimulator_v1_simulator_proto_goTypes = nil
	file_google_cloud_policysimulator_v1_simulator_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SimulatorClient is the client API for Simulator service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SimulatorClient interface {
	// Gets the specified [Replay][google.cloud.policysimulator.v1.Replay]. Each
	// `Replay` is available for at least 7 days.
	GetReplay(ctx context.Context, in *GetReplayRequest, opts ...grpc.CallOption) (*Replay, error)
	// Creates and starts a [Replay][google.cloud.policysimulator.v1.Replay] using
	// the given [ReplayConfig][google.cloud.policysimulator.v1.ReplayConfig].
	CreateReplay(ctx context.Context, in *CreateReplayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the results of running a
	// [Replay][google.cloud.policysimulator.v1.Replay].
	ListReplayResults(ctx context.Context, in *ListReplayResultsRequest, opts ...grpc.CallOption) (*ListReplayResultsResponse, error)
}

type simulatorClient struct {
	cc grpc.ClientConnInterface
}

func NewSimulatorClient(cc grpc.ClientConnInterface) SimulatorClient {
	return &simulatorClient{cc}
}

func (c *simulatorClient) GetReplay(ctx context.Context, in *GetReplayRequest, opts ...grpc.CallOption) (*Replay, error) {
	out := new(Replay)
	err := c.cc.Invoke(ctx, "/google.cloud.policysimulator.v1.Simulator/GetReplay", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *simulatorClient) CreateReplay(ctx context.Context, in *CreateReplayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.policysimulator.v1.Simulator/CreateReplay", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *simulatorClient) ListReplayResults(ctx context.Context, in *ListReplayResultsRequest, opts ...grpc.CallOption) (*ListReplayResultsResponse, error) {
	out := new(ListReplayResultsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.policysimulator.v1.Simulator/ListReplayResults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SimulatorServer is the server API for Simulator service.
type SimulatorServer interface {
	// Gets the specified [Replay][google.cloud.policysimulator.v1.Replay]. Each
	// `Replay` is available for at least 7 days.
	GetReplay(context.Context, *GetReplayRequest) (*Replay, error)
	// Creates and starts a [Replay][google.cloud.policysimulator.v1.Replay] using
	// the given [ReplayConfig][google.cloud.policysimulator.v1.ReplayConfig].
	CreateReplay(context.Context, *CreateReplayRequest) (*longrunningpb.Operation, error)
	// Lists the results of running a
	// [Replay][google.cloud.policysimulator.v1.Replay].
	ListReplayResults(context.Context, *ListReplayResultsRequest) (*ListReplayResultsResponse, error)
}

// UnimplementedSimulatorServer can be embedded to have forward compatible implementations.
type UnimplementedSimulatorServer struct {
}

func (*UnimplementedSimulatorServer) GetReplay(context.Context, *GetReplayRequest) (*Replay, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReplay not implemented")
}
func (*UnimplementedSimulatorServer) CreateReplay(context.Context, *CreateReplayRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReplay not implemented")
}
func (*UnimplementedSimulatorServer) ListReplayResults(context.Context, *ListReplayResultsRequest) (*ListReplayResultsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReplayResults not implemented")
}

func RegisterSimulatorServer(s *grpc.Server, srv SimulatorServer) {
	s.RegisterService(&_Simulator_serviceDesc, srv)
}

func _Simulator_GetReplay_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SimulatorServer).GetReplay(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.policysimulator.v1.Simulator/GetReplay",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SimulatorServer).GetReplay(ctx, req.(*GetReplayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Simulator_CreateReplay_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReplayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SimulatorServer).CreateReplay(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.policysimulator.v1.Simulator/CreateReplay",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SimulatorServer).CreateReplay(ctx, req.(*CreateReplayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Simulator_ListReplayResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReplayResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SimulatorServer).ListReplayResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.policysimulator.v1.Simulator/ListReplayResults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SimulatorServer).ListReplayResults(ctx, req.(*ListReplayResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Simulator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.policysimulator.v1.Simulator",
	HandlerType: (*SimulatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetReplay",
			Handler:    _Simulator_GetReplay_Handler,
		},
		{
			MethodName: "CreateReplay",
			Handler:    _Simulator_CreateReplay_Handler,
		},
		{
			MethodName: "ListReplayResults",
			Handler:    _Simulator_ListReplayResults_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/policysimulator/v1/simulator.proto",
}
