/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWindowPostMessageOptions.h"

#include "JSDOMConvertObject.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WindowPostMessageOptions>> convertDictionary<WindowPostMessageOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WindowPostMessageOptions result;
    JSValue transferValue;
    if (isNullOrUndefined)
        transferValue = jsUndefined();
    else {
        transferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transfer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto transferConversionResult = convertOptionalWithDefault<IDLSequence<IDLObject>>(lexicalGlobalObject, transferValue, [&]() -> ConversionResult<IDLSequence<IDLObject>> { return Converter<IDLSequence<IDLObject>>::ReturnType { }; });
    if (UNLIKELY(transferConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.transfer = transferConversionResult.releaseReturnValue();
    JSValue targetOriginValue;
    if (isNullOrUndefined)
        targetOriginValue = jsUndefined();
    else {
        targetOriginValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetOrigin"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto targetOriginConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, targetOriginValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { "/"_s }; });
    if (UNLIKELY(targetOriginConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.targetOrigin = targetOriginConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
