/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsAudioEncoder.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSWebCodecsAudioData.h"
#include "JSWebCodecsAudioEncoderConfig.h"
#include "JSWebCodecsAudioEncoderSupport.h"
#include "JSWebCodecsCodecState.h"
#include "JSWebCodecsEncodedAudioChunkOutputCallback.h"
#include "JSWebCodecsErrorCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> ConversionResult<IDLDictionary<WebCodecsAudioEncoder::Init>> convertDictionary<WebCodecsAudioEncoder::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebCodecsAudioEncoder::Init result;
    JSValue errorValue;
    if (isNullOrUndefined)
        errorValue = jsUndefined();
    else {
        errorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "error"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (errorValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "error"_s, "WebCodecsAudioEncoderInit"_s, "WebCodecsErrorCallback"_s);
        return ConversionResultException { };
    }
    auto errorConversionResult = convert<IDLCallbackFunction<JSWebCodecsErrorCallback>>(lexicalGlobalObject, errorValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
    if (UNLIKELY(errorConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.error = errorConversionResult.releaseReturnValue();
    JSValue outputValue;
    if (isNullOrUndefined)
        outputValue = jsUndefined();
    else {
        outputValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "output"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (outputValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "output"_s, "WebCodecsAudioEncoderInit"_s, "WebCodecsEncodedAudioChunkOutputCallback"_s);
        return ConversionResultException { };
    }
    auto outputConversionResult = convert<IDLCallbackFunction<JSWebCodecsEncodedAudioChunkOutputCallback>>(lexicalGlobalObject, outputValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
    if (UNLIKELY(outputConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.output = outputConversionResult.releaseReturnValue();
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_configure);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_encode);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_flush);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_reset);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioEncoderConstructorFunction_isConfigSupported);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioEncoder_state);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioEncoder_encodeQueueSize);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioEncoder_ondequeue);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebCodecsAudioEncoder_ondequeue);

class JSWebCodecsAudioEncoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebCodecsAudioEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebCodecsAudioEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebCodecsAudioEncoderPrototype>(vm)) JSWebCodecsAudioEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsAudioEncoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebCodecsAudioEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsAudioEncoderPrototype, JSWebCodecsAudioEncoderPrototype::Base);

using JSWebCodecsAudioEncoderDOMConstructor = JSDOMConstructor<JSWebCodecsAudioEncoder>;

/* Hash table for constructor */

static const HashTableValue JSWebCodecsAudioEncoderConstructorTableValues[] =
{
    { "isConfigSupported"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioEncoderConstructorFunction_isConfigSupported, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebCodecsAudioEncoderDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsAudioEncoderDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "AudioEncoder"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto initConversionResult = convert<IDLDictionary<WebCodecsAudioEncoder::Init>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(initConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = WebCodecsAudioEncoder::create(*context, initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsAudioEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsAudioEncoder>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebCodecsAudioEncoderDOMConstructorConstruct, JSWebCodecsAudioEncoderDOMConstructor::construct);

template<> const ClassInfo JSWebCodecsAudioEncoderDOMConstructor::s_info = { "AudioEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioEncoderDOMConstructor) };

template<> JSValue JSWebCodecsAudioEncoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWebCodecsAudioEncoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioEncoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebCodecsAudioEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSWebCodecsAudioEncoder::info(), JSWebCodecsAudioEncoderConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSWebCodecsAudioEncoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioEncoderConstructor, 0 } },
    { "state"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioEncoder_state, 0 } },
    { "encodeQueueSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioEncoder_encodeQueueSize, 0 } },
    { "ondequeue"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioEncoder_ondequeue, setJSWebCodecsAudioEncoder_ondequeue } },
    { "configure"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioEncoderPrototypeFunction_configure, 1 } },
    { "encode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioEncoderPrototypeFunction_encode, 1 } },
    { "flush"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioEncoderPrototypeFunction_flush, 0 } },
    { "reset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioEncoderPrototypeFunction_reset, 0 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioEncoderPrototypeFunction_close, 0 } },
};

const ClassInfo JSWebCodecsAudioEncoderPrototype::s_info = { "AudioEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioEncoderPrototype) };

void JSWebCodecsAudioEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebCodecsAudioEncoder::info(), JSWebCodecsAudioEncoderPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebCodecsAudioEncoder::s_info = { "AudioEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioEncoder) };

JSWebCodecsAudioEncoder::JSWebCodecsAudioEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebCodecsAudioEncoder>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<WebCodecsAudioEncoder> JSWebCodecsAudioEncoder::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, WebCodecsAudioEncoder>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSWebCodecsAudioEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebCodecsAudioEncoderPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWebCodecsAudioEncoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebCodecsAudioEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebCodecsAudioEncoder>(vm, globalObject);
}

JSValue JSWebCodecsAudioEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebCodecsAudioEncoderDOMConstructor, DOMConstructorID::WebCodecsAudioEncoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebCodecsAudioEncoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebCodecsAudioEncoder::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWebCodecsAudioEncoder_stateGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioEncoder& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebCodecsCodecState>>(lexicalGlobalObject, throwScope, impl.state())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioEncoder_state, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioEncoder>::get<jsWebCodecsAudioEncoder_stateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioEncoder_encodeQueueSizeGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioEncoder& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.encodeQueueSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioEncoder_encodeQueueSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioEncoder>::get<jsWebCodecsAudioEncoder_encodeQueueSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioEncoder_ondequeueGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioEncoder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dequeueEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioEncoder_ondequeue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioEncoder>::get<jsWebCodecsAudioEncoder_ondequeueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebCodecsAudioEncoder_ondequeueSetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioEncoder& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dequeueEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebCodecsAudioEncoder_ondequeue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioEncoder>::set<setJSWebCodecsAudioEncoder_ondequeueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebCodecsAudioEncoderPrototypeFunction_configureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configConversionResult = convert<IDLDictionary<WebCodecsAudioEncoderConfig>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(configConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.configure(*context, configConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_configure, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioEncoder>::call<jsWebCodecsAudioEncoderPrototypeFunction_configureBody>(*lexicalGlobalObject, *callFrame, "configure");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioEncoderPrototypeFunction_encodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLInterface<WebCodecsAudioData>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "data"_s, "AudioEncoder"_s, "encode"_s, "WebCodecsAudioData"_s); });
    if (UNLIKELY(dataConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.encode(*dataConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_encode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioEncoder>::call<jsWebCodecsAudioEncoderPrototypeFunction_encodeBody>(*lexicalGlobalObject, *callFrame, "encode");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioEncoderPrototypeFunction_flushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebCodecsAudioEncoder>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.flush(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_flush, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebCodecsAudioEncoder>::call<jsWebCodecsAudioEncoderPrototypeFunction_flushBody>(*lexicalGlobalObject, *callFrame, "flush");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioEncoderPrototypeFunction_resetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.reset(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_reset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioEncoder>::call<jsWebCodecsAudioEncoderPrototypeFunction_resetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioEncoderPrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioEncoderPrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioEncoder>::call<jsWebCodecsAudioEncoderPrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioEncoderConstructorFunction_isConfigSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configConversionResult = convert<IDLDictionary<WebCodecsAudioEncoderConfig>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(configConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<WebCodecsAudioEncoderSupport>>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, [&]() -> decltype(auto) { return WebCodecsAudioEncoder::isConfigSupported(*context, configConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioEncoderConstructorFunction_isConfigSupported, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebCodecsAudioEncoder>::callStatic<jsWebCodecsAudioEncoderConstructorFunction_isConfigSupportedBody>(*lexicalGlobalObject, *callFrame, "isConfigSupported");
}

JSC::GCClient::IsoSubspace* JSWebCodecsAudioEncoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebCodecsAudioEncoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebCodecsAudioEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebCodecsAudioEncoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebCodecsAudioEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebCodecsAudioEncoder = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSWebCodecsAudioEncoder::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebCodecsAudioEncoder*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSWebCodecsAudioEncoder);

template<typename Visitor>
void JSWebCodecsAudioEncoder::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebCodecsAudioEncoder*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSWebCodecsAudioEncoder::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSWebCodecsAudioEncoder::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSWebCodecsAudioEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebCodecsAudioEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebCodecsAudioEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsWebCodecsAudioEncoder = jsCast<JSWebCodecsAudioEncoder*>(handle.slot()->asCell());
    auto& wrapped = jsWebCodecsAudioEncoder->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebCodecsAudioEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebCodecsAudioEncoder = static_cast<JSWebCodecsAudioEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebCodecsAudioEncoder->protectedWrapped().ptr(), jsWebCodecsAudioEncoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebCodecsAudioEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21WebCodecsAudioEncoderE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebCodecsAudioEncoder>, void>> static inline void verifyVTable(WebCodecsAudioEncoder* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebCodecsAudioEncoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21WebCodecsAudioEncoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebCodecsAudioEncoder has subclasses. If WebCodecsAudioEncoder has subclasses that get passed
        // to toJS() we currently require WebCodecsAudioEncoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebCodecsAudioEncoder>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebCodecsAudioEncoder>(impl.ptr());
#endif
    return createWrapper<WebCodecsAudioEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebCodecsAudioEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebCodecsAudioEncoder* JSWebCodecsAudioEncoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebCodecsAudioEncoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_CODECS)
