/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsAudioDecoder.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSWebCodecsAudioDataOutputCallback.h"
#include "JSWebCodecsAudioDecoderConfig.h"
#include "JSWebCodecsAudioDecoderSupport.h"
#include "JSWebCodecsCodecState.h"
#include "JSWebCodecsEncodedAudioChunk.h"
#include "JSWebCodecsErrorCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> ConversionResult<IDLDictionary<WebCodecsAudioDecoder::Init>> convertDictionary<WebCodecsAudioDecoder::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebCodecsAudioDecoder::Init result;
    JSValue errorValue;
    if (isNullOrUndefined)
        errorValue = jsUndefined();
    else {
        errorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "error"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (errorValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "error"_s, "WebCodecsAudioDecoderInit"_s, "WebCodecsErrorCallback"_s);
        return ConversionResultException { };
    }
    auto errorConversionResult = convert<IDLCallbackFunction<JSWebCodecsErrorCallback>>(lexicalGlobalObject, errorValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
    if (UNLIKELY(errorConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.error = errorConversionResult.releaseReturnValue();
    JSValue outputValue;
    if (isNullOrUndefined)
        outputValue = jsUndefined();
    else {
        outputValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "output"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (outputValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "output"_s, "WebCodecsAudioDecoderInit"_s, "WebCodecsAudioDataOutputCallback"_s);
        return ConversionResultException { };
    }
    auto outputConversionResult = convert<IDLCallbackFunction<JSWebCodecsAudioDataOutputCallback>>(lexicalGlobalObject, outputValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
    if (UNLIKELY(outputConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.output = outputConversionResult.releaseReturnValue();
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_configure);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_decode);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_flush);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_reset);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsAudioDecoderConstructorFunction_isConfigSupported);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioDecoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioDecoder_state);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioDecoder_decodeQueueSize);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsAudioDecoder_ondequeue);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebCodecsAudioDecoder_ondequeue);

class JSWebCodecsAudioDecoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebCodecsAudioDecoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebCodecsAudioDecoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebCodecsAudioDecoderPrototype>(vm)) JSWebCodecsAudioDecoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsAudioDecoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebCodecsAudioDecoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsAudioDecoderPrototype, JSWebCodecsAudioDecoderPrototype::Base);

using JSWebCodecsAudioDecoderDOMConstructor = JSDOMConstructor<JSWebCodecsAudioDecoder>;

/* Hash table for constructor */

static const HashTableValue JSWebCodecsAudioDecoderConstructorTableValues[] =
{
    { "isConfigSupported"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDecoderConstructorFunction_isConfigSupported, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebCodecsAudioDecoderDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsAudioDecoderDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "AudioDecoder"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto initConversionResult = convert<IDLDictionary<WebCodecsAudioDecoder::Init>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(initConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = WebCodecsAudioDecoder::create(*context, initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsAudioDecoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsAudioDecoder>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebCodecsAudioDecoderDOMConstructorConstruct, JSWebCodecsAudioDecoderDOMConstructor::construct);

template<> const ClassInfo JSWebCodecsAudioDecoderDOMConstructor::s_info = { "AudioDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioDecoderDOMConstructor) };

template<> JSValue JSWebCodecsAudioDecoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWebCodecsAudioDecoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioDecoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebCodecsAudioDecoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSWebCodecsAudioDecoder::info(), JSWebCodecsAudioDecoderConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSWebCodecsAudioDecoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioDecoderConstructor, 0 } },
    { "state"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioDecoder_state, 0 } },
    { "decodeQueueSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioDecoder_decodeQueueSize, 0 } },
    { "ondequeue"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsAudioDecoder_ondequeue, setJSWebCodecsAudioDecoder_ondequeue } },
    { "configure"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDecoderPrototypeFunction_configure, 1 } },
    { "decode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDecoderPrototypeFunction_decode, 1 } },
    { "flush"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDecoderPrototypeFunction_flush, 0 } },
    { "reset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDecoderPrototypeFunction_reset, 0 } },
    { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsAudioDecoderPrototypeFunction_close, 0 } },
};

const ClassInfo JSWebCodecsAudioDecoderPrototype::s_info = { "AudioDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioDecoderPrototype) };

void JSWebCodecsAudioDecoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebCodecsAudioDecoder::info(), JSWebCodecsAudioDecoderPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebCodecsAudioDecoder::s_info = { "AudioDecoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsAudioDecoder) };

JSWebCodecsAudioDecoder::JSWebCodecsAudioDecoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebCodecsAudioDecoder>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<WebCodecsAudioDecoder> JSWebCodecsAudioDecoder::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, WebCodecsAudioDecoder>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSWebCodecsAudioDecoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebCodecsAudioDecoderPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWebCodecsAudioDecoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebCodecsAudioDecoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebCodecsAudioDecoder>(vm, globalObject);
}

JSValue JSWebCodecsAudioDecoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebCodecsAudioDecoderDOMConstructor, DOMConstructorID::WebCodecsAudioDecoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioDecoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebCodecsAudioDecoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebCodecsAudioDecoder::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWebCodecsAudioDecoder_stateGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioDecoder& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebCodecsCodecState>>(lexicalGlobalObject, throwScope, impl.state())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioDecoder_state, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioDecoder>::get<jsWebCodecsAudioDecoder_stateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioDecoder_decodeQueueSizeGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioDecoder& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.decodeQueueSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioDecoder_decodeQueueSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioDecoder>::get<jsWebCodecsAudioDecoder_decodeQueueSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsAudioDecoder_ondequeueGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioDecoder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dequeueEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsAudioDecoder_ondequeue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioDecoder>::get<jsWebCodecsAudioDecoder_ondequeueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebCodecsAudioDecoder_ondequeueSetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsAudioDecoder& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dequeueEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebCodecsAudioDecoder_ondequeue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsAudioDecoder>::set<setJSWebCodecsAudioDecoder_ondequeueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDecoderPrototypeFunction_configureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configConversionResult = convert<IDLDictionary<WebCodecsAudioDecoderConfig>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(configConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.configure(*context, configConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_configure, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioDecoder>::call<jsWebCodecsAudioDecoderPrototypeFunction_configureBody>(*lexicalGlobalObject, *callFrame, "configure");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDecoderPrototypeFunction_decodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto chunkConversionResult = convert<IDLInterface<WebCodecsEncodedAudioChunk>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "chunk"_s, "AudioDecoder"_s, "decode"_s, "WebCodecsEncodedAudioChunk"_s); });
    if (UNLIKELY(chunkConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.decode(*chunkConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_decode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioDecoder>::call<jsWebCodecsAudioDecoderPrototypeFunction_decodeBody>(*lexicalGlobalObject, *callFrame, "decode");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDecoderPrototypeFunction_flushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebCodecsAudioDecoder>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.flush(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_flush, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebCodecsAudioDecoder>::call<jsWebCodecsAudioDecoderPrototypeFunction_flushBody>(*lexicalGlobalObject, *callFrame, "flush");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDecoderPrototypeFunction_resetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.reset(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_reset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioDecoder>::call<jsWebCodecsAudioDecoderPrototypeFunction_resetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDecoderPrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsAudioDecoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDecoderPrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsAudioDecoder>::call<jsWebCodecsAudioDecoderPrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsWebCodecsAudioDecoderConstructorFunction_isConfigSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto configConversionResult = convert<IDLDictionary<WebCodecsAudioDecoderConfig>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(configConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<WebCodecsAudioDecoderSupport>>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, [&]() -> decltype(auto) { return WebCodecsAudioDecoder::isConfigSupported(*context, configConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsAudioDecoderConstructorFunction_isConfigSupported, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebCodecsAudioDecoder>::callStatic<jsWebCodecsAudioDecoderConstructorFunction_isConfigSupportedBody>(*lexicalGlobalObject, *callFrame, "isConfigSupported");
}

JSC::GCClient::IsoSubspace* JSWebCodecsAudioDecoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebCodecsAudioDecoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebCodecsAudioDecoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebCodecsAudioDecoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebCodecsAudioDecoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebCodecsAudioDecoder = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSWebCodecsAudioDecoder::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebCodecsAudioDecoder*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSWebCodecsAudioDecoder);

template<typename Visitor>
void JSWebCodecsAudioDecoder::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSWebCodecsAudioDecoder*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSWebCodecsAudioDecoder::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSWebCodecsAudioDecoder::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSWebCodecsAudioDecoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebCodecsAudioDecoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebCodecsAudioDecoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsWebCodecsAudioDecoder = jsCast<JSWebCodecsAudioDecoder*>(handle.slot()->asCell());
    auto& wrapped = jsWebCodecsAudioDecoder->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebCodecsAudioDecoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebCodecsAudioDecoder = static_cast<JSWebCodecsAudioDecoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebCodecsAudioDecoder->protectedWrapped().ptr(), jsWebCodecsAudioDecoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebCodecsAudioDecoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21WebCodecsAudioDecoderE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebCodecsAudioDecoder>, void>> static inline void verifyVTable(WebCodecsAudioDecoder* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebCodecsAudioDecoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21WebCodecsAudioDecoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebCodecsAudioDecoder has subclasses. If WebCodecsAudioDecoder has subclasses that get passed
        // to toJS() we currently require WebCodecsAudioDecoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebCodecsAudioDecoder>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebCodecsAudioDecoder>(impl.ptr());
#endif
    return createWrapper<WebCodecsAudioDecoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebCodecsAudioDecoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebCodecsAudioDecoder* JSWebCodecsAudioDecoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebCodecsAudioDecoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_CODECS)
