/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoTrackConfiguration.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSVideoColorSpace.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackConfigurationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackConfiguration_codec);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackConfiguration_width);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackConfiguration_height);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackConfiguration_bitrate);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackConfiguration_framerate);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackConfiguration_colorSpace);

class JSVideoTrackConfigurationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVideoTrackConfigurationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoTrackConfigurationPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoTrackConfigurationPrototype>(vm)) JSVideoTrackConfigurationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoTrackConfigurationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoTrackConfigurationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoTrackConfigurationPrototype, JSVideoTrackConfigurationPrototype::Base);

using JSVideoTrackConfigurationDOMConstructor = JSDOMConstructorNotConstructable<JSVideoTrackConfiguration>;

template<> const ClassInfo JSVideoTrackConfigurationDOMConstructor::s_info = { "VideoTrackConfiguration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackConfigurationDOMConstructor) };

template<> JSValue JSVideoTrackConfigurationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSVideoTrackConfigurationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "VideoTrackConfiguration"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSVideoTrackConfiguration::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSVideoTrackConfigurationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackConfigurationConstructor, 0 } },
    { "codec"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackConfiguration_codec, 0 } },
    { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackConfiguration_width, 0 } },
    { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackConfiguration_height, 0 } },
    { "bitrate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackConfiguration_bitrate, 0 } },
    { "framerate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackConfiguration_framerate, 0 } },
    { "colorSpace"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackConfiguration_colorSpace, 0 } },
};

const ClassInfo JSVideoTrackConfigurationPrototype::s_info = { "VideoTrackConfiguration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackConfigurationPrototype) };

void JSVideoTrackConfigurationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoTrackConfiguration::info(), JSVideoTrackConfigurationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSVideoTrackConfiguration::s_info = { "VideoTrackConfiguration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackConfiguration) };

JSVideoTrackConfiguration::JSVideoTrackConfiguration(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoTrackConfiguration>&& impl)
    : JSDOMWrapper<VideoTrackConfiguration>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, VideoTrackConfiguration>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSVideoTrackConfiguration::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSVideoTrackConfigurationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSVideoTrackConfigurationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSVideoTrackConfiguration::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVideoTrackConfiguration>(vm, globalObject);
}

JSValue JSVideoTrackConfiguration::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVideoTrackConfigurationDOMConstructor, DOMConstructorID::VideoTrackConfiguration>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSVideoTrackConfiguration::destroy(JSC::JSCell* cell)
{
    JSVideoTrackConfiguration* thisObject = static_cast<JSVideoTrackConfiguration*>(cell);
    thisObject->JSVideoTrackConfiguration::~JSVideoTrackConfiguration();
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackConfigurationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVideoTrackConfigurationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVideoTrackConfiguration::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsVideoTrackConfiguration_codecGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.codec())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackConfiguration_codec, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackConfiguration>::get<jsVideoTrackConfiguration_codecGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrackConfiguration_widthGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackConfiguration_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackConfiguration>::get<jsVideoTrackConfiguration_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrackConfiguration_heightGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackConfiguration_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackConfiguration>::get<jsVideoTrackConfiguration_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrackConfiguration_bitrateGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.bitrate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackConfiguration_bitrate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackConfiguration>::get<jsVideoTrackConfiguration_bitrateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrackConfiguration_framerateGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.framerate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackConfiguration_framerate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackConfiguration>::get<jsVideoTrackConfiguration_framerateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrackConfiguration_colorSpaceGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<VideoColorSpace>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.colorSpace())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackConfiguration_colorSpace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrackConfiguration>::get<jsVideoTrackConfiguration_colorSpaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSVideoTrackConfiguration::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSVideoTrackConfiguration, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForVideoTrackConfiguration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForVideoTrackConfiguration = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForVideoTrackConfiguration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForVideoTrackConfiguration = std::forward<decltype(space)>(space); }
    );
}

void JSVideoTrackConfiguration::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVideoTrackConfiguration*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSVideoTrackConfigurationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSVideoTrackConfigurationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoTrackConfiguration = static_cast<JSVideoTrackConfiguration*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsVideoTrackConfiguration->protectedWrapped().ptr(), jsVideoTrackConfiguration);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VideoTrackConfiguration@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23VideoTrackConfigurationE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, VideoTrackConfiguration>, void>> static inline void verifyVTable(VideoTrackConfiguration* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7VideoTrackConfiguration@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore23VideoTrackConfigurationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // VideoTrackConfiguration has subclasses. If VideoTrackConfiguration has subclasses that get passed
        // to toJS() we currently require VideoTrackConfiguration you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VideoTrackConfiguration>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<VideoTrackConfiguration>(impl.ptr());
#endif
    return createWrapper<VideoTrackConfiguration>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VideoTrackConfiguration& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VideoTrackConfiguration* JSVideoTrackConfiguration::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoTrackConfiguration*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
