/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRequestPriority.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RequestPriority enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("high"),
        MAKE_STATIC_STRING_IMPL("low"),
        MAKE_STATIC_STRING_IMPL("auto"),
    };
    static_assert(static_cast<size_t>(RequestPriority::High) == 0, "RequestPriority::High is not 0 as expected");
    static_assert(static_cast<size_t>(RequestPriority::Low) == 1, "RequestPriority::Low is not 1 as expected");
    static_assert(static_cast<size_t>(RequestPriority::Auto) == 2, "RequestPriority::Auto is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, RequestPriority enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<RequestPriority> parseEnumerationFromString<RequestPriority>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, RequestPriority> mappings[] = {
        { "auto", RequestPriority::Auto },
        { "high", RequestPriority::High },
        { "low", RequestPriority::Low },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<RequestPriority> parseEnumeration<RequestPriority>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<RequestPriority>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<RequestPriority>()
{
    return "\"high\", \"low\", \"auto\""_s;
}

} // namespace WebCore
