/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSPhotoCapabilities.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMGlobalObject.h"
#include "JSFillLightMode.h"
#include "JSMediaSettingsRange.h"
#include "JSRedEyeReduction.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const PhotoCapabilities& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLSequence<IDLEnumeration<FillLightMode>>::isNullValue(dictionary.fillLightMode)) {
        auto fillLightModeValue = toJS<IDLSequence<IDLEnumeration<FillLightMode>>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLEnumeration<FillLightMode>>::extractValueFromNullable(dictionary.fillLightMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fillLightMode"_s), fillLightModeValue);
    }
    if (!IDLDictionary<MediaSettingsRange>::isNullValue(dictionary.imageHeight)) {
        auto imageHeightValue = toJS<IDLDictionary<MediaSettingsRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<MediaSettingsRange>::extractValueFromNullable(dictionary.imageHeight));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "imageHeight"_s), imageHeightValue);
    }
    if (!IDLDictionary<MediaSettingsRange>::isNullValue(dictionary.imageWidth)) {
        auto imageWidthValue = toJS<IDLDictionary<MediaSettingsRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<MediaSettingsRange>::extractValueFromNullable(dictionary.imageWidth));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "imageWidth"_s), imageWidthValue);
    }
    if (!IDLEnumeration<RedEyeReduction>::isNullValue(dictionary.redEyeReduction)) {
        auto redEyeReductionValue = toJS<IDLEnumeration<RedEyeReduction>>(lexicalGlobalObject, throwScope, IDLEnumeration<RedEyeReduction>::extractValueFromNullable(dictionary.redEyeReduction));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "redEyeReduction"_s), redEyeReductionValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(MEDIA_STREAM)
