/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCheckVisibilityOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CheckVisibilityOptions>> convertDictionary<CheckVisibilityOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CheckVisibilityOptions result;
    JSValue checkOpacityValue;
    if (isNullOrUndefined)
        checkOpacityValue = jsUndefined();
    else {
        checkOpacityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "checkOpacity"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto checkOpacityConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, checkOpacityValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(checkOpacityConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.checkOpacity = checkOpacityConversionResult.releaseReturnValue();
    JSValue checkVisibilityCSSValue;
    if (isNullOrUndefined)
        checkVisibilityCSSValue = jsUndefined();
    else {
        checkVisibilityCSSValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "checkVisibilityCSS"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto checkVisibilityCSSConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, checkVisibilityCSSValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(checkVisibilityCSSConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.checkVisibilityCSS = checkVisibilityCSSConversionResult.releaseReturnValue();
    JSValue contentVisibilityAutoValue;
    if (isNullOrUndefined)
        contentVisibilityAutoValue = jsUndefined();
    else {
        contentVisibilityAutoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "contentVisibilityAuto"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto contentVisibilityAutoConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, contentVisibilityAutoValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(contentVisibilityAutoConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.contentVisibilityAuto = contentVisibilityAutoConversionResult.releaseReturnValue();
    JSValue opacityPropertyValue;
    if (isNullOrUndefined)
        opacityPropertyValue = jsUndefined();
    else {
        opacityPropertyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "opacityProperty"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto opacityPropertyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, opacityPropertyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(opacityPropertyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.opacityProperty = opacityPropertyConversionResult.releaseReturnValue();
    JSValue visibilityPropertyValue;
    if (isNullOrUndefined)
        visibilityPropertyValue = jsUndefined();
    else {
        visibilityPropertyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "visibilityProperty"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto visibilityPropertyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, visibilityPropertyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(visibilityPropertyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.visibilityProperty = visibilityPropertyConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
