/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(XSLT)

#include "JSXSLTProcessor.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_importStylesheet);
static JSC_DECLARE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_transformToFragment);
static JSC_DECLARE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_transformToDocument);
static JSC_DECLARE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_setParameter);
static JSC_DECLARE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_getParameter);
static JSC_DECLARE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_removeParameter);
static JSC_DECLARE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_clearParameters);
static JSC_DECLARE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_reset);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXSLTProcessorConstructor);

class JSXSLTProcessorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXSLTProcessorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXSLTProcessorPrototype* ptr = new (NotNull, JSC::allocateCell<JSXSLTProcessorPrototype>(vm)) JSXSLTProcessorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXSLTProcessorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXSLTProcessorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXSLTProcessorPrototype, JSXSLTProcessorPrototype::Base);

using JSXSLTProcessorDOMConstructor = JSDOMConstructor<JSXSLTProcessor>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSXSLTProcessorDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSXSLTProcessorDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto object = XSLTProcessor::create();
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<XSLTProcessor>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<XSLTProcessor>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSXSLTProcessorDOMConstructorConstruct, JSXSLTProcessorDOMConstructor::construct);

template<> const ClassInfo JSXSLTProcessorDOMConstructor::s_info = { "XSLTProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXSLTProcessorDOMConstructor) };

template<> JSValue JSXSLTProcessorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXSLTProcessorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XSLTProcessor"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXSLTProcessor::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSXSLTProcessorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXSLTProcessorConstructor, 0 } },
    { "importStylesheet"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXSLTProcessorPrototypeFunction_importStylesheet, 1 } },
    { "transformToFragment"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXSLTProcessorPrototypeFunction_transformToFragment, 2 } },
    { "transformToDocument"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXSLTProcessorPrototypeFunction_transformToDocument, 1 } },
    { "setParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXSLTProcessorPrototypeFunction_setParameter, 3 } },
    { "getParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXSLTProcessorPrototypeFunction_getParameter, 2 } },
    { "removeParameter"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXSLTProcessorPrototypeFunction_removeParameter, 2 } },
    { "clearParameters"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXSLTProcessorPrototypeFunction_clearParameters, 0 } },
    { "reset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXSLTProcessorPrototypeFunction_reset, 0 } },
};

const ClassInfo JSXSLTProcessorPrototype::s_info = { "XSLTProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXSLTProcessorPrototype) };

void JSXSLTProcessorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXSLTProcessor::info(), JSXSLTProcessorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXSLTProcessor::s_info = { "XSLTProcessor"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXSLTProcessor) };

JSXSLTProcessor::JSXSLTProcessor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XSLTProcessor>&& impl)
    : JSDOMWrapper<XSLTProcessor>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, XSLTProcessor>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSXSLTProcessor::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXSLTProcessorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSXSLTProcessorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXSLTProcessor::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXSLTProcessor>(vm, globalObject);
}

JSValue JSXSLTProcessor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXSLTProcessorDOMConstructor, DOMConstructorID::XSLTProcessor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSXSLTProcessor::destroy(JSC::JSCell* cell)
{
    JSXSLTProcessor* thisObject = static_cast<JSXSLTProcessor*>(cell);
    thisObject->JSXSLTProcessor::~JSXSLTProcessor();
}

JSC_DEFINE_CUSTOM_GETTER(jsXSLTProcessorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXSLTProcessorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXSLTProcessor::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunction_importStylesheetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto style = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "style", "XSLTProcessor", "importStylesheet", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.importStylesheet(*style); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_importStylesheet, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunction_importStylesheetBody>(*lexicalGlobalObject, *callFrame, "importStylesheet");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunction_transformToFragmentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto source = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "source", "XSLTProcessor", "transformToFragment", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto output = convert<IDLInterface<Document>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "output", "XSLTProcessor", "transformToFragment", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<DocumentFragment>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.transformToFragment(*source, *output))));
}

JSC_DEFINE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_transformToFragment, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunction_transformToFragmentBody>(*lexicalGlobalObject, *callFrame, "transformToFragment");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunction_transformToDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto source = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "source", "XSLTProcessor", "transformToDocument", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Document>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.transformToDocument(*source))));
}

JSC_DEFINE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_transformToDocument, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunction_transformToDocumentBody>(*lexicalGlobalObject, *callFrame, "transformToDocument");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunction_setParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURI = convert<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto value = convert<IDLDOMString>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setParameter(WTFMove(namespaceURI), WTFMove(localName), WTFMove(value)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_setParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunction_setParameterBody>(*lexicalGlobalObject, *callFrame, "setParameter");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunction_getParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURI = convert<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.getParameter(WTFMove(namespaceURI), WTFMove(localName)))));
}

JSC_DEFINE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_getParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunction_getParameterBody>(*lexicalGlobalObject, *callFrame, "getParameter");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunction_removeParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURI = convert<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.removeParameter(WTFMove(namespaceURI), WTFMove(localName)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_removeParameter, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunction_removeParameterBody>(*lexicalGlobalObject, *callFrame, "removeParameter");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunction_clearParametersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearParameters(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_clearParameters, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunction_clearParametersBody>(*lexicalGlobalObject, *callFrame, "clearParameters");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunction_resetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.reset(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsXSLTProcessorPrototypeFunction_reset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunction_resetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

JSC::GCClient::IsoSubspace* JSXSLTProcessor::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXSLTProcessor, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXSLTProcessor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXSLTProcessor = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXSLTProcessor.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXSLTProcessor = std::forward<decltype(space)>(space); }
    );
}

void JSXSLTProcessor::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXSLTProcessor*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXSLTProcessorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXSLTProcessorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXSLTProcessor = static_cast<JSXSLTProcessor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXSLTProcessor->wrapped(), jsXSLTProcessor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XSLTProcessor@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13XSLTProcessorE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XSLTProcessor>&& impl)
{

    if constexpr (std::is_polymorphic_v<XSLTProcessor>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7XSLTProcessor@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13XSLTProcessorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // XSLTProcessor has subclasses. If XSLTProcessor has subclasses that get passed
        // to toJS() we currently require XSLTProcessor you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<XSLTProcessor>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XSLTProcessor& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XSLTProcessor* JSXSLTProcessor::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXSLTProcessor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(XSLT)
