/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLVertexArrayObjectOES.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLVertexArrayObjectOESPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLVertexArrayObjectOESPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLVertexArrayObjectOESPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLVertexArrayObjectOESPrototype>(vm)) JSWebGLVertexArrayObjectOESPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLVertexArrayObjectOESPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLVertexArrayObjectOESPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLVertexArrayObjectOESPrototype, JSWebGLVertexArrayObjectOESPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSWebGLVertexArrayObjectOESPrototype::s_info = { "WebGLVertexArrayObjectOES"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLVertexArrayObjectOESPrototype) };

void JSWebGLVertexArrayObjectOESPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLVertexArrayObjectOES::s_info = { "WebGLVertexArrayObjectOES"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLVertexArrayObjectOES) };

JSWebGLVertexArrayObjectOES::JSWebGLVertexArrayObjectOES(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLVertexArrayObjectOES>&& impl)
    : JSDOMWrapper<WebGLVertexArrayObjectOES>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLVertexArrayObjectOES>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLVertexArrayObjectOES::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLVertexArrayObjectOESPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLVertexArrayObjectOESPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLVertexArrayObjectOES::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLVertexArrayObjectOES>(vm, globalObject);
}

void JSWebGLVertexArrayObjectOES::destroy(JSC::JSCell* cell)
{
    JSWebGLVertexArrayObjectOES* thisObject = static_cast<JSWebGLVertexArrayObjectOES*>(cell);
    thisObject->JSWebGLVertexArrayObjectOES::~JSWebGLVertexArrayObjectOES();
}

JSC::GCClient::IsoSubspace* JSWebGLVertexArrayObjectOES::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLVertexArrayObjectOES, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLVertexArrayObjectOES.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLVertexArrayObjectOES = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLVertexArrayObjectOES.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLVertexArrayObjectOES = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLVertexArrayObjectOES::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLVertexArrayObjectOES*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLVertexArrayObjectOESOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLVertexArrayObjectOES = jsCast<JSWebGLVertexArrayObjectOES*>(handle.slot()->asCell());
    WebGLVertexArrayObjectOES* owner = &jsWebGLVertexArrayObjectOES->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLVertexArrayObjectOES";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLVertexArrayObjectOESOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLVertexArrayObjectOES = static_cast<JSWebGLVertexArrayObjectOES*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLVertexArrayObjectOES->wrapped(), jsWebGLVertexArrayObjectOES);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLVertexArrayObjectOES@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25WebGLVertexArrayObjectOESE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLVertexArrayObjectOES>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLVertexArrayObjectOES>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLVertexArrayObjectOES@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25WebGLVertexArrayObjectOESE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLVertexArrayObjectOES has subclasses. If WebGLVertexArrayObjectOES has subclasses that get passed
        // to toJS() we currently require WebGLVertexArrayObjectOES you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLVertexArrayObjectOES>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLVertexArrayObjectOES& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLVertexArrayObjectOES* JSWebGLVertexArrayObjectOES::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLVertexArrayObjectOES*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
