/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLTransformFeedback.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebGLTransformFeedbackConstructor);

class JSWebGLTransformFeedbackPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLTransformFeedbackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLTransformFeedbackPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLTransformFeedbackPrototype>(vm)) JSWebGLTransformFeedbackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLTransformFeedbackPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLTransformFeedbackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLTransformFeedbackPrototype, JSWebGLTransformFeedbackPrototype::Base);

using JSWebGLTransformFeedbackDOMConstructor = JSDOMConstructorNotConstructable<JSWebGLTransformFeedback>;

template<> const ClassInfo JSWebGLTransformFeedbackDOMConstructor::s_info = { "WebGLTransformFeedback"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLTransformFeedbackDOMConstructor) };

template<> JSValue JSWebGLTransformFeedbackDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLTransformFeedbackDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebGLTransformFeedback"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebGLTransformFeedback::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLTransformFeedbackPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLTransformFeedbackConstructor, 0 } },
};

const ClassInfo JSWebGLTransformFeedbackPrototype::s_info = { "WebGLTransformFeedback"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLTransformFeedbackPrototype) };

void JSWebGLTransformFeedbackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLTransformFeedback::info(), JSWebGLTransformFeedbackPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLTransformFeedback::s_info = { "WebGLTransformFeedback"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLTransformFeedback) };

JSWebGLTransformFeedback::JSWebGLTransformFeedback(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLTransformFeedback>&& impl)
    : JSDOMWrapper<WebGLTransformFeedback>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLTransformFeedback>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLTransformFeedback::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLTransformFeedbackPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLTransformFeedbackPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLTransformFeedback::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLTransformFeedback>(vm, globalObject);
}

JSValue JSWebGLTransformFeedback::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLTransformFeedbackDOMConstructor, DOMConstructorID::WebGLTransformFeedback>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLTransformFeedback::destroy(JSC::JSCell* cell)
{
    JSWebGLTransformFeedback* thisObject = static_cast<JSWebGLTransformFeedback*>(cell);
    thisObject->JSWebGLTransformFeedback::~JSWebGLTransformFeedback();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLTransformFeedbackConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLTransformFeedbackPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLTransformFeedback::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSWebGLTransformFeedback::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLTransformFeedback, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLTransformFeedback.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLTransformFeedback = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLTransformFeedback.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLTransformFeedback = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLTransformFeedback::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLTransformFeedback*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLTransformFeedbackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLTransformFeedback = jsCast<JSWebGLTransformFeedback*>(handle.slot()->asCell());
    WebGLTransformFeedback* owner = &jsWebGLTransformFeedback->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLTransformFeedback";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLTransformFeedbackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLTransformFeedback = static_cast<JSWebGLTransformFeedback*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLTransformFeedback->wrapped(), jsWebGLTransformFeedback);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLTransformFeedback@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLTransformFeedbackE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLTransformFeedback>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLTransformFeedback>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLTransformFeedback@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22WebGLTransformFeedbackE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLTransformFeedback has subclasses. If WebGLTransformFeedback has subclasses that get passed
        // to toJS() we currently require WebGLTransformFeedback you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLTransformFeedback>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLTransformFeedback& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLTransformFeedback* JSWebGLTransformFeedback::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLTransformFeedback*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
