/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextEncoderStreamEncoder.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTextEncoderStreamEncoderPrototypeFunction_encode);
static JSC_DECLARE_HOST_FUNCTION(jsTextEncoderStreamEncoderPrototypeFunction_flush);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTextEncoderStreamEncoderConstructor);

class JSTextEncoderStreamEncoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTextEncoderStreamEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextEncoderStreamEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextEncoderStreamEncoderPrototype>(vm)) JSTextEncoderStreamEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextEncoderStreamEncoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextEncoderStreamEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTextEncoderStreamEncoderPrototype, JSTextEncoderStreamEncoderPrototype::Base);

using JSTextEncoderStreamEncoderDOMConstructor = JSDOMConstructor<JSTextEncoderStreamEncoder>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSTextEncoderStreamEncoderDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSTextEncoderStreamEncoderDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto object = TextEncoderStreamEncoder::create();
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<TextEncoderStreamEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<TextEncoderStreamEncoder>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSTextEncoderStreamEncoderDOMConstructorConstruct, JSTextEncoderStreamEncoderDOMConstructor::construct);

template<> const ClassInfo JSTextEncoderStreamEncoderDOMConstructor::s_info = { "TextEncoderStreamEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextEncoderStreamEncoderDOMConstructor) };

template<> JSValue JSTextEncoderStreamEncoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTextEncoderStreamEncoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TextEncoderStreamEncoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTextEncoderStreamEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSTextEncoderStreamEncoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTextEncoderStreamEncoderConstructor, 0 } },
};

const ClassInfo JSTextEncoderStreamEncoderPrototype::s_info = { "TextEncoderStreamEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextEncoderStreamEncoderPrototype) };

void JSTextEncoderStreamEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextEncoderStreamEncoder::info(), JSTextEncoderStreamEncoderPrototypeTableValues, *this);
    putDirect(vm, builtinNames(vm).encodePrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsTextEncoderStreamEncoderPrototypeFunction_encode, ImplementationVisibility::Public), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, builtinNames(vm).flushPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsTextEncoderStreamEncoderPrototypeFunction_flush, ImplementationVisibility::Public), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTextEncoderStreamEncoder::s_info = { "TextEncoderStreamEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTextEncoderStreamEncoder) };

JSTextEncoderStreamEncoder::JSTextEncoderStreamEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextEncoderStreamEncoder>&& impl)
    : JSDOMWrapper<TextEncoderStreamEncoder>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, TextEncoderStreamEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSTextEncoderStreamEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTextEncoderStreamEncoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSTextEncoderStreamEncoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSTextEncoderStreamEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTextEncoderStreamEncoder>(vm, globalObject);
}

JSValue JSTextEncoderStreamEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextEncoderStreamEncoderDOMConstructor, DOMConstructorID::TextEncoderStreamEncoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTextEncoderStreamEncoder::destroy(JSC::JSCell* cell)
{
    JSTextEncoderStreamEncoder* thisObject = static_cast<JSTextEncoderStreamEncoder*>(cell);
    thisObject->JSTextEncoderStreamEncoder::~JSTextEncoderStreamEncoder();
}

JSC_DEFINE_CUSTOM_GETTER(jsTextEncoderStreamEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTextEncoderStreamEncoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTextEncoderStreamEncoder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsTextEncoderStreamEncoderPrototypeFunction_encodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextEncoderStreamEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto chunk = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUint8Array>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.encode(WTFMove(chunk)))));
}

JSC_DEFINE_HOST_FUNCTION(jsTextEncoderStreamEncoderPrototypeFunction_encode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextEncoderStreamEncoder>::call<jsTextEncoderStreamEncoderPrototypeFunction_encodeBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "encode");
}

static inline JSC::EncodedJSValue jsTextEncoderStreamEncoderPrototypeFunction_flushBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTextEncoderStreamEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUint8Array>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.flush())));
}

JSC_DEFINE_HOST_FUNCTION(jsTextEncoderStreamEncoderPrototypeFunction_flush, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTextEncoderStreamEncoder>::call<jsTextEncoderStreamEncoderPrototypeFunction_flushBody, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, *callFrame, "flush");
}

JSC::GCClient::IsoSubspace* JSTextEncoderStreamEncoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTextEncoderStreamEncoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTextEncoderStreamEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTextEncoderStreamEncoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTextEncoderStreamEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTextEncoderStreamEncoder = std::forward<decltype(space)>(space); }
    );
}

void JSTextEncoderStreamEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTextEncoderStreamEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSTextEncoderStreamEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTextEncoderStreamEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextEncoderStreamEncoder = static_cast<JSTextEncoderStreamEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextEncoderStreamEncoder->wrapped(), jsTextEncoderStreamEncoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TextEncoderStreamEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24TextEncoderStreamEncoderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TextEncoderStreamEncoder>&& impl)
{

    if constexpr (std::is_polymorphic_v<TextEncoderStreamEncoder>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7TextEncoderStreamEncoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore24TextEncoderStreamEncoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // TextEncoderStreamEncoder has subclasses. If TextEncoderStreamEncoder has subclasses that get passed
        // to toJS() we currently require TextEncoderStreamEncoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<TextEncoderStreamEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TextEncoderStreamEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TextEncoderStreamEncoder* JSTextEncoderStreamEncoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextEncoderStreamEncoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
