/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGTextContentElement.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMPointInit.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getNumberOfChars);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getComputedTextLength);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getSubStringLength);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getStartPositionOfChar);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getEndPositionOfChar);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getExtentOfChar);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getRotationOfChar);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getCharNumAtPosition);
static JSC_DECLARE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_selectSubString);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextContentElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextContentElement_textLength);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGTextContentElement_lengthAdjust);

class JSSVGTextContentElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGTextContentElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGTextContentElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGTextContentElementPrototype>(vm)) JSSVGTextContentElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGTextContentElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGTextContentElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGTextContentElementPrototype, JSSVGTextContentElementPrototype::Base);

using JSSVGTextContentElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGTextContentElement>;

/* Hash table for constructor */

static const HashTableValue JSSVGTextContentElementConstructorTableValues[] =
{
    { "LENGTHADJUST_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "LENGTHADJUST_SPACING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "LENGTHADJUST_SPACINGANDGLYPHS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

static_assert(SVGTextContentElement::LENGTHADJUST_UNKNOWN == 0, "LENGTHADJUST_UNKNOWN in SVGTextContentElement does not match value from IDL");
static_assert(SVGTextContentElement::LENGTHADJUST_SPACING == 1, "LENGTHADJUST_SPACING in SVGTextContentElement does not match value from IDL");
static_assert(SVGTextContentElement::LENGTHADJUST_SPACINGANDGLYPHS == 2, "LENGTHADJUST_SPACINGANDGLYPHS in SVGTextContentElement does not match value from IDL");

template<> const ClassInfo JSSVGTextContentElementDOMConstructor::s_info = { "SVGTextContentElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextContentElementDOMConstructor) };

template<> JSValue JSSVGTextContentElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGraphicsElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGTextContentElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGTextContentElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGTextContentElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGTextContentElement::info(), JSSVGTextContentElementConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTextContentElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextContentElementConstructor, 0 } },
    { "textLength"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextContentElement_textLength, 0 } },
    { "lengthAdjust"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGTextContentElement_lengthAdjust, 0 } },
    { "getNumberOfChars"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_getNumberOfChars, 0 } },
    { "getComputedTextLength"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_getComputedTextLength, 0 } },
    { "getSubStringLength"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_getSubStringLength, 2 } },
    { "getStartPositionOfChar"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_getStartPositionOfChar, 1 } },
    { "getEndPositionOfChar"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_getEndPositionOfChar, 1 } },
    { "getExtentOfChar"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_getExtentOfChar, 1 } },
    { "getRotationOfChar"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_getRotationOfChar, 1 } },
    { "getCharNumAtPosition"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_getCharNumAtPosition, 0 } },
    { "selectSubString"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGTextContentElementPrototypeFunction_selectSubString, 2 } },
    { "LENGTHADJUST_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "LENGTHADJUST_SPACING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "LENGTHADJUST_SPACINGANDGLYPHS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

const ClassInfo JSSVGTextContentElementPrototype::s_info = { "SVGTextContentElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextContentElementPrototype) };

void JSSVGTextContentElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGTextContentElement::info(), JSSVGTextContentElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGTextContentElement::s_info = { "SVGTextContentElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGTextContentElement) };

JSSVGTextContentElement::JSSVGTextContentElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGTextContentElement>&& impl)
    : JSSVGGraphicsElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGTextContentElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGTextContentElementPrototype::createStructure(vm, &globalObject, JSSVGGraphicsElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGTextContentElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGTextContentElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGTextContentElement>(vm, globalObject);
}

JSValue JSSVGTextContentElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextContentElementDOMConstructor, DOMConstructorID::SVGTextContentElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextContentElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGTextContentElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGTextContentElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGTextContentElement_textLengthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextContentElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.textLengthAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextContentElement_textLength, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTextContentElement>::get<jsSVGTextContentElement_textLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGTextContentElement_lengthAdjustGetter(JSGlobalObject& lexicalGlobalObject, JSSVGTextContentElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.lengthAdjustAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGTextContentElement_lengthAdjust, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGTextContentElement>::get<jsSVGTextContentElement_lengthAdjustGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_getNumberOfCharsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.getNumberOfChars())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getNumberOfChars, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_getNumberOfCharsBody>(*lexicalGlobalObject, *callFrame, "getNumberOfChars");
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_getComputedTextLengthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getComputedTextLength())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getComputedTextLength, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_getComputedTextLengthBody>(*lexicalGlobalObject, *callFrame, "getComputedTextLength");
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_getSubStringLengthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto charnum = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto nchars = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getSubStringLength(WTFMove(charnum), WTFMove(nchars)))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getSubStringLength, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_getSubStringLengthBody>(*lexicalGlobalObject, *callFrame, "getSubStringLength");
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_getStartPositionOfCharBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto charnum = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getStartPositionOfChar(WTFMove(charnum)))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getStartPositionOfChar, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_getStartPositionOfCharBody>(*lexicalGlobalObject, *callFrame, "getStartPositionOfChar");
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_getEndPositionOfCharBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto charnum = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getEndPositionOfChar(WTFMove(charnum)))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getEndPositionOfChar, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_getEndPositionOfCharBody>(*lexicalGlobalObject, *callFrame, "getEndPositionOfChar");
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_getExtentOfCharBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto charnum = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getExtentOfChar(WTFMove(charnum)))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getExtentOfChar, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_getExtentOfCharBody>(*lexicalGlobalObject, *callFrame, "getExtentOfChar");
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_getRotationOfCharBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto charnum = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.getRotationOfChar(WTFMove(charnum)))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getRotationOfChar, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_getRotationOfCharBody>(*lexicalGlobalObject, *callFrame, "getRotationOfChar");
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_getCharNumAtPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto point = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.getCharNumAtPosition(WTFMove(point)))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_getCharNumAtPosition, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_getCharNumAtPositionBody>(*lexicalGlobalObject, *callFrame, "getCharNumAtPosition");
}

static inline JSC::EncodedJSValue jsSVGTextContentElementPrototypeFunction_selectSubStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGTextContentElement>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto charnum = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto nchars = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.selectSubString(WTFMove(charnum), WTFMove(nchars)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGTextContentElementPrototypeFunction_selectSubString, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGTextContentElement>::call<jsSVGTextContentElementPrototypeFunction_selectSubStringBody>(*lexicalGlobalObject, *callFrame, "selectSubString");
}

JSC::GCClient::IsoSubspace* JSSVGTextContentElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGTextContentElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGTextContentElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGTextContentElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGTextContentElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGTextContentElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGTextContentElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGTextContentElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
