/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOscillatorOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSOscillatorType.h"
#include "JSPeriodicWave.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> OscillatorOptions convertDictionary<OscillatorOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    OscillatorOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountValue.isUndefined()) {
        result.channelCount = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountModeValue.isUndefined()) {
        result.channelCountMode = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        result.channelInterpretation = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue detuneValue;
    if (isNullOrUndefined)
        detuneValue = jsUndefined();
    else {
        detuneValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detune"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detuneValue.isUndefined()) {
        result.detune = convert<IDLFloat>(lexicalGlobalObject, detuneValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detune = 0;
    JSValue frequencyValue;
    if (isNullOrUndefined)
        frequencyValue = jsUndefined();
    else {
        frequencyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frequency"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frequencyValue.isUndefined()) {
        result.frequency = convert<IDLFloat>(lexicalGlobalObject, frequencyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.frequency = 440;
    JSValue periodicWaveValue;
    if (isNullOrUndefined)
        periodicWaveValue = jsUndefined();
    else {
        periodicWaveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "periodicWave"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!periodicWaveValue.isUndefined()) {
        result.periodicWave = convert<IDLInterface<PeriodicWave>>(lexicalGlobalObject, periodicWaveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<OscillatorType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.type = OscillatorType::Sine;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
