/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMutationObserver.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSMutationCallback.h"
#include "JSMutationRecord.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> MutationObserver::Init convertDictionary<MutationObserver::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MutationObserver::Init result;
    JSValue attributeFilterValue;
    if (isNullOrUndefined)
        attributeFilterValue = jsUndefined();
    else {
        attributeFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributeFilter"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attributeFilterValue.isUndefined()) {
        result.attributeFilter = convert<IDLSequence<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, attributeFilterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue attributeOldValueValue;
    if (isNullOrUndefined)
        attributeOldValueValue = jsUndefined();
    else {
        attributeOldValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributeOldValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attributeOldValueValue.isUndefined()) {
        result.attributeOldValue = convert<IDLBoolean>(lexicalGlobalObject, attributeOldValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue attributesValue;
    if (isNullOrUndefined)
        attributesValue = jsUndefined();
    else {
        attributesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributes"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attributesValue.isUndefined()) {
        result.attributes = convert<IDLBoolean>(lexicalGlobalObject, attributesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue characterDataValue;
    if (isNullOrUndefined)
        characterDataValue = jsUndefined();
    else {
        characterDataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "characterData"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!characterDataValue.isUndefined()) {
        result.characterData = convert<IDLBoolean>(lexicalGlobalObject, characterDataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue characterDataOldValueValue;
    if (isNullOrUndefined)
        characterDataOldValueValue = jsUndefined();
    else {
        characterDataOldValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "characterDataOldValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!characterDataOldValueValue.isUndefined()) {
        result.characterDataOldValue = convert<IDLBoolean>(lexicalGlobalObject, characterDataOldValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue childListValue;
    if (isNullOrUndefined)
        childListValue = jsUndefined();
    else {
        childListValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "childList"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!childListValue.isUndefined()) {
        result.childList = convert<IDLBoolean>(lexicalGlobalObject, childListValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.childList = false;
    JSValue subtreeValue;
    if (isNullOrUndefined)
        subtreeValue = jsUndefined();
    else {
        subtreeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "subtree"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!subtreeValue.isUndefined()) {
        result.subtree = convert<IDLBoolean>(lexicalGlobalObject, subtreeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.subtree = false;
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMutationObserverPrototypeFunction_observe);
static JSC_DECLARE_HOST_FUNCTION(jsMutationObserverPrototypeFunction_disconnect);
static JSC_DECLARE_HOST_FUNCTION(jsMutationObserverPrototypeFunction_takeRecords);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMutationObserverConstructor);

class JSMutationObserverPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMutationObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMutationObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSMutationObserverPrototype>(vm)) JSMutationObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMutationObserverPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMutationObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMutationObserverPrototype, JSMutationObserverPrototype::Base);

using JSMutationObserverDOMConstructor = JSDOMConstructor<JSMutationObserver>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSMutationObserverDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSMutationObserverDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callback = convert<IDLCallbackFunction<JSMutationCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "MutationObserver", nullptr); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = MutationObserver::create(callback.releaseNonNull());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<MutationObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<MutationObserver>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSMutationObserverDOMConstructorConstruct, JSMutationObserverDOMConstructor::construct);

template<> const ClassInfo JSMutationObserverDOMConstructor::s_info = { "MutationObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationObserverDOMConstructor) };

template<> JSValue JSMutationObserverDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMutationObserverDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MutationObserver"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMutationObserver::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSMutationObserverPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMutationObserverConstructor, 0 } },
    { "observe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMutationObserverPrototypeFunction_observe, 1 } },
    { "disconnect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMutationObserverPrototypeFunction_disconnect, 0 } },
    { "takeRecords"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMutationObserverPrototypeFunction_takeRecords, 0 } },
};

const ClassInfo JSMutationObserverPrototype::s_info = { "MutationObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationObserverPrototype) };

void JSMutationObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMutationObserver::info(), JSMutationObserverPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMutationObserver::s_info = { "MutationObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationObserver) };

JSMutationObserver::JSMutationObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MutationObserver>&& impl)
    : JSDOMWrapper<MutationObserver>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMutationObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMutationObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSMutationObserverPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMutationObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMutationObserver>(vm, globalObject);
}

JSValue JSMutationObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMutationObserverDOMConstructor, DOMConstructorID::MutationObserver>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMutationObserver::destroy(JSC::JSCell* cell)
{
    JSMutationObserver* thisObject = static_cast<JSMutationObserver*>(cell);
    thisObject->JSMutationObserver::~JSMutationObserver();
}

JSC_DEFINE_CUSTOM_GETTER(jsMutationObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMutationObserverPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMutationObserver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsMutationObserverPrototypeFunction_observeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMutationObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "MutationObserver", "observe", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<MutationObserver::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.observe(*target, WTFMove(options)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMutationObserverPrototypeFunction_observe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMutationObserver>::call<jsMutationObserverPrototypeFunction_observeBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsMutationObserverPrototypeFunction_disconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMutationObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMutationObserverPrototypeFunction_disconnect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMutationObserver>::call<jsMutationObserverPrototypeFunction_disconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

static inline JSC::EncodedJSValue jsMutationObserverPrototypeFunction_takeRecordsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMutationObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto implResult = impl.takeRecords();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<MutationRecord>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(implResult.records))));
}

JSC_DEFINE_HOST_FUNCTION(jsMutationObserverPrototypeFunction_takeRecords, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMutationObserver>::call<jsMutationObserverPrototypeFunction_takeRecordsBody>(*lexicalGlobalObject, *callFrame, "takeRecords");
}

JSC::GCClient::IsoSubspace* JSMutationObserver::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMutationObserver, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMutationObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMutationObserver = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMutationObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMutationObserver = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSMutationObserver::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSMutationObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSMutationObserver);

template<typename Visitor>
void JSMutationObserver::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSMutationObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSMutationObserver::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSMutationObserver::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSMutationObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMutationObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSMutationObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMutationObserver = static_cast<JSMutationObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMutationObserver->wrapped(), jsMutationObserver);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MutationObserver@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16MutationObserverE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MutationObserver>&& impl)
{

    if constexpr (std::is_polymorphic_v<MutationObserver>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MutationObserver@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16MutationObserverE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MutationObserver has subclasses. If MutationObserver has subclasses that get passed
        // to toJS() we currently require MutationObserver you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<MutationObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MutationObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MutationObserver* JSMutationObserver::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMutationObserver*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
