/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBObjectStore.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMStringList.h"
#include "JSDOMWrapperCache.h"
#include "JSIDBCursorDirection.h"
#include "JSIDBIndex.h"
#include "JSIDBKeyRange.h"
#include "JSIDBRequest.h"
#include "JSIDBTransaction.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> IDBObjectStore::IndexParameters convertDictionary<IDBObjectStore::IndexParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    IDBObjectStore::IndexParameters result;
    JSValue multiEntryValue;
    if (isNullOrUndefined)
        multiEntryValue = jsUndefined();
    else {
        multiEntryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "multiEntry"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!multiEntryValue.isUndefined()) {
        result.multiEntry = convert<IDLBoolean>(lexicalGlobalObject, multiEntryValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.multiEntry = false;
    JSValue uniqueValue;
    if (isNullOrUndefined)
        uniqueValue = jsUndefined();
    else {
        uniqueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "unique"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!uniqueValue.isUndefined()) {
        result.unique = convert<IDLBoolean>(lexicalGlobalObject, uniqueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.unique = false;
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_put);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_add);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_delete);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_clear);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_get);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_getKey);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_getAll);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_getAllKeys);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_count);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_openCursor);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_openKeyCursor);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_index);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_createIndex);
static JSC_DECLARE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_deleteIndex);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIDBObjectStoreConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBObjectStore_name);
static JSC_DECLARE_CUSTOM_SETTER(setJSIDBObjectStore_name);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBObjectStore_keyPath);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBObjectStore_indexNames);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBObjectStore_transaction);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBObjectStore_autoIncrement);

class JSIDBObjectStorePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBObjectStorePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBObjectStorePrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBObjectStorePrototype>(vm)) JSIDBObjectStorePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBObjectStorePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBObjectStorePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBObjectStorePrototype, JSIDBObjectStorePrototype::Base);

using JSIDBObjectStoreDOMConstructor = JSDOMConstructorNotConstructable<JSIDBObjectStore>;

template<> const ClassInfo JSIDBObjectStoreDOMConstructor::s_info = { "IDBObjectStore"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBObjectStoreDOMConstructor) };

template<> JSValue JSIDBObjectStoreDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBObjectStoreDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IDBObjectStore"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIDBObjectStore::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSIDBObjectStorePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBObjectStoreConstructor, 0 } },
    { "name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBObjectStore_name, setJSIDBObjectStore_name } },
    { "keyPath"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBObjectStore_keyPath, 0 } },
    { "indexNames"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBObjectStore_indexNames, 0 } },
    { "transaction"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBObjectStore_transaction, 0 } },
    { "autoIncrement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBObjectStore_autoIncrement, 0 } },
    { "put"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_put, 1 } },
    { "add"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_add, 1 } },
    { "delete"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_delete, 1 } },
    { "clear"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_clear, 0 } },
    { "get"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_get, 1 } },
    { "getKey"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_getKey, 1 } },
    { "getAll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_getAll, 0 } },
    { "getAllKeys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_getAllKeys, 0 } },
    { "count"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_count, 0 } },
    { "openCursor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_openCursor, 0 } },
    { "openKeyCursor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_openKeyCursor, 0 } },
    { "index"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_index, 1 } },
    { "createIndex"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_createIndex, 2 } },
    { "deleteIndex"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBObjectStorePrototypeFunction_deleteIndex, 1 } },
};

const ClassInfo JSIDBObjectStorePrototype::s_info = { "IDBObjectStore"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBObjectStorePrototype) };

void JSIDBObjectStorePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBObjectStore::info(), JSIDBObjectStorePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIDBObjectStore::s_info = { "IDBObjectStore"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBObjectStore) };

JSIDBObjectStore::JSIDBObjectStore(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBObjectStore>&& impl)
    : JSDOMWrapper<IDBObjectStore>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, IDBObjectStore>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSIDBObjectStore::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIDBObjectStorePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSIDBObjectStorePrototype::create(vm, &globalObject, structure);
}

JSObject* JSIDBObjectStore::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBObjectStore>(vm, globalObject);
}

JSValue JSIDBObjectStore::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBObjectStoreDOMConstructor, DOMConstructorID::IDBObjectStore>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBObjectStore::destroy(JSC::JSCell* cell)
{
    JSIDBObjectStore* thisObject = static_cast<JSIDBObjectStore*>(cell);
    thisObject->JSIDBObjectStore::~JSIDBObjectStore();
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBObjectStoreConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBObjectStorePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBObjectStore::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsIDBObjectStore_nameGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBObjectStore_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStore_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSIDBObjectStore_nameSetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setName(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSIDBObjectStore_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBObjectStore>::set<setJSIDBObjectStore_nameSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsIDBObjectStore_keyPathGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    if (JSValue cachedValue = thisObject.m_keyPath.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.keyPath());
    RETURN_IF_EXCEPTION(throwScope, { });
    thisObject.m_keyPath.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBObjectStore_keyPath, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStore_keyPathGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBObjectStore_indexNamesGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.indexNames())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBObjectStore_indexNames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStore_indexNamesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBObjectStore_transactionGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<IDBTransaction>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.transaction())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBObjectStore_transaction, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStore_transactionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBObjectStore_autoIncrementGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.autoIncrement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBObjectStore_autoIncrement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStore_autoIncrementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_putBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.put(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(value), WTFMove(key)))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_put, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_putBody>(*lexicalGlobalObject, *callFrame, "put");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_addBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto value = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.add(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(value), WTFMove(key)))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_add, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_addBody>(*lexicalGlobalObject, *callFrame, "add");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_delete1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyRange = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "keyRange", "IDBObjectStore", "delete", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.deleteFunction(WTFMove(keyRange)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_delete2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.deleteFunction(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_deleteOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_delete1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_delete1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_delete2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_delete, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_deleteOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "delete");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_clearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clear())));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_clear, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_clearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_get1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "key", "IDBObjectStore", "get", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_get2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_get1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_get1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_get2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_get, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_getOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getKey1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "key", "IDBObjectStore", "getKey", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getKey2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getKeyOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getKey1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getKey1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getKey2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_getKey, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_getKeyOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getKey");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getAll1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "getAll", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto count = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(WTFMove(range), WTFMove(count)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getAll2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto count = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(count)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getAllOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAll2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_getAll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_getAllOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getAll");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getAllKeys1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "getAllKeys", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto count = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAllKeys(WTFMove(range), WTFMove(count)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getAllKeys2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto count = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAllKeys(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(count)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_getAllKeysOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_getAllKeys2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_getAllKeys, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_getAllKeysOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getAllKeys");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_count1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "count", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.count(WTFMove(range)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_count2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.count(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_countOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_count1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_count1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_count1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_count1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_count2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_count, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_countOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "count");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_openCursor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "openCursor", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto direction = argument1.value().isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBObjectStore", "openCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openCursor(WTFMove(range), WTFMove(direction)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_openCursor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto direction = argument1.value().isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBObjectStore", "openCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(direction)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_openCursorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openCursor2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_openCursor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_openCursorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "openCursor");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_openKeyCursor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "openKeyCursor", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto direction = argument1.value().isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBObjectStore", "openKeyCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openKeyCursor(WTFMove(range), WTFMove(direction)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_openKeyCursor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto direction = argument1.value().isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBObjectStore", "openKeyCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openKeyCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(direction)))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_openKeyCursorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBObjectStorePrototypeFunction_openKeyCursor2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_openKeyCursor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_openKeyCursorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "openKeyCursor");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_indexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<IDBIndex>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.index(WTFMove(name)))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_index, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_indexBody>(*lexicalGlobalObject, *callFrame, "index");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_createIndexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto keyPath = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto options = convert<IDLDictionary<IDBObjectStore::IndexParameters>>(*lexicalGlobalObject, argument2.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBIndex>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createIndex(WTFMove(name), WTFMove(keyPath), WTFMove(options)))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_createIndex, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_createIndexBody>(*lexicalGlobalObject, *callFrame, "createIndex");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunction_deleteIndexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteIndex(WTFMove(name)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBObjectStorePrototypeFunction_deleteIndex, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunction_deleteIndexBody>(*lexicalGlobalObject, *callFrame, "deleteIndex");
}

JSC::GCClient::IsoSubspace* JSIDBObjectStore::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIDBObjectStore, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIDBObjectStore.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIDBObjectStore = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIDBObjectStore.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIDBObjectStore = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSIDBObjectStore::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIDBObjectStore*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
    visitor.append(thisObject->m_keyPath);
}

DEFINE_VISIT_CHILDREN(JSIDBObjectStore);

template<typename Visitor>
void JSIDBObjectStore::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIDBObjectStore*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSIDBObjectStore::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSIDBObjectStore::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSIDBObjectStore::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBObjectStore*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBObjectStoreOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsIDBObjectStore = jsCast<JSIDBObjectStore*>(handle.slot()->asCell());
    auto& wrapped = jsIDBObjectStore->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    IDBObjectStore* owner = &jsIDBObjectStore->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from IDBObjectStore";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSIDBObjectStoreOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBObjectStore = static_cast<JSIDBObjectStore*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBObjectStore->wrapped(), jsIDBObjectStore);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBObjectStore>&& impl)
{
    return createWrapper<IDBObjectStore>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBObjectStore& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBObjectStore* JSIDBObjectStore::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBObjectStore*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
