/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBIndex.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSIDBCursorDirection.h"
#include "JSIDBKeyRange.h"
#include "JSIDBObjectStore.h"
#include "JSIDBRequest.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_get);
static JSC_DECLARE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_getKey);
static JSC_DECLARE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_getAll);
static JSC_DECLARE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_getAllKeys);
static JSC_DECLARE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_count);
static JSC_DECLARE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_openCursor);
static JSC_DECLARE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_openKeyCursor);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIDBIndexConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBIndex_name);
static JSC_DECLARE_CUSTOM_SETTER(setJSIDBIndex_name);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBIndex_objectStore);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBIndex_keyPath);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBIndex_multiEntry);
static JSC_DECLARE_CUSTOM_GETTER(jsIDBIndex_unique);

class JSIDBIndexPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBIndexPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBIndexPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBIndexPrototype>(vm)) JSIDBIndexPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBIndexPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBIndexPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBIndexPrototype, JSIDBIndexPrototype::Base);

using JSIDBIndexDOMConstructor = JSDOMConstructorNotConstructable<JSIDBIndex>;

template<> const ClassInfo JSIDBIndexDOMConstructor::s_info = { "IDBIndex"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBIndexDOMConstructor) };

template<> JSValue JSIDBIndexDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBIndexDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IDBIndex"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIDBIndex::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSIDBIndexPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBIndexConstructor, 0 } },
    { "name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBIndex_name, setJSIDBIndex_name } },
    { "objectStore"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBIndex_objectStore, 0 } },
    { "keyPath"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBIndex_keyPath, 0 } },
    { "multiEntry"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBIndex_multiEntry, 0 } },
    { "unique"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBIndex_unique, 0 } },
    { "get"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBIndexPrototypeFunction_get, 1 } },
    { "getKey"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBIndexPrototypeFunction_getKey, 1 } },
    { "getAll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBIndexPrototypeFunction_getAll, 0 } },
    { "getAllKeys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBIndexPrototypeFunction_getAllKeys, 0 } },
    { "count"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBIndexPrototypeFunction_count, 0 } },
    { "openCursor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBIndexPrototypeFunction_openCursor, 0 } },
    { "openKeyCursor"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBIndexPrototypeFunction_openKeyCursor, 0 } },
};

const ClassInfo JSIDBIndexPrototype::s_info = { "IDBIndex"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBIndexPrototype) };

void JSIDBIndexPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBIndex::info(), JSIDBIndexPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIDBIndex::s_info = { "IDBIndex"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBIndex) };

JSIDBIndex::JSIDBIndex(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBIndex>&& impl)
    : JSDOMWrapper<IDBIndex>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, IDBIndex>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSIDBIndex::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIDBIndexPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSIDBIndexPrototype::create(vm, &globalObject, structure);
}

JSObject* JSIDBIndex::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBIndex>(vm, globalObject);
}

JSValue JSIDBIndex::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBIndexDOMConstructor, DOMConstructorID::IDBIndex>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBIndex::destroy(JSC::JSCell* cell)
{
    JSIDBIndex* thisObject = static_cast<JSIDBIndex*>(cell);
    thisObject->JSIDBIndex::~JSIDBIndex();
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBIndexConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBIndexPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBIndex::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsIDBIndex_nameGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBIndex_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndex_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSIDBIndex_nameSetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setName(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSIDBIndex_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBIndex>::set<setJSIDBIndex_nameSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsIDBIndex_objectStoreGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<IDBObjectStore>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.objectStore())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBIndex_objectStore, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndex_objectStoreGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBIndex_keyPathGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    if (JSValue cachedValue = thisObject.m_keyPath.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.keyPath());
    RETURN_IF_EXCEPTION(throwScope, { });
    thisObject.m_keyPath.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBIndex_keyPath, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndex_keyPathGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBIndex_multiEntryGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.multiEntry())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBIndex_multiEntry, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndex_multiEntryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsIDBIndex_uniqueGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.unique())));
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBIndex_unique, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndex_uniqueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_get1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "key", "IDBIndex", "get", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_get2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_get1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_get1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_get2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_get, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunction_getOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getKey1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "key", "IDBIndex", "getKey", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getKey2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getKeyOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getKey1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getKey1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getKey2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_getKey, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunction_getKeyOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getKey");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getAll1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "getAll", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto count = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(WTFMove(range), WTFMove(count)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getAll2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto count = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(count)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getAllOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAll2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_getAll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunction_getAllOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getAll");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getAllKeys1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "getAllKeys", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto count = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAllKeys(WTFMove(range), WTFMove(count)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getAllKeys2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto count = argument1.value().isUndefined() ? std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : std::optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAllKeys(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(count)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_getAllKeysOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_getAllKeys2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_getAllKeys, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunction_getAllKeysOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getAllKeys");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_count1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "count", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.count(WTFMove(range)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_count2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.count(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_countOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_count1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_count1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_count1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_count1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_count2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_count, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunction_countOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "count");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_openCursor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "openCursor", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto direction = argument1.value().isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBIndex", "openCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openCursor(WTFMove(range), WTFMove(direction)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_openCursor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto direction = argument1.value().isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBIndex", "openCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(direction)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_openCursorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openCursor2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_openCursor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunction_openCursorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "openCursor");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_openKeyCursor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "openKeyCursor", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto direction = argument1.value().isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBIndex", "openKeyCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openKeyCursor(WTFMove(range), WTFMove(direction)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_openKeyCursor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto key = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto direction = argument1.value().isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBIndex", "openKeyCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openKeyCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(direction)))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunction_openKeyCursorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>())
            RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsIDBIndexPrototypeFunction_openKeyCursor2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsIDBIndexPrototypeFunction_openKeyCursor, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunction_openKeyCursorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "openKeyCursor");
}

JSC::GCClient::IsoSubspace* JSIDBIndex::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIDBIndex, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIDBIndex.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIDBIndex = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIDBIndex.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIDBIndex = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSIDBIndex::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSIDBIndex*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    addWebCoreOpaqueRoot(visitor, thisObject->wrapped().opaqueRoot());
    visitor.append(thisObject->m_keyPath);
}

DEFINE_VISIT_CHILDREN(JSIDBIndex);

void JSIDBIndex::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBIndex*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBIndexOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsIDBIndex = jsCast<JSIDBIndex*>(handle.slot()->asCell());
    auto& wrapped = jsIDBIndex->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    IDBIndex* owner = &jsIDBIndex->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from IDBIndex";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSIDBIndexOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBIndex = static_cast<JSIDBIndex*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBIndex->wrapped(), jsIDBIndex);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBIndex>&& impl)
{
    return createWrapper<IDBIndex>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBIndex& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBIndex* JSIDBIndex::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBIndex*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
