/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD)

#include "JSGamepadButton.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGamepadButtonConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGamepadButton_pressed);
static JSC_DECLARE_CUSTOM_GETTER(jsGamepadButton_value);

class JSGamepadButtonPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGamepadButtonPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGamepadButtonPrototype* ptr = new (NotNull, JSC::allocateCell<JSGamepadButtonPrototype>(vm)) JSGamepadButtonPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGamepadButtonPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGamepadButtonPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGamepadButtonPrototype, JSGamepadButtonPrototype::Base);

using JSGamepadButtonDOMConstructor = JSDOMConstructorNotConstructable<JSGamepadButton>;

template<> const ClassInfo JSGamepadButtonDOMConstructor::s_info = { "GamepadButton"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGamepadButtonDOMConstructor) };

template<> JSValue JSGamepadButtonDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGamepadButtonDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GamepadButton"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGamepadButton::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGamepadButtonPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGamepadButtonConstructor, 0 } },
    { "pressed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGamepadButton_pressed, 0 } },
    { "value"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGamepadButton_value, 0 } },
};

const ClassInfo JSGamepadButtonPrototype::s_info = { "GamepadButton"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGamepadButtonPrototype) };

void JSGamepadButtonPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGamepadButton::info(), JSGamepadButtonPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGamepadButton::s_info = { "GamepadButton"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGamepadButton) };

JSGamepadButton::JSGamepadButton(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GamepadButton>&& impl)
    : JSDOMWrapper<GamepadButton>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GamepadButton>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGamepadButton::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGamepadButtonPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGamepadButtonPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGamepadButton::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGamepadButton>(vm, globalObject);
}

JSValue JSGamepadButton::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGamepadButtonDOMConstructor, DOMConstructorID::GamepadButton>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGamepadButton::destroy(JSC::JSCell* cell)
{
    JSGamepadButton* thisObject = static_cast<JSGamepadButton*>(cell);
    thisObject->JSGamepadButton::~JSGamepadButton();
}

JSC_DEFINE_CUSTOM_GETTER(jsGamepadButtonConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGamepadButtonPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGamepadButton::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGamepadButton_pressedGetter(JSGlobalObject& lexicalGlobalObject, JSGamepadButton& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.pressed())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGamepadButton_pressed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGamepadButton>::get<jsGamepadButton_pressedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGamepadButton_valueGetter(JSGlobalObject& lexicalGlobalObject, JSGamepadButton& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.value())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGamepadButton_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGamepadButton>::get<jsGamepadButton_valueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGamepadButton::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGamepadButton, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGamepadButton.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGamepadButton = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGamepadButton.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGamepadButton = std::forward<decltype(space)>(space); }
    );
}

void JSGamepadButton::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGamepadButton*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGamepadButtonOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGamepadButtonOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGamepadButton = static_cast<JSGamepadButton*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGamepadButton->wrapped(), jsGamepadButton);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GamepadButton@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13GamepadButtonE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GamepadButton>&& impl)
{

    if constexpr (std::is_polymorphic_v<GamepadButton>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GamepadButton@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13GamepadButtonE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GamepadButton has subclasses. If GamepadButton has subclasses that get passed
        // to toJS() we currently require GamepadButton you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GamepadButton>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GamepadButton& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GamepadButton* JSGamepadButton::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGamepadButton*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GAMEPAD)
