/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureBindingLayout.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSGPUTextureSampleType.h"
#include "JSGPUTextureViewDimension.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUTextureBindingLayout convertDictionary<GPUTextureBindingLayout>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUTextureBindingLayout result;
    JSValue multisampledValue;
    if (isNullOrUndefined)
        multisampledValue = jsUndefined();
    else {
        multisampledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "multisampled"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!multisampledValue.isUndefined()) {
        result.multisampled = convert<IDLBoolean>(lexicalGlobalObject, multisampledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.multisampled = false;
    JSValue sampleTypeValue;
    if (isNullOrUndefined)
        sampleTypeValue = jsUndefined();
    else {
        sampleTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleType"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleTypeValue.isUndefined()) {
        result.sampleType = convert<IDLEnumeration<GPUTextureSampleType>>(lexicalGlobalObject, sampleTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sampleType = GPUTextureSampleType::Float;
    JSValue viewDimensionValue;
    if (isNullOrUndefined)
        viewDimensionValue = jsUndefined();
    else {
        viewDimensionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewDimension"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewDimensionValue.isUndefined()) {
        result.viewDimension = convert<IDLEnumeration<GPUTextureViewDimension>>(lexicalGlobalObject, viewDimensionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.viewDimension = GPUTextureViewDimension::_2d;
    return result;
}

} // namespace WebCore
