/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUSamplerDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUAddressMode.h"
#include "JSGPUCompareFunction.h"
#include "JSGPUFilterMode.h"
#include "JSGPUMipmapFilterMode.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUSamplerDescriptor convertDictionary<GPUSamplerDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUSamplerDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue addressModeUValue;
    if (isNullOrUndefined)
        addressModeUValue = jsUndefined();
    else {
        addressModeUValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeU"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!addressModeUValue.isUndefined()) {
        result.addressModeU = convert<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeUValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.addressModeU = GPUAddressMode::ClampToEdge;
    JSValue addressModeVValue;
    if (isNullOrUndefined)
        addressModeVValue = jsUndefined();
    else {
        addressModeVValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeV"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!addressModeVValue.isUndefined()) {
        result.addressModeV = convert<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeVValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.addressModeV = GPUAddressMode::ClampToEdge;
    JSValue addressModeWValue;
    if (isNullOrUndefined)
        addressModeWValue = jsUndefined();
    else {
        addressModeWValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeW"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!addressModeWValue.isUndefined()) {
        result.addressModeW = convert<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeWValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.addressModeW = GPUAddressMode::ClampToEdge;
    JSValue compareValue;
    if (isNullOrUndefined)
        compareValue = jsUndefined();
    else {
        compareValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "compare"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compareValue.isUndefined()) {
        result.compare = convert<IDLEnumeration<GPUCompareFunction>>(lexicalGlobalObject, compareValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue lodMaxClampValue;
    if (isNullOrUndefined)
        lodMaxClampValue = jsUndefined();
    else {
        lodMaxClampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lodMaxClamp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!lodMaxClampValue.isUndefined()) {
        result.lodMaxClamp = convert<IDLFloat>(lexicalGlobalObject, lodMaxClampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.lodMaxClamp = 32;
    JSValue lodMinClampValue;
    if (isNullOrUndefined)
        lodMinClampValue = jsUndefined();
    else {
        lodMinClampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lodMinClamp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!lodMinClampValue.isUndefined()) {
        result.lodMinClamp = convert<IDLFloat>(lexicalGlobalObject, lodMinClampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.lodMinClamp = 0;
    JSValue magFilterValue;
    if (isNullOrUndefined)
        magFilterValue = jsUndefined();
    else {
        magFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "magFilter"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!magFilterValue.isUndefined()) {
        result.magFilter = convert<IDLEnumeration<GPUFilterMode>>(lexicalGlobalObject, magFilterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.magFilter = GPUFilterMode::Nearest;
    JSValue maxAnisotropyValue;
    if (isNullOrUndefined)
        maxAnisotropyValue = jsUndefined();
    else {
        maxAnisotropyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxAnisotropy"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxAnisotropyValue.isUndefined()) {
        result.maxAnisotropy = convert<IDLClampAdaptor<IDLUnsignedShort>>(lexicalGlobalObject, maxAnisotropyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.maxAnisotropy = 1;
    JSValue minFilterValue;
    if (isNullOrUndefined)
        minFilterValue = jsUndefined();
    else {
        minFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minFilter"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!minFilterValue.isUndefined()) {
        result.minFilter = convert<IDLEnumeration<GPUFilterMode>>(lexicalGlobalObject, minFilterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.minFilter = GPUFilterMode::Nearest;
    JSValue mipmapFilterValue;
    if (isNullOrUndefined)
        mipmapFilterValue = jsUndefined();
    else {
        mipmapFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipmapFilter"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mipmapFilterValue.isUndefined()) {
        result.mipmapFilter = convert<IDLEnumeration<GPUMipmapFilterMode>>(lexicalGlobalObject, mipmapFilterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.mipmapFilter = GPUMipmapFilterMode::Nearest;
    return result;
}

} // namespace WebCore
